/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JOrbisComment {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$metadata$JOrbisComment == null ? (class$com$limegroup$gnutella$metadata$JOrbisComment = JOrbisComment.class$("com.limegroup.gnutella.metadata.JOrbisComment")) : class$com$limegroup$gnutella$metadata$JOrbisComment));
    private State state = null;
    private static int CHUNKSIZE = 4096;
    static /* synthetic */ Class class$com$limegroup$gnutella$metadata$JOrbisComment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Comment comment, File file) throws IOException {
        IOException ignored22;
        File tempFile;
        InputStream in;
        block15: {
            in = null;
            OutputStream out = null;
            tempFile = null;
            try {
                this.state = new State();
                in = new BufferedInputStream(new FileInputStream(file));
                this.read(in);
                this.state.vc = comment;
                tempFile = null;
                try {
                    tempFile = File.createTempFile(file.getName(), "tmp");
                }
                catch (IOException e) {
                    LOG.debug((Object)"couldn't create temp file in $TEMP, trying elsewhere");
                    tempFile = new File(file.getAbsolutePath(), file.getName() + ".tmp");
                }
                out = new BufferedOutputStream(new FileOutputStream(tempFile));
                LOG.debug((Object)"about to write ogg file");
                this.write(out);
                out.flush();
                Object var8_7 = null;
                if (out == null) break block15;
            }
            catch (Throwable throwable) {
                IOException ignored22;
                Object var8_8 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignored22) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException ignored22) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ignored22) {}
        }
        if (tempFile.length() == 0L) {
            throw new IOException("writing of file failed");
        }
        if (!FileUtils.forceRename(tempFile, file)) {
            throw new IOException("couldn't rename file");
        }
    }

    void read(InputStream in) throws IOException {
        this.state.in = in;
        Page og = new Page();
        int bytes = 0;
        this.state.oy = new SyncState();
        this.state.oy.init();
        int index = this.state.oy.buffer(CHUNKSIZE);
        byte[] buffer = this.state.oy.data;
        bytes = this.state.in.read(buffer, index, CHUNKSIZE);
        this.state.oy.wrote(bytes);
        if (this.state.oy.pageout(og) != 1) {
            throw new IOException("input truncated, empty or not an ogg");
        }
        this.state.serial = og.serialno();
        this.state.os = new StreamState();
        this.state.os.init(this.state.serial);
        this.state.vi = new Info();
        this.state.vi.init();
        this.state.vc = new Comment();
        this.state.vc.init();
        if (this.state.os.pagein(og) < 0) {
            throw new IOException("Error reading first page of Ogg bitstream data.");
        }
        Packet header_main = new Packet();
        if (this.state.os.packetout(header_main) != 1) {
            throw new IOException("Error reading initial header packet.");
        }
        if (this.state.vi.synthesis_headerin(this.state.vc, header_main) < 0) {
            throw new IOException("This Ogg bitstream does not contain Vorbis data.");
        }
        this.state.mainlen = header_main.bytes;
        this.state.mainbuf = new byte[this.state.mainlen];
        System.arraycopy(header_main.packet_base, header_main.packet, this.state.mainbuf, 0, this.state.mainlen);
        int i = 0;
        Packet header_comments = new Packet();
        Packet header_codebooks = new Packet();
        Packet header = header_comments;
        while (i < 2) {
            int result;
            while (i < 2 && (result = this.state.oy.pageout(og)) != 0) {
                if (result != 1) continue;
                this.state.os.pagein(og);
                while (i < 2 && (result = this.state.os.packetout(header)) != 0) {
                    if (result == -1) {
                        throw new IOException("Corrupt secondary header.");
                    }
                    this.state.vi.synthesis_headerin(this.state.vc, header);
                    if (i == 1) {
                        this.state.booklen = header.bytes;
                        this.state.bookbuf = new byte[this.state.booklen];
                        System.arraycopy(header.packet_base, header.packet, this.state.bookbuf, 0, header.bytes);
                    }
                    ++i;
                    header = header_codebooks;
                }
            }
            buffer = this.state.oy.data;
            index = this.state.oy.buffer(CHUNKSIZE);
            bytes = this.state.in.read(buffer, index, CHUNKSIZE);
            if (bytes == 0 && i < 2) {
                throw new IOException("EOF before end of vorbis headers.");
            }
            this.state.oy.wrote(bytes);
        }
    }

    int write(OutputStream out) throws IOException {
        int result;
        StreamState streamout = new StreamState();
        Packet header_main = new Packet();
        Packet header_comments = new Packet();
        Packet header_codebooks = new Packet();
        Page ogout = new Page();
        Packet op = new Packet();
        long granpos = 0L;
        boolean eosin = false;
        boolean needflush = false;
        boolean needout = false;
        header_main.bytes = this.state.mainlen;
        header_main.packet_base = this.state.mainbuf;
        header_main.packet = 0;
        header_main.b_o_s = 1;
        header_main.e_o_s = 0;
        header_main.granulepos = 0L;
        header_codebooks.bytes = this.state.booklen;
        header_codebooks.packet_base = this.state.bookbuf;
        header_codebooks.packet = 0;
        header_codebooks.b_o_s = 0;
        header_codebooks.e_o_s = 0;
        header_codebooks.granulepos = 0L;
        streamout.init(this.state.serial);
        this.state.vc.header_out(header_comments);
        streamout.packetin(header_main);
        streamout.packetin(header_comments);
        streamout.packetin(header_codebooks);
        while ((result = streamout.flush(ogout)) != 0) {
            out.write(ogout.header_base, ogout.header, ogout.header_len);
            out.flush();
            out.write(ogout.body_base, ogout.body, ogout.body_len);
            out.flush();
        }
        while (this.state.fetch_next_packet(op) != 0) {
            int size = this.state.blocksize(op);
            granpos += (long)size;
            if (needflush) {
                if (streamout.flush(ogout) != 0) {
                    out.write(ogout.header_base, ogout.header, ogout.header_len);
                    out.flush();
                    out.write(ogout.body_base, ogout.body, ogout.body_len);
                    out.flush();
                }
            } else if (needout && streamout.pageout(ogout) != 0) {
                out.write(ogout.header_base, ogout.header, ogout.header_len);
                out.flush();
                out.write(ogout.body_base, ogout.body, ogout.body_len);
                out.flush();
            }
            needout = false;
            needflush = false;
            if (op.granulepos == -1L) {
                op.granulepos = granpos;
                streamout.packetin(op);
                continue;
            }
            if (granpos > op.granulepos) {
                granpos = op.granulepos;
                streamout.packetin(op);
                needflush = true;
                continue;
            }
            streamout.packetin(op);
            needout = true;
        }
        streamout.e_o_s = 1;
        while (streamout.flush(ogout) != 0) {
            out.write(ogout.header_base, ogout.header, ogout.header_len);
            out.flush();
            out.write(ogout.body_base, ogout.body, ogout.body_len);
            out.flush();
        }
        this.state.vi.clear();
        eosin = false;
        while (!eosin) {
            while ((result = this.state.oy.pageout(ogout)) != 0) {
                if (result < 0) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Corrupt or missing data, continuing...");
                    continue;
                }
                out.write(ogout.header_base, ogout.header, ogout.header_len);
                out.flush();
                out.write(ogout.body_base, ogout.body, ogout.body_len);
                out.flush();
            }
            int index = this.state.oy.buffer(CHUNKSIZE);
            byte[] buffer = this.state.oy.data;
            int bytes = this.state.in.read(buffer, index, CHUNKSIZE);
            this.state.oy.wrote(bytes);
            if (bytes != 0 && bytes != -1) continue;
            eosin = true;
            break;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class State {
        private final int CHUNKSIZE = 4096;
        SyncState oy;
        StreamState os;
        Comment vc;
        Info vi;
        InputStream in;
        int serial;
        byte[] mainbuf;
        byte[] bookbuf;
        int mainlen;
        int booklen;
        String lasterror;
        int prevW;
        Page og = new Page();

        State() {
        }

        int blocksize(Packet p) {
            int _this = this.vi.blocksize(p);
            int ret = (_this + this.prevW) / 4;
            if (this.prevW == 0) {
                this.prevW = _this;
                return 0;
            }
            this.prevW = _this;
            return ret;
        }

        int fetch_next_packet(Packet p) {
            int result = this.os.packetout(p);
            if (result > 0) {
                return 1;
            }
            while (this.oy.pageout(this.og) <= 0) {
                int bytes;
                int index = this.oy.buffer(4096);
                byte[] buffer = this.oy.data;
                try {
                    bytes = this.in.read(buffer, index, 4096);
                }
                catch (Exception e) {
                    ErrorService.error(e);
                    return 0;
                }
                if (bytes > 0) {
                    this.oy.wrote(bytes);
                }
                if (bytes != 0 && bytes != -1) continue;
                return 0;
            }
            this.os.pagein(this.og);
            return this.fetch_next_packet(p);
        }
    }
}

