/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MP3DataEditor;
import com.limegroup.gnutella.metadata.MetaDataEditor;
import com.limegroup.gnutella.metadata.OGGDataEditor;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AudioMetaDataEditor
extends MetaDataEditor {
    private Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$metadata$AudioMetaDataEditor == null ? (class$com$limegroup$gnutella$metadata$AudioMetaDataEditor = AudioMetaDataEditor.class$("com.limegroup.gnutella.metadata.AudioMetaDataEditor")) : class$com$limegroup$gnutella$metadata$AudioMetaDataEditor));
    protected String title_;
    protected String artist_;
    protected String album_;
    protected String year_;
    protected String track_;
    protected String comment_;
    protected String genre_;
    private static final String TITLE_STRING = "title=\"";
    private static final String ARTIST_STRING = "artist=\"";
    private static final String ALBUM_STRING = "album=\"";
    private static final String YEAR_STRING = "year=\"";
    private static final String TRACK_STRING = "track=\"";
    private static final String COMMENT_STRING = "comments=\"";
    private static final String GENRE_STRING = "genre=\"";
    private static final String BITRATE_STRING = "bitrate=\"";
    private static final String SECONDS_STRING = "seconds=\"";
    static /* synthetic */ Class class$com$limegroup$gnutella$metadata$AudioMetaDataEditor;

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaDataEditor)) {
            return false;
        }
        AudioMetaDataEditor other = (AudioMetaDataEditor)o;
        return this.matches(this.title_, other.title_) && this.matches(this.artist_, other.artist_) && this.matches(this.album_, other.album_) && this.matches(this.year_, other.year_) && this.matches(this.track_, other.track_) && this.matches(this.comment_, other.comment_) && this.matches(this.genre_, other.genre_);
    }

    public boolean betterThan(MetaDataEditor o) {
        AudioMetaDataEditor other = (AudioMetaDataEditor)o;
        return this.firstBetter(this.title_, other.title_) && this.firstBetter(this.artist_, other.artist_) && this.firstBetter(this.album_, other.album_) && this.firstBetter(this.track_, other.track_) && this.firstBetter(this.comment_, other.comment_) && this.firstBetter(this.genre_, other.genre_);
    }

    public void pickBetterFields(MetaDataEditor o) {
        AudioMetaDataEditor other = (AudioMetaDataEditor)o;
        if (this.firstBetter(other.title_, this.title_)) {
            this.title_ = other.title_;
        }
        if (this.firstBetter(other.artist_, this.artist_)) {
            this.artist_ = other.artist_;
        }
        if (this.firstBetter(other.album_, this.album_)) {
            this.album_ = other.album_;
        }
        if (this.firstBetter(other.track_, this.track_)) {
            this.track_ = other.track_;
        }
        if (this.firstBetter(other.comment_, this.comment_)) {
            this.comment_ = other.comment_;
        }
        if (this.firstBetter(other.genre_, this.genre_)) {
            this.genre_ = other.genre_;
        }
    }

    public static MetaDataEditor getEditorForFile(String name) {
        if (LimeXMLUtils.isMP3File(name)) {
            return new MP3DataEditor();
        }
        if (LimeXMLUtils.isOGGFile(name)) {
            return new OGGDataEditor(name);
        }
        return null;
    }

    public void populateFromString(String xmlStr) {
        int j;
        int i;
        Object[] rippedStuff = null;
        try {
            rippedStuff = this.ripTag(xmlStr, TITLE_STRING);
            this.title_ = (String)rippedStuff[2];
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("title = " + this.title_));
            }
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, ARTIST_STRING);
            this.artist_ = (String)rippedStuff[2];
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("artist = " + this.artist_));
            }
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, ALBUM_STRING);
            this.album_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, YEAR_STRING);
            this.year_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, TRACK_STRING);
            this.track_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, COMMENT_STRING);
            this.comment_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, GENRE_STRING);
            this.genre_ = (String)rippedStuff[2];
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, BITRATE_STRING);
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            rippedStuff = this.ripTag(xmlStr, SECONDS_STRING);
            i = (Integer)rippedStuff[0];
            j = (Integer)rippedStuff[1];
            xmlStr = xmlStr.substring(0, i) + xmlStr.substring(j, xmlStr.length());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private Object[] ripTag(String source, String tagToRip) throws IOException {
        Object[] retObjs = new Object[3];
        int begin = source.indexOf(tagToRip);
        if (begin < 0) {
            throw new IOException("tag not found");
        }
        if (begin != 0) {
            retObjs[0] = new Integer(begin - 1);
        }
        if (begin == 0) {
            retObjs[0] = new Integer(begin);
        }
        int end = begin;
        while (source.charAt(end) != '=') {
            ++end;
        }
        while (source.charAt(end) != '\"') {
            ++end;
        }
        int i = ++end;
        while (source.charAt(end) != '\"') {
            ++end;
        }
        int j = end;
        retObjs[1] = new Integer(end + 1);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("ID3Editor.ripTag(): i = " + i + ", j = " + j));
        }
        retObjs[2] = source.substring(i, j);
        return retObjs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

