/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;

public class UDPCrawlerPing
extends VendorMessage {
    public static final int VERSION = 1;
    public static final int ALL = -1;
    private int _numberUP;
    private int _numberLeaves;
    private byte _format;
    public static final byte PLAIN = 0;
    public static final byte CONNECTION_TIME = 1;
    public static final byte LOCALE_INFO = 2;
    public static final byte NEW_ONLY = 4;
    public static final byte USER_AGENT = 8;
    public static final byte FEATURE_MASK = 15;

    public UDPCrawlerPing(GUID guid, int numberUP, int numberLeaves, byte features) {
        super(F_LIME_VENDOR_ID, 5, 1, UDPCrawlerPing.derivePayload(numberUP, numberLeaves, features));
        this.setGUID(guid);
        this._numberUP = numberUP;
        this._numberLeaves = numberLeaves;
        this._format = (byte)(features & 0xF);
    }

    public UDPCrawlerPing(GUID guid) {
        this(guid, -1, -1, 0);
    }

    private static byte[] derivePayload(int numberUP, int numberLeaves, byte features) {
        if (numberUP > 255) {
            numberUP = 255;
        }
        if (numberLeaves > 255) {
            numberLeaves = 255;
        }
        features = (byte)(features & 0xF);
        byte[] temp = new byte[2];
        byte[] payload = new byte[3];
        ByteOrder.short2leb((short)numberUP, temp, 0);
        payload[0] = temp[0];
        ByteOrder.short2leb((short)numberLeaves, temp, 0);
        payload[1] = temp[0];
        payload[2] = features;
        return payload;
    }

    protected UDPCrawlerPing(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 5, version, payload);
        if (this.getVersion() == 1 && (payload == null || payload.length != 3)) {
            throw new BadPacketException();
        }
        this._numberUP = ByteOrder.ubyte2int(payload[0]);
        this._numberLeaves = ByteOrder.ubyte2int(payload[1]);
        this._format = payload[2];
        this._format = (byte)(this._format & 0xF);
    }

    public int getNumberUP() {
        return this._numberUP;
    }

    public int getNumberLeaves() {
        return this._numberLeaves;
    }

    public boolean hasConnectionTime() {
        return (byte)(1 & this._format) == 1;
    }

    public boolean hasLocaleInfo() {
        return (byte)(2 & this._format) == 2;
    }

    public boolean hasNewOnly() {
        return (byte)(4 & this._format) == 4;
    }

    public boolean hasUserAgent() {
        return (byte)(8 & this._format) == 8;
    }

    public boolean hasFeature(byte featureId) {
        return (byte)(featureId & this._format) == featureId;
    }

    public byte getFormat() {
        return this._format;
    }
}

