/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.IOException;

public class HeadPing
extends VendorMessage {
    public static final int VERSION = 1;
    public static final int PLAIN = 0;
    public static final int INTERVALS = 1;
    public static final int ALT_LOCS = 2;
    public static final int PUSH_ALTLOCS = 4;
    public static final int FWT_PUSH_ALTLOCS = 8;
    public static final int FEATURE_MASK = 15;
    private final URN _urn;
    private final byte _features;

    protected HeadPing(byte[] guid, byte ttl, byte hops, int version, byte[] payload) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 23, version, payload);
        if (this.getVersion() == 1 && (payload == null || payload.length < 41)) {
            throw new BadPacketException();
        }
        this._features = (byte)(payload[0] & 0xF);
        String urnStr = new String(payload, 1, 41);
        if (!URN.isUrn(urnStr)) {
            throw new BadPacketException("udp head request did not contain an urn");
        }
        URN urn = null;
        try {
            urn = URN.createSHA1Urn(urnStr);
        }
        catch (IOException oops) {
            throw new BadPacketException("failed to parse an urn");
        }
        finally {
            this._urn = urn;
        }
    }

    public HeadPing(URN sha1, int features) {
        super(F_LIME_VENDOR_ID, 23, 1, HeadPing.derivePayload(sha1, features));
        this._features = (byte)(features & 0xF);
        this._urn = sha1;
    }

    public HeadPing(URN urn) {
        this(urn, 0);
    }

    private static byte[] derivePayload(URN urn, int features) {
        String urnStr = urn.httpStringValue();
        int urnlen = urnStr.getBytes().length;
        int totalLen = urnlen + 1;
        byte[] ret = new byte[totalLen];
        ret[0] = (byte)(features &= 0xF);
        System.arraycopy(urnStr.getBytes(), 0, ret, 1, urnlen);
        return ret;
    }

    public URN getUrn() {
        return this._urn;
    }

    public boolean requestsRanges() {
        return (this._features & 1) == 1;
    }

    public boolean requestsAltlocs() {
        return (this._features & 2) == 2;
    }

    public boolean requestsPushLocs() {
        return (this._features & 4) == 4;
    }

    public boolean requestsFWTPushLocs() {
        return (this._features & 8) == 8;
    }

    public byte getFeatures() {
        return this._features;
    }
}

