/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.html;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MessageResourceService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.net.URLEncoder;

public class FileListHTMLPage {
    public static final String htmlBegin = "<html>\r\n<head>\r\n<title>" + MessageResourceService.getHTMLPageTitle() + "</title>\r\n<style type=\"text/css\"><!--\r\np {\r\nfont-family: Verdana, Arial, Helvetica, sans-serif;\r\nfont-size: 10px;\r\ncolor: #666666;\r\nfont-weight: bold;\r\n}\r\n-->\r\n</style>\r\n</head>\r\n<body link=\"#000000\" vlink=\"#000000\" alink=\"#339900\" marginwidth=\"0\"\r\nmarginheight=\"0\" leftmargin=\"0\" topmargin=\"0\">\r\n<br>\r\n<br>\r\n<p align=\"center\"><img src=\"" + "/gnutella/res/" + "com/limegroup/gnutella/html/file_view_logo.gif\" alt=\"\"></p>\r\n<p align=\"center\">" + MessageResourceService.getHTMLPageListingHeader() + " ";
    public static final String htmlMiddle = "<br>\r\n</p>\r\n<p align=\"center\">\r\n";
    public static final String htmlMagnet = "</p>\r\n<br>\r\n<p align=\"center\">" + MessageResourceService.getHTMLPageMagnetHeader() + "<br>";
    public static final String htmlEnd = "</p>\r\n<br>\r\n</body>\r\n</html>";
    private static final FileListHTMLPage _instance = new FileListHTMLPage();

    public static FileListHTMLPage instance() {
        return _instance;
    }

    private FileListHTMLPage() {
    }

    public String getSharedFilePage() {
        FileManager fm = RouterService.getFileManager();
        return this.getSharedFilePage(fm.getAllSharedFileDescriptors());
    }

    public String getSharedFilePage(FileDesc[] sharedFiles) {
        StringBuffer sb = new StringBuffer();
        sb.append(htmlBegin);
        String host = NetworkUtils.ip2string(RouterService.getAddress());
        String port = "" + RouterService.getPort();
        sb.append(host + ":" + port + htmlMiddle);
        boolean shouldShowMagnets = false;
        String beginURL = "\r\n<a href=\"/get/";
        for (int i = 0; i < sharedFiles.length; ++i) {
            if (sharedFiles[i] == null || sharedFiles[i] instanceof IncompleteFileDesc) continue;
            File currFile = sharedFiles[i].getFile();
            sb.append("\r\n<a href=\"/get/" + sharedFiles[i].getIndex() + "/" + UploadManager.FV_PASS + "/" + StringUtils.replace(URLEncoder.encode(currFile.getName()), "+", "%20") + "\">" + currFile.getName() + "</a><br>");
            if (shouldShowMagnets || !this.hasEnoughAltLocs(sharedFiles[i])) continue;
            shouldShowMagnets = true;
        }
        if (shouldShowMagnets) {
            sb.append(htmlMagnet);
            beginURL = "\r\n<a href=\"magnet:?xt=";
            String middle1URL = "&dn=";
            String middle2URL = "&xs=http://" + host + ":" + port + "/uri-res/N2R?";
            String middle3URL = "\">";
            String endURL = "</a><br>";
            for (int i = 0; i < sharedFiles.length; ++i) {
                if (sharedFiles[i] == null || !this.hasEnoughAltLocs(sharedFiles[i]) || sharedFiles[i] instanceof IncompleteFileDesc) continue;
                String sha1 = sharedFiles[i].getSHA1Urn().toString();
                String fname = sharedFiles[i].getFile().getName();
                sb.append("\r\n<a href=\"magnet:?xt=" + sha1 + "&dn=" + fname + middle2URL + sha1 + "\">" + fname + "</a><br>");
            }
        }
        sb.append(htmlEnd);
        return sb.toString();
    }

    private boolean hasEnoughAltLocs(FileDesc fd) {
        return fd.getAlternateLocationCollection().getAltLocsSize() > 1;
    }
}

