/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.LeafHeaders;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.statistics.HandshakingStat;
import java.io.IOException;
import java.util.Properties;

public final class LeafHandshakeResponder
extends AuthenticationHandshakeResponder {
    private boolean _pref = false;

    public LeafHandshakeResponder(String host) {
        super(RouterService.getConnectionManager(), host);
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse response, boolean outgoing) throws IOException {
        if (outgoing) {
            return this.respondToOutgoing(response);
        }
        return this.respondToIncoming(response);
    }

    private HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        if (response.isLeaf()) {
            HandshakingStat.LEAF_OUTGOING_REJECT_LEAF.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        if (this._pref && !ApplicationSettings.LANGUAGE.getValue().equals(response.getLocalePref())) {
            return HandshakeResponse.createLeafRejectLocaleOutgoingResponse();
        }
        if (!this._manager.allowConnection(response)) {
            HandshakingStat.LEAF_OUTGOING_REJECT_OLD_UP.incrementStat();
            return HandshakeResponse.createLeafRejectOutgoingResponse();
        }
        Properties ret = new Properties();
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        HandshakingStat.LEAF_OUTGOING_ACCEPT.incrementStat();
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    private HandshakeResponse respondToIncoming(HandshakeResponse hr) {
        if (hr.isCrawler()) {
            HandshakingStat.INCOMING_CRAWLER.incrementStat();
            return HandshakeResponse.createCrawlerResponse();
        }
        LeafHeaders ret = new LeafHeaders(this.getRemoteIP());
        if (!this._manager.allowConnection(hr)) {
            HandshakingStat.LEAF_INCOMING_REJECT.incrementStat();
            return HandshakeResponse.createLeafRejectIncomingResponse(hr);
        }
        if (hr.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        HandshakingStat.LEAF_INCOMING_ACCEPT.incrementStat();
        return HandshakeResponse.createAcceptIncomingResponse(hr, ret);
    }

    public void setLocalePreferencing(boolean b) {
        this._pref = b;
    }
}

