/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.IntervalSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerifyingFile {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$downloader$VerifyingFile == null ? (class$com$limegroup$gnutella$downloader$VerifyingFile = VerifyingFile.class$("com.limegroup.gnutella.downloader.VerifyingFile")) : class$com$limegroup$gnutella$downloader$VerifyingFile));
    private RandomAccessFile fos;
    private final boolean checkOverlap;
    private volatile boolean isCorrupted;
    private ManagedDownloader managedDownloader;
    private final int completedSize;
    private final IntervalSet writtenBlocks;
    private IntervalSet leasedBlocks;
    static /* synthetic */ Class class$com$limegroup$gnutella$downloader$VerifyingFile;

    public VerifyingFile(boolean checkOverlap) {
        this(checkOverlap, -1);
    }

    public VerifyingFile(boolean checkOverlap, int completedSize) {
        this.completedSize = completedSize;
        this.checkOverlap = checkOverlap;
        this.writtenBlocks = new IntervalSet();
        this.leasedBlocks = new IntervalSet();
    }

    public void open(File file, ManagedDownloader md) throws IOException {
        if (this.completedSize == -1) {
            throw new IllegalStateException("cannot open for unknown size.");
        }
        this.managedDownloader = md;
        File parentFile = FileUtils.getParentFile(file);
        if (parentFile != null) {
            parentFile.mkdirs();
            FileUtils.setWriteable(parentFile);
        }
        FileUtils.setWriteable(file);
        this.fos = new RandomAccessFile(file, "rw");
        this.leasedBlocks = new IntervalSet();
    }

    public synchronized void addInterval(Interval interval) {
        this.writtenBlocks.add(interval);
        this.releaseBlock(interval);
    }

    public synchronized void writeBlock(long currPos, int numBytes, byte[] buf) throws IOException {
        if (numBytes == 0) {
            return;
        }
        if (this.fos == null) {
            throw new IOException();
        }
        boolean checkBeforeWrite = false;
        List overlapBlocks = null;
        Interval intvl = new Interval((int)currPos, (int)currPos + numBytes - 1);
        if (this.checkOverlap && (overlapBlocks = this.writtenBlocks.getOverlapIntervals(intvl)).size() > 0) {
            checkBeforeWrite = true;
        }
        if (checkBeforeWrite) {
            Iterator iter = overlapBlocks.iterator();
            while (iter.hasNext()) {
                Interval overlapInterval = (Interval)iter.next();
                int amountToCheck = overlapInterval.high - overlapInterval.low + 1;
                byte[] fileBuf = new byte[amountToCheck];
                this.fos.seek(overlapInterval.low);
                this.fos.readFully(fileBuf, 0, amountToCheck);
                int j = this.findInitialPoint(overlapInterval, currPos);
                int i = 0;
                while (i < amountToCheck) {
                    if (buf[j] != fileBuf[i]) {
                        this.isCorrupted = true;
                        if (this.managedDownloader != null) {
                            this.managedDownloader.promptAboutCorruptDownload();
                        }
                    }
                    ++i;
                    ++j;
                }
            }
        }
        this.fos.seek(currPos);
        this.fos.write(buf, 0, numBytes);
        this.writtenBlocks.add(intvl);
        this.releaseBlock(intvl);
    }

    public synchronized Interval leaseWhite() throws NoSuchElementException {
        IntervalSet freeBlocks = this.writtenBlocks.invert(this.completedSize);
        freeBlocks.delete(this.leasedBlocks);
        Interval ret = freeBlocks.removeFirst();
        this.leaseBlock(ret);
        return ret;
    }

    public synchronized Interval leaseWhite(int chunkSize) throws NoSuchElementException {
        Interval temp = this.leaseWhite();
        return this.fixIntervalForChunk(temp, chunkSize);
    }

    public synchronized Interval leaseWhite(IntervalSet ranges) throws NoSuchElementException {
        ranges.delete(this.writtenBlocks);
        ranges.delete(this.leasedBlocks);
        Interval temp = ranges.removeFirst();
        while (temp != null && temp.high - temp.low <= 10) {
            temp = ranges.removeFirst();
        }
        Interval ret = new Interval(temp.low + 10, temp.high);
        this.leaseBlock(ret);
        return ret;
    }

    public synchronized Interval leaseWhite(IntervalSet ranges, int chunkSize) throws NoSuchElementException {
        Interval temp = this.leaseWhite(ranges);
        return this.fixIntervalForChunk(temp, chunkSize);
    }

    public synchronized void releaseBlock(Interval in) {
        this.leasedBlocks.delete(in);
    }

    public synchronized Iterator getBlocks() {
        return this.writtenBlocks.getAllIntervals();
    }

    public synchronized byte[] toBytes() {
        return this.writtenBlocks.toBytes();
    }

    public synchronized List getBlocksAsList() {
        return this.writtenBlocks.getAllIntervalsAsList();
    }

    public synchronized Iterator getFreeBlocks(int maxSize) {
        return this.writtenBlocks.getNeededIntervals(maxSize);
    }

    public synchronized int getBlockSize() {
        return this.writtenBlocks.getSize();
    }

    public synchronized boolean isComplete() {
        return this.writtenBlocks.getSize() == this.completedSize;
    }

    public synchronized boolean hasFreeBlocksToAssign() {
        return this.writtenBlocks.getSize() + this.leasedBlocks.getSize() < this.completedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized int deleteCorruptedBlocks(HashTree tree, File file) throws IOException {
        BufferedInputStream is = null;
        int deleted = 0;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            List corruptRanges = tree.getCorruptRanges(is);
            Iterator iter = corruptRanges.iterator();
            while (iter.hasNext()) {
                ++deleted;
                this.writtenBlocks.delete((Interval)iter.next());
            }
            this.isCorrupted = false;
            Object var8_7 = null;
            if (is == null) return deleted;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)is).close();
            return deleted;
        }
        catch (IOException ignored) {}
        return deleted;
    }

    public void close() {
        if (this.fos == null) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void clearManagedDownloader() {
        this.managedDownloader = null;
    }

    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    public ManagedDownloader getManagedDownloader() {
        return this.managedDownloader;
    }

    private int findInitialPoint(Interval interval, long low) {
        if ((long)interval.low <= low) {
            return 0;
        }
        return interval.low - (int)low;
    }

    private synchronized Interval fixIntervalForChunk(Interval temp, int chunkSize) {
        Interval interval;
        if (temp.high - temp.low + 1 > chunkSize) {
            int max = temp.low + chunkSize - 1;
            interval = new Interval(temp.low, max);
            temp = new Interval(max + 1, temp.high);
            this.releaseBlock(temp);
        } else {
            interval = temp;
        }
        return interval;
    }

    private synchronized void leaseBlock(Interval in) {
        this.leasedBlocks.add(in);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

