/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.Interval;
import com.limegroup.gnutella.downloader.VerifyingFile;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IncompleteFileManager
implements Serializable {
    static final long serialVersionUID = -7658285233614679878L;
    static final String SEPARATOR = "-";
    public static final String PREVIEW_PREFIX = "Preview-";
    private Map blocks = new TreeMap(Comparators.fileComparator());
    private Map hashes = new HashMap();

    public synchronized boolean purge(boolean initialPurge) {
        File file;
        boolean ret = false;
        Iterator<Object> iter = this.blocks.keySet().iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            if (file.exists() && (!IncompleteFileManager.isOld(file) || !initialPurge)) continue;
            ret = true;
            RouterService.getFileManager().removeFileIfShared(file);
            file.delete();
            iter.remove();
        }
        if (initialPurge) {
            iter = this.hashes.values().iterator();
            while (iter.hasNext()) {
                file = (File)iter.next();
                if (file.exists()) continue;
                iter.remove();
                ret = true;
            }
        }
        return ret;
    }

    private static final boolean isOld(File file) {
        long lastModified = file.lastModified();
        long days = SharingSettings.INCOMPLETE_PURGE_TIME.getValue();
        long purgeTime = System.currentTimeMillis() - days * 24L * 60L * 60L * 1000L;
        return lastModified < purgeTime;
    }

    static boolean same(RemoteFileDesc rfd1, RemoteFileDesc rfd2) {
        return IncompleteFileManager.same(rfd1.getFileName(), rfd1.getSize(), rfd1.getSHA1Urn(), rfd2.getFileName(), rfd2.getSize(), rfd2.getSHA1Urn());
    }

    static boolean same(String name1, int size1, URN hash1, String name2, int size2, URN hash2) {
        if (hash1 != null && hash2 != null) {
            return hash1.equals(hash2);
        }
        return size1 == size2 && name1.equals(name2);
    }

    public synchronized File getFile(RemoteFileDesc rfd) throws IOException {
        File incDir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        incDir.mkdirs();
        String convertedName = CommonUtils.convertFileName(rfd.getFileName());
        URN sha1 = rfd.getSHA1Urn();
        if (sha1 != null) {
            File file = (File)this.hashes.get(sha1);
            if (file != null) {
                return file;
            }
            int i = 1;
            while (true) {
                file = new File(incDir, IncompleteFileManager.tempName(convertedName, rfd.getSize(), i));
                file = FileUtils.getCanonicalFile(file);
                if (!this.hashes.values().contains(file)) break;
                ++i;
            }
            this.hashes.put(sha1, file);
            FileUtils.touch(file);
            return file;
        }
        File f = new File(incDir, IncompleteFileManager.tempName(convertedName, rfd.getSize(), 0));
        f = FileUtils.getCanonicalFile(f);
        return f;
    }

    public synchronized File getFileForUrn(URN urn) {
        if (urn == null) {
            throw new NullPointerException("null urn");
        }
        return (File)this.hashes.get(urn);
    }

    private static String tempName(String filename, int size, int suffix) {
        if (suffix <= 1) {
            return "T-" + size + SEPARATOR + filename;
        }
        int i = filename.lastIndexOf(46);
        if (i < 0) {
            return "T-" + size + SEPARATOR + filename + " (" + suffix + ")";
        }
        String noExtension = filename.substring(0, i);
        String extension = filename.substring(i);
        return "T-" + size + SEPARATOR + noExtension + " (" + suffix + ")" + extension;
    }

    private synchronized void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.hashes = new HashMap();
        stream.defaultReadObject();
        this.blocks = this.transform(this.blocks);
        this.hashes = this.verifyHashes();
        this.registerAllIncompleteFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream stream) throws IOException, ClassNotFoundException {
        Map blocksSave = this.blocks;
        try {
            this.blocks = this.invTransform();
            stream.defaultWriteObject();
        }
        finally {
            this.blocks = blocksSave;
        }
    }

    private Map verifyHashes() {
        HashMap<URN, File> retMap = new HashMap<URN, File>();
        Iterator i = this.hashes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!(entry.getKey() instanceof URN) || !(entry.getValue() instanceof File)) continue;
            URN urn = (URN)entry.getKey();
            File f = (File)entry.getValue();
            try {
                f = FileUtils.getCanonicalFile(f);
                if (retMap.values().contains(f)) continue;
                retMap.put(urn, f);
            }
            catch (IOException ioe) {}
        }
        return retMap;
    }

    private Map transform(Object object) {
        Map map = (Map)object;
        TreeMap<File, VerifyingFile> retMap = new TreeMap<File, VerifyingFile>(Comparators.fileComparator());
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            VerifyingFile vf;
            Object incompleteFile = i.next();
            Object o = map.get(incompleteFile);
            if (o == null || !(incompleteFile instanceof File)) continue;
            File f = (File)incompleteFile;
            try {
                f = FileUtils.getCanonicalFile(f);
            }
            catch (IOException ioe) {
                continue;
            }
            Iterator iter = ((List)o).iterator();
            try {
                vf = new VerifyingFile(true, (int)IncompleteFileManager.getCompletedSize(f));
            }
            catch (IllegalArgumentException iae) {
                vf = new VerifyingFile(true);
            }
            while (iter.hasNext()) {
                Interval interval = (Interval)iter.next();
                interval = new Interval(interval.low, interval.high - 1);
                vf.addInterval(interval);
            }
            retMap.put(f, vf);
        }
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map invTransform() {
        HashMap retMap = new HashMap();
        Iterator iter = this.blocks.keySet().iterator();
        while (iter.hasNext()) {
            VerifyingFile vf;
            ArrayList<Interval> writeList = new ArrayList<Interval>();
            Object incompleteFile = iter.next();
            VerifyingFile verifyingFile = vf = (VerifyingFile)this.blocks.get(incompleteFile);
            synchronized (verifyingFile) {
                List l = vf.getBlocksAsList();
                for (int i = 0; i < l.size(); ++i) {
                    Interval inter = (Interval)l.get(i);
                    Interval interval = new Interval(inter.low, inter.high + 1);
                    writeList.add(interval);
                }
            }
            retMap.put(incompleteFile, writeList);
        }
        return retMap;
    }

    public synchronized void removeEntry(File incompleteFile) {
        this.blocks.remove(incompleteFile);
        Iterator iter = this.hashes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!incompleteFile.equals(entry.getValue())) continue;
            iter.remove();
        }
        RouterService.getFileManager().removeFileIfShared(incompleteFile);
    }

    public synchronized void addEntry(File incompleteFile, VerifyingFile vf) throws IOException {
        try {
            incompleteFile = FileUtils.getCanonicalFile(incompleteFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.blocks.put(incompleteFile, vf);
        this.registerIncompleteFile(incompleteFile);
    }

    public synchronized VerifyingFile getEntry(File incompleteFile) {
        Object o = this.blocks.get(incompleteFile);
        return (VerifyingFile)o;
    }

    public synchronized int getBlockSize(File incompleteFile) {
        Object o = this.blocks.get(incompleteFile);
        if (o == null) {
            return 0;
        }
        VerifyingFile vf = (VerifyingFile)o;
        return vf.getBlockSize();
    }

    public synchronized void registerAllIncompleteFiles() {
        Iterator iter = this.blocks.keySet().iterator();
        while (iter.hasNext()) {
            File file = (File)iter.next();
            if (!file.exists() || IncompleteFileManager.isOld(file)) continue;
            this.registerIncompleteFile(file);
        }
    }

    private synchronized void registerIncompleteFile(File incompleteFile) {
        Set completeHashes = this.getAllCompletedHashes(incompleteFile);
        if (completeHashes.size() == 0) {
            return;
        }
        RouterService.getFileManager().addIncompleteFile(incompleteFile, completeHashes, IncompleteFileManager.getCompletedName(incompleteFile), (int)IncompleteFileManager.getCompletedSize(incompleteFile), this.getEntry(incompleteFile));
    }

    public static String getCompletedName(File incompleteFile) throws IllegalArgumentException {
        String name = incompleteFile.getName();
        int i = name.indexOf(SEPARATOR);
        if (i < 0) {
            throw new IllegalArgumentException("Missing separator: " + name);
        }
        int j = name.indexOf(SEPARATOR, i + 1);
        if (j < 0) {
            throw new IllegalArgumentException("Missing separator: " + name);
        }
        if (j == name.length() - 1) {
            throw new IllegalArgumentException("No name after last separator");
        }
        return name.substring(j + 1);
    }

    public static long getCompletedSize(File incompleteFile) throws IllegalArgumentException {
        String name = incompleteFile.getName();
        int i = name.indexOf(SEPARATOR);
        if (i < 0) {
            throw new IllegalArgumentException("Missing separator: " + name);
        }
        int j = name.indexOf(SEPARATOR, i + 1);
        if (j < 0) {
            throw new IllegalArgumentException("Missing separator: " + name);
        }
        try {
            return Long.parseLong(name.substring(i + 1, j));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad number format: " + name);
        }
    }

    public synchronized URN getCompletedHash(File incompleteFile) {
        Iterator iter = this.hashes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!incompleteFile.equals(entry.getValue())) continue;
            return (URN)entry.getKey();
        }
        return null;
    }

    public synchronized Set getAllCompletedHashes(File incompleteFile) {
        HashSet urns = new HashSet(1);
        Iterator iter = this.hashes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!incompleteFile.equals(entry.getValue())) continue;
            urns.add(entry.getKey());
        }
        return urns;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        boolean first = true;
        Iterator iter = this.blocks.keySet().iterator();
        while (iter.hasNext()) {
            if (!first) {
                buf.append(", ");
            }
            File key = (File)iter.next();
            List intervals = ((VerifyingFile)this.blocks.get(key)).getBlocksAsList();
            buf.append(key);
            buf.append(":");
            buf.append(intervals.toString());
            first = false;
        }
        buf.append("}");
        return buf.toString();
    }

    public synchronized String dumpHashes() {
        return this.hashes.toString();
    }
}

