/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionChecker
implements Runnable {
    private volatile boolean _connected;
    private int _unsuccessfulAttempts;
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$connection$ConnectionChecker == null ? (class$com$limegroup$gnutella$connection$ConnectionChecker = ConnectionChecker.class$("com.limegroup.gnutella.connection.ConnectionChecker")) : class$com$limegroup$gnutella$connection$ConnectionChecker));
    private static String[] STANDARD_HOSTS = new String[]{"http://www.wanadoo.fr", "http://www.tiscali.com", "http://www.ntt.com", "http://www.tonline.com", "http://www.download.com", "http://www.ibm.com", "http://www.sun.com", "http://www.apple.com", "http://www.ebay.com", "http://www.sun.com", "http://www.monster.com", "http://www.uunet.com", "http://www.real.com", "http://www.level3.com", "http://www.microsoft.com", "http://www.sco.com", "http://www.google.com", "http://www.cnn.com", "http://www.amazon.com", "http://www.espn.com", "http://www.yahoo.com", "http://www.oracle.com", "http://www.dell.com", "http://www.ge.com", "http://www.sprint.com", "http://www.att.com", "http://www.mci.com", "http://www.cisco.com", "http://www.intel.com", "http://www.motorola.com", "http://www.hp.com", "http://www.gateway.com", "http://www.sony.com", "http://www.ford.com", "http://www.gm.com", "http://www.aol.com", "http://www.verizon.com", "http://www.passport.com", "http://www.go.com", "http://www.overture.com", "http://www.earthlink.net", "http://www.bellsouth.net", "http://www.excite.com", "http://www.paypal.com", "http://www.altavista.com", "http://www.weather.com", "http://www.mapquest.com", "http://www.geocities.com", "http://www.juno.com", "http://www.msnbc.com", "http://www.lycos.com", "http://www.comcast.com", "http://www.overture.com"};
    static /* synthetic */ Class class$com$limegroup$gnutella$connection$ConnectionChecker;

    private ConnectionChecker() {
    }

    public static ConnectionChecker checkForLiveConnection() {
        LOG.trace((Object)"checking for live connection");
        ConnectionChecker checker = new ConnectionChecker();
        ManagedThread connectionThread = new ManagedThread(checker, "check for live connection");
        connectionThread.setDaemon(true);
        connectionThread.start();
        return checker;
    }

    public void run() {
        try {
            List<String> hostList = Arrays.asList(STANDARD_HOSTS);
            Collections.shuffle(hostList);
            Iterator<String> iter = hostList.iterator();
            while (iter.hasNext()) {
                String curHost = iter.next();
                this.connectToHost(curHost);
                if (this._connected) {
                    return;
                }
                if (this._unsuccessfulAttempts <= 2) continue;
                RouterService.getConnectionManager().noInternetConnection();
                return;
            }
        }
        catch (Throwable t) {
            ErrorService.error(t);
        }
    }

    public boolean hasConnected() {
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToHost(String host) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("connecting to: " + host));
        }
        HeadMethod head = new HeadMethod(host);
        head.addRequestHeader("Cache-Control", "no-cache");
        head.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        head.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        head.setFollowRedirects(false);
        HttpClient client = HttpClientManager.getNewClient(20000, 3000);
        try {
            client.executeMethod((HttpMethod)head);
            this._connected = true;
        }
        catch (IOException e) {
            LOG.warn((Object)"Exception while handling server", (Throwable)e);
            ++this._unsuccessfulAttempts;
        }
        finally {
            head.releaseConnection();
            head.abort();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

