/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPHostRanker;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.FixedSizeExpiringSet;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPHostCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$bootstrap$UDPHostCache == null ? (class$com$limegroup$gnutella$bootstrap$UDPHostCache = UDPHostCache.class$("com.limegroup.gnutella.bootstrap.UDPHostCache")) : class$com$limegroup$gnutella$bootstrap$UDPHostCache));
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    private final List udpHosts = new ArrayList(100);
    private final Set udpHostsSet = new HashSet();
    private final Set attemptedHosts;
    private boolean dirty = false;
    private static final Comparator FAILURE_COMPARATOR = new FailureComparator();
    static /* synthetic */ Class class$com$limegroup$gnutella$bootstrap$UDPHostCache;

    public UDPHostCache() {
        this(600000L);
    }

    public UDPHostCache(long expiryTime) {
        this.attemptedHosts = new FixedSizeExpiringSet(100, expiryTime);
    }

    public synchronized void write(Writer out) throws IOException {
        Iterator iter = this.udpHosts.iterator();
        while (iter.hasNext()) {
            ExtendedEndpoint e = (ExtendedEndpoint)iter.next();
            e.write(out);
        }
    }

    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug((Object)"Clearing attempted udp host caches");
        this.decrementFailures();
        this.attemptedHosts.clear();
    }

    protected synchronized void decrementFailures() {
        Iterator i = this.attemptedHosts.iterator();
        while (i.hasNext()) {
            ExtendedEndpoint ep = (ExtendedEndpoint)i.next();
            ep.decrementUDPHostCacheFailure();
            if (ep.getUDPHostCacheFailures() == 5 && this.udpHosts.size() < 100) {
                this.add(ep);
            }
            this.dirty = true;
        }
    }

    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            Collections.shuffle(this.udpHosts);
            Collections.sort(this.udpHosts, FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList validHosts = new ArrayList(Math.min(5, this.udpHosts.size()));
        Iterator i = this.udpHosts.iterator();
        while (i.hasNext() && validHosts.size() < 5) {
            Object next = i.next();
            if (this.attemptedHosts.contains(next)) continue;
            validHosts.add(next);
        }
        this.attemptedHosts.addAll(validHosts);
        return this.fetch(validHosts);
    }

    protected synchronized boolean fetch(Collection hosts) {
        if (hosts.isEmpty()) {
            LOG.debug((Object)"No hosts to fetch");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching endpoints from " + hosts + " host caches"));
        }
        UDPHostRanker.rank(hosts, new HostExpirer(hosts), new Cancellable(){

            public boolean isCancelled() {
                return RouterService.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return PingRequest.createUDPPing();
    }

    public synchronized boolean remove(ExtendedEndpoint e) {
        boolean removed2;
        boolean removed1;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing endpoint: " + e));
        }
        Assert.that((removed1 = this.udpHosts.remove(e)) == (removed2 = this.udpHostsSet.remove(e)), "Set " + removed1 + " but queue " + removed2);
        return removed1;
    }

    public synchronized boolean add(ExtendedEndpoint e) {
        Assert.that(e.isUDPHostCache());
        if (NetworkUtils.isPrivateAddress(e.getInetAddress())) {
            return false;
        }
        if (this.udpHostsSet.contains(e)) {
            return false;
        }
        if (this.udpHosts.size() >= 100) {
            Object removed = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(removed);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ejected: " + removed));
            }
        }
        this.udpHosts.add(e);
        this.udpHostsSet.add(e);
        this.dirty = true;
        return true;
    }

    public synchronized void hostCachesAdded() {
        if (this.udpHostsSet.isEmpty()) {
            this.loadDefaults();
        }
    }

    protected void loadDefaults() {
    }

    private void createAndAdd(String host, int port) {
        try {
            ExtendedEndpoint ep = new ExtendedEndpoint(host, port).setUDPHostCache(true);
            this.add(ep);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FailureComparator
    implements Comparator {
        private FailureComparator() {
        }

        public int compare(Object a, Object b) {
            ExtendedEndpoint e1 = (ExtendedEndpoint)a;
            ExtendedEndpoint e2 = (ExtendedEndpoint)b;
            return e1.getUDPHostCacheFailures() - e2.getUDPHostCacheFailures();
        }
    }

    private class HostExpirer
    implements MessageListener {
        private final Set hosts = new TreeSet(IpPort.COMPARATOR);
        private final Set allHosts;
        private byte[] guid;

        public HostExpirer(Collection hostsToAdd) {
            this.hosts.addAll(hostsToAdd);
            this.allHosts = new HashSet(hostsToAdd);
            this.removeDuplicates(hostsToAdd, this.hosts);
        }

        private void removeDuplicates(Collection all, Collection some) {
            HashSet duplicates = new HashSet(all);
            duplicates.removeAll(some);
            Iterator i = duplicates.iterator();
            while (i.hasNext()) {
                ExtendedEndpoint ep = (ExtendedEndpoint)i.next();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing duplicate entry: " + ep));
                }
                UDPHostCache.this.remove(ep);
            }
        }

        public void processMessage(Message m, ReplyHandler handler) {
            if (handler instanceof UDPReplyHandler) {
                if (this.hosts.remove(handler) && LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recieved: " + m));
                }
                if (this.hosts.isEmpty()) {
                    RouterService.getMessageRouter().unregisterMessageListener(this.guid, this);
                }
            }
        }

        public void registered(byte[] g) {
            this.guid = g;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregistered(byte[] g) {
            UDPHostCache uDPHostCache = UDPHostCache.this;
            synchronized (uDPHostCache) {
                ExtendedEndpoint ep;
                Iterator i = this.hosts.iterator();
                while (i.hasNext()) {
                    ep = (ExtendedEndpoint)i.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("No response from cache: " + ep));
                    }
                    ep.recordUDPHostCacheFailure();
                    UDPHostCache.this.dirty = true;
                    if (ep.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCache.this.remove(ep);
                }
                this.allHosts.removeAll(this.hosts);
                i = this.allHosts.iterator();
                while (i.hasNext()) {
                    ep = (ExtendedEndpoint)i.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Valid response from cache: " + ep));
                    }
                    ep.recordUDPHostCacheSuccess();
                    UDPHostCache.this.dirty = true;
                }
            }
        }
    }
}

