/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPHostRanker {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$UDPHostRanker == null ? (class$com$limegroup$gnutella$UDPHostRanker = UDPHostRanker.class$("com.limegroup.gnutella.UDPHostRanker")) : class$com$limegroup$gnutella$UDPHostRanker));
    private static final MessageRouter ROUTER = RouterService.getMessageRouter();
    private static final ProcessingQueue QUEUE = new ProcessingQueue("UDPHostRanker");
    public static int LISTEN_EXPIRE_TIME = 20000;
    private static final long SEND_INTERVAL = 500L;
    private static final int MAX_SENDS = 15;
    private static int _sentAmount;
    private static long _lastSentTime;
    private static final Set _recent;
    static /* synthetic */ Class class$com$limegroup$gnutella$UDPHostRanker;

    public static void rank(Collection hosts) {
        UDPHostRanker.rank(hosts, null, null, null);
    }

    public static void rank(Collection hosts, Message message) {
        UDPHostRanker.rank(hosts, null, null, message);
    }

    public static void rank(Collection hosts, Cancellable canceller) {
        UDPHostRanker.rank(hosts, null, canceller, null);
    }

    public static void rank(Collection hosts, MessageListener listener) {
        UDPHostRanker.rank(hosts, listener, null, null);
    }

    public static void rank(Collection hosts, MessageListener listener, Cancellable canceller) {
        UDPHostRanker.rank(hosts, listener, canceller, null);
    }

    public static void rank(Collection hosts, MessageListener listener, Cancellable canceller, Message message) {
        if (hosts == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        if (canceller == null) {
            canceller = new Cancellable(){

                public boolean isCancelled() {
                    return false;
                }
            };
        }
        QUEUE.add(new SenderBundle(hosts, listener, canceller, message));
    }

    private static boolean waitForListening(Cancellable canceller) {
        int waits;
        for (waits = 0; !UDPService.instance().isListening() && waits < 10 && !canceller.isCancelled(); ++waits) {
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException e) {
                ErrorService.error(e);
            }
        }
        return waits < 10;
    }

    private static void send(SenderBundle info) {
        Collection hosts = info.hosts;
        final MessageListener listener = info.listener;
        Cancellable canceller = info.canceller;
        Message message = info.message;
        if (!UDPHostRanker.waitForListening(canceller)) {
            return;
        }
        if (message == null) {
            message = PingRequest.createUDPPing();
        }
        final byte[] messageGUID = message.getGUID();
        if (listener != null) {
            ROUTER.registerMessageListener(messageGUID, listener);
        }
        Iterator iter = hosts.iterator();
        while (iter.hasNext() && !canceller.isCancelled()) {
            IpPort host = (IpPort)iter.next();
            if (_recent.contains(host)) continue;
            _recent.add(host);
            long now = System.currentTimeMillis();
            if (now > _lastSentTime + 500L) {
                _sentAmount = 0;
            } else if (_sentAmount == 15) {
                try {
                    Thread.sleep(500L);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                _sentAmount = 0;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sending to " + host + ": " + message));
            }
            UDPService.instance().send(message, host);
            ++_sentAmount;
            _lastSentTime = now;
        }
        if (listener != null) {
            Runnable udpMessagePurger = new Runnable(){

                public void run() {
                    ROUTER.unregisterMessageListener(messageGUID, listener);
                }
            };
            RouterService.schedule(udpMessagePurger, LISTEN_EXPIRE_TIME, 0L);
        }
    }

    static void resetData() {
        QUEUE.add(new Runnable(){

            public void run() {
                _recent.clear();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _recent = new TreeSet(IpPort.COMPARATOR);
    }

    private static class SenderBundle
    implements Runnable {
        private final Collection hosts;
        private final MessageListener listener;
        private final Cancellable canceller;
        private final Message message;

        public SenderBundle(Collection hosts, MessageListener listener, Cancellable canceller, Message message) {
            this.hosts = hosts;
            this.listener = listener;
            this.canceller = canceller;
            this.message = message;
        }

        public void run() {
            UDPHostRanker.send(this);
        }
    }
}

