/*
 * Decompiled with CFR 0.152.
 */
package com.acquisitionx;

import com.acquisitionx.AqEvent;
import com.acquisitionx.AqEventHandler;
import com.acquisitionx.ConnectionUpdate;
import com.acquisitionx.DispatchThread;
import com.acquisitionx.DownloadRetry;
import com.acquisitionx.ReaderThread;
import com.acquisitionx.TransferUpdate;
import com.acquisitionx.TwoMinuteThread;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.gui.DaapManager;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;

public class AqMain {
    public static Thread cThread;
    public static Thread tThread;
    public static Thread dThread;
    public static Thread gcThread;
    public static Thread dispatchThread;
    public static boolean coreHasStarted;
    public static String bundlePath;

    public static void main(String[] stringArray) {
        System.err.println(stringArray[0]);
        bundlePath = stringArray[0];
        new Thread(new ReaderThread()).start();
        if (!CommonUtils.getUserSettingsDir().exists()) {
            CommonUtils.getUserSettingsDir().mkdirs();
        }
        new RouterService(new AqEventHandler()).start();
        gcThread = new Thread(new TwoMinuteThread());
        cThread = new Thread(new ConnectionUpdate());
        tThread = new Thread(new TransferUpdate());
        dThread = new Thread(new DownloadRetry());
        dispatchThread = new Thread(new DispatchThread());
        cThread.setDaemon(true);
        tThread.setDaemon(true);
        dThread.setDaemon(true);
        gcThread.setDaemon(true);
        dispatchThread.setDaemon(true);
        cThread.start();
        tThread.start();
        dThread.start();
        gcThread.start();
        dispatchThread.start();
        coreHasStarted = true;
    }

    public static String getBundlePath() {
        return bundlePath;
    }

    public static void cleanIncompleteDirectory() throws Exception {
        File file = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().startsWith("Preview-")) continue;
                file2.delete();
            }
        }
    }

    public static void killSelf() {
        AqEvent.shouldSignalEvents = false;
        if (cThread != null) {
            cThread.interrupt();
        }
        if (tThread != null) {
            tThread.interrupt();
        }
        if (dThread != null) {
            dThread.interrupt();
        }
        if (gcThread != null) {
            gcThread.interrupt();
        }
        if (dispatchThread != null) {
            dispatchThread.interrupt();
        }
        ConnectionSettings.FORCE_IP_ADDRESS.revertToDefault();
        ConnectionSettings.FORCED_IP_ADDRESS_STRING.revertToDefault();
        AqMain.shutdown();
        System.exit(0);
    }

    public static void shutdown() {
        try {
            Statistics.instance().shutdown();
            DaapManager.instance().stop();
            AqEvent.signalEvent(90);
            SettingsHandler.save();
            AqEvent.signalEvent(93);
            UrnCache.instance().persistCache();
            AqEvent.signalEvent(94);
            RouterService.getDownloadManager().writeSnapshot();
            AqEvent.signalEvent(96);
            AqMain.cleanIncompleteDirectory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        coreHasStarted = false;
    }
}

