/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.hash.SHA1State;

public class HashOutputStream
extends FilterOutputStream {
    private HashState hashState;
    private byte[] oneByte = new byte[1];

    public synchronized Fingerprint getFingerprint() {
        return this.hashState.calculate();
    }

    public synchronized void write(int n) throws IOException {
        this.oneByte[0] = (byte)n;
        this.hashState.update(this.oneByte, 0, 1);
        this.out.write(n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.hashState.update(byArray, n, n2);
        this.out.write(byArray, n, n2);
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public synchronized void close() throws IOException {
        this.out.close();
    }

    public HashOutputStream(OutputStream outputStream, HashState hashState) {
        super(outputStream);
        this.hashState = hashState;
    }

    public HashOutputStream(OutputStream outputStream) {
        this(outputStream, new SHA1State());
    }
}

