//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.util;

//===========================================================================
// import
//===========================================================================
import java.io.*; 
import java.util.*;
import java.text.*; 
import java.text.ParseException; 

import java.util.regex.*; 

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;

//import jp.gr.java_conf.bugslife.system.*;

/**
 *<PRE>
 * VaridaterNX
 *
 *
 *</PRE>
 * @version	0.0, 2001/01/04
 * @author	k 
 */
//===========================================================================
// version	0.0, 2001/01/04	VK쐬
//===========================================================================
public class Varidater
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * message resources
	 */
//	private static MessageResources m_messages =
//	MessageResources.getMessageResources("ApplicationResources");
	/**
	 * G[bZ[W`
	 */
	public static final String REQUIRED_MSG = "varid.required";
	public static final String SELECTED_MSG = "varid.selected";
	public static final String INVALID_TYPE_MSG = "varid.invalid_type";
	public static final String INVALID_MAIL_MSG = "varid.invalid_mail";
	public static final String SIZE_LESS_MSG = "varid.size_less";
	public static final String SIZE_OVER_MSG = "varid.size_over";
	public static final String NOT_NUMERIC_MSG = "varid.not_numeric";
	public static final String NOT_SPACE_MSG = "varid.not_space";
	public static final String NOT_SPACE_OR_NUMERIC_MSG = "varid.not_space_or_numeric";
	public static final String INVALID_DATE_MSG = "varid.invalid_date";
	public static final String INVALID_DATA_MSG = "varid.invalid_data";
	public static final String GREATER_ERR_MSG = "varid.greater_err";
	public static final String NOT_ALPHANUMERIC_MSG = "varid.not_alphanumeric";
	
	public static final String NOT_SAME_MSG = "varid.not_same";
	/**
	 * O
	 */ 
	private static Log log = LogFactory.getLog(Varidater.class.getName());
//===========================================================================
// methods
//===========================================================================
//===========================================================================
// check methods
//===========================================================================
	/**
	 * ݃`FbN
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param errors	G[IuWFNg
	 * @return (true: false:񑶍)
	 */ 
	public static boolean checkRequired(Object o, String name, ActionErrors errors)
	{
		if (! isInput(o)) {
			addErrors(REQUIRED_MSG, name, errors);			//G[ǉ
			return false;
		}
		return true;
	}
	/**
	 * ݃`FbN(I)
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param errors	G[IuWFNg
	 * @return (true: false:񑶍)
	 */ 
	public static boolean checkSelected(Object o, String name, ActionErrors errors)
	{
		if (! isInput(o)) {
			addErrors(SELECTED_MSG, name, errors);			//G[ǉ
			return false;
		}
		return true;
	}
	/**
	 * ݃`FbN(R[hn)
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param types		ftHglz
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static boolean checkRequiredCode(Object o, String name, String[] types, ActionErrors errors)
	{
		boolean ret = true;
		if (isInput(o)) {
			String val = o.toString();
			boolean match = false;
			for (int i = 0; i < types.length; i++) {
				if (val.equals(types[i])) {
					match = true;				//ftHglɈv
					break;
				}
			}
			if (match) {
				addErrors(REQUIRED_MSG, name, errors);	//G[ǉ
				ret = false;
			}
		} else {
			addErrors(REQUIRED_MSG, name, errors);	//G[ǉ
			ret = false;
		}
		
		return ret;
	}
	/**
	 * ^Cṽ`FbN
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param types		肤lz
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static boolean checkType(Object o, String name, String[] types, ActionErrors errors)
	{
		boolean ret = true;
		if (isInput(o)) {
			String val = o.toString();
			boolean match = false;
			for (int i = 0; i < types.length; i++) {
				if (val.equals(types[i])) {
					match = true;							//OK
					break;
				}
			}
			if (!match) {
				addErrors(INVALID_TYPE_MSG, name, errors);	//G[ǉ
				ret = false;
			}
		}
		return ret;
	}
	/**
	 * l`FbN
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static boolean checkNumeric(Object o, String name, ActionErrors errors)
	{
		String numericPattan = "^(\\d)+$";
		boolean ret = true;
		if (isInput(o)) {
			String val = o.toString();
			Pattern p = Pattern.compile(numericPattan);
			Matcher reg = p.matcher(val);
			if (! reg.find()) {
				addErrors(NOT_NUMERIC_MSG, name, errors);	//G[ǉ
				ret = false;
			}
			
		}
		return ret;
	}
	/**
	 * [AhXÓ`FbN
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static boolean checkEmail(Object o, String name, ActionErrors errors)
	{
		String mailPattan = "^(\\w)+@(\\w)+";
		boolean ret = true;
		if (isInput(o)) {
			String val = o.toString();
			Pattern p = Pattern.compile(mailPattan);
			Matcher reg = p.matcher(val);
			if (! reg.find()) {
				addErrors(INVALID_MAIL_MSG, name, errors);	//G[ǉ
				ret = false;
			}
			
		}
		return ret;
	}
	/**
	 * tÓ`FbN
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static boolean checkDate(Object o, String name, String pattan, ActionErrors errors)
	{
		boolean ret = true;
		//parse
		if (isInput(o)) {
			Date date = parseDate(o, pattan);
			if (date == null) {
				
				addErrors(INVALID_DATE_MSG, name, errors);	//G[ǉ
				ret = false;
				
			}
		}
		return ret;
	}
	/**
	 * tϊ
	 *
	 * @param o			lIuWFNg
	 * @param name		ږ
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static Date parseDate(Object o, String pattan) 
	{
		
		Date date = null;
		
		if (isInput(o)) {
			String val = o.toString();
			
			DateFormat df = new SimpleDateFormat(pattan);
			df.setCalendar(Calendar.getInstance());
			try {
				//parse
				date = df.parse(val);
				
				String newDate = df.format(date);
				if (! val.equals(newDate)) {
					date = null;
				}
			} catch (ParseException e) {
				date = null;
			}
		}
		return date;
	}
	/**
	 * `FbN
	 *
	 * @param o1		lIuWFNgP
	 * @param o2		lIuWFNgQ
	 * @param name1		ږP
	 * @param name2		ږQ
	 * @param errors	G[IuWFNg
	 * @return (true:OK false:NG)
	 */ 
	public static boolean checkSame(Object o1, Object o2, String name1, String name2, ActionErrors errors)
	{
		boolean ret = true;
		//͂Ă邩H
		if ((isInput(o1)) && (isInput(o2))) {
			if (! o1.equals(o2)) {
				//
				addErrors(NOT_SAME_MSG, new String[] { name1, name2} , errors);	//G[ǉ
				ret = false;
			}
		//ǂ炩͂ĂȂH
		} else if ((isInput(o1)) || (isInput(o2))) {
			
			addErrors(NOT_SAME_MSG, new String[] { name1, name2} , errors);	//G[ǉ
			ret = false;
		}
		return ret;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 * G[̒ǉ
	 */
	public static void addErrors(String msgId, String name, ActionErrors errors) {
		
//		String s = m_messages.getMessage(name + ".displayname");
	    //07.11.4 wani
		String s = new MessageString().get(name + ".displayname");
		
		//OȂꍇږ𖄂߂
		if(s == null) {
			s = "(" + name + ")";
		}
		errors.add(name, new ActionError(msgId, s));
		
	}
	/**
	 * G[̒ǉ
	 */
	public static void addErrors(String msgId, String[] names, ActionErrors errors) {
		
		String[] s = new String[names.length];
		for (int i = 0; i < names.length; i++) {
//			s[i] = m_messages.getMessage(names[i] + ".displayname");
		    //07.11.4 wani
		    s[i] = new MessageString().get(names[i] + ".displayname");
			//OȂꍇږ𖄂߂
			if(s[i] == null) {
				s[i] = "(" + names[i] + ")";
			}
		}
		errors.add(names[0], new ActionError(msgId, s));
		
	}
	/**
	 * bZ[W̎擾
	 */
	public static String getMessage(String msgId) {
		
//		String s = m_messages.getMessage(msgId);
	    //07.11.4 wani
		String s = new MessageString().get(msgId);
		
		//OȂꍇږ𖄂߂
		if(s == null) {
			s = "(" + msgId + ")";
		}
		return s;
		
	}
//===========================================================================
// utirity methods
//===========================================================================
	/**
	 * ͊mF
	 *
	 * @param o			lIuWFNg
	 * @return (true: false:)
	 */ 
	public static boolean isInput(Object o)
	{
		if (o == null) {
			return false;
		} else {
			String val = o.toString();
			if (val.length() == 0) {
				return false;
			}
		}
		return true;
	}
	/**
	 * ^CvmF
	 *
	 * @param o			lIuWFNg
	 * @return (true: false:)
	 */ 
	public static boolean isType(Object o, String[] types)
	{
		boolean match = false;
		
		if (isInput(o)) {
			String val = o.toString();
			for (int i = 0; i < types.length; i++) {
				if (val.equals(types[i])) {
					match = true;
					break;
				}
			}
		}
		return match;
	}
	/**
	 * fobOo
	 *
	 * @param s o͕
	 */
	private static void debug(String s) {
		System.out.println("[Varidater]" + s);
	}
	/**
	 *	eXgC
	 */ 
	public static void main(String[] args)
	{
		//eXgJn
		System.out.println("----------Checker class Unit Test start!");
		
		//
//		runUnitTest1();
		runUnitTest2();
	}
	/**
	 * checkTypẽeXg
	 */ 
	public static void runUnitTest1()
	{
		
		//eXgJn
		System.out.println("<checkType Test>");
		
		ActionErrors errors = new ActionErrors();
		
		//x敪
		String[] payDivision = 
		{"10","21","22","23","24","25","31","32","33","34","35","61","62","63","64","65","80"};
		
		//test1 f[^
		
		if (! Varidater.checkType("10", "userName", payDivision, errors )) {
			System.out.println("test 1:NG");
		}
		
		//test2 G[f[^1
		if (Varidater.checkType("11", "userName", payDivision, errors )) {
			System.out.println("test 2:NG");
		}
		
		//test3 G[f[^2
		if (Varidater.checkType("PP", "userName", payDivision, errors )) {
			System.out.println("test 3:NG");
		}
		
		//test4 Zf[^
		if (Varidater.checkType("1", "userName", payDivision, errors)) {
			System.out.println("test 4:NG");
		}
		
		//test5 f[^
		if (Varidater.checkType("100", "userName", payDivision, errors )) {
			System.out.println("test 5:NG");
		}
		
		System.out.println("error count = " + errors.size());
		
	}
	/**
	 * parseDatẽeXg
	 */ 
	public static void runUnitTest2()
	{
		
		//eXgJn
		System.out.println("<unit test2>");
		
		String mmdd = "06/30";
		
		Date  date = parseDate(mmdd, Converter.MMDD_PATTAN);
		
		System.out.println(Converter.getDateString(date));
		
		
	}
}
