//===========================================================================
//package
//===========================================================================
package jp.gr.java_conf.bugslife.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *<PRE>
 * 
 * bZ[WǗNX
 * 
 * bZ[W̓ǂݏoэڂ̖ߍ݂sNX
 * 
 * g
 * MessageString.get(bZ[WID, [ߍݏ1,...])
 * 
 * ߍݏ̓bZ[W
 *
 *</PRE>
 * @version	0.0, 2001/06/12
 * @author	k 
 */
//===========================================================================
// version	0.0,2000/12/28	VK쐬
//============================================================================
public class MessageString
{
//============================================================================
// attributes
//============================================================================
	/**
	 * ʕ\pbZ[W\[X
	 */
	private ResourceBundle mBundle = null;
	/**
	 * ʕ\pohpX
	 */
	private final static String BUNDLE_NAME_VIEWMSG = "ApplicationResources";
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//============================================================================
// methods
//============================================================================

	/**
	 * ftHgRXgN^
	 *
	 */
	public MessageString(){
		try {
		    mBundle = ResourceBundle.getBundle(BUNDLE_NAME_VIEWMSG);
		} catch (MissingResourceException mre) {
		    
		}
	}

	/**
	 * bZ[W̎擾(p)
	 *
	 * KAbandleLogMsg(string)AbandleViewMsg(string)sĂ
	 * ̃\bhgp邱ƁB
	 *
	 * @param msgId		bZ[WID
	 * @param bundle	bZ[W\[X
	 */
	public String get(String msgId) 
	{
		String str = null;
		try {
			str = mBundle.getString(msgId);
			
		} catch (MissingResourceException mre) {
			str = "invalid message id = " + msgId + " :args = {0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10}";
		}
		return str;
	}

	/**
	 * bZ[W̎擾уtH[}bg(2ȏ)(p)
	 *
	 * KAbundleLogMsg(string)AbundleViewMsg(string)sĂ
	 * ̃\bhgp邱ƁB
	 *
	 * @param msgId		bZ[WID
	 * @param args		ߍݏ
	 * @param bundle	bZ[W\[X
	 */
	public String get(String msgId, Object[] args)
	{
		String iString = null;
		String value = get(msgId);
		
		try {
			//ߍݏnull`FbN
			Object nonNullArgs[] = args;
			for (int i = 0; i < args.length; i++) {
				if (args[i] == null) {					//nullH
					if (nonNullArgs == args) {			//Rs[ĂȂ
						nonNullArgs = (Object[])args.clone();	//Rs[
					}
					nonNullArgs[i] = "null";			//"null"̕ɒu
				}
			}
			//bZ[W֖ߍ
			iString = MessageFormat.format(value, nonNullArgs);
		} catch (IllegalArgumentException iae) {
			//G[̏ꍇ
			//bZ[W̌Ɉǉ
			StringBuffer buf = new StringBuffer();
			buf.append(value);
			for (int i = 0; i < args.length; i++) {
				buf.append(" arg[" + i + "]=" + args[i]);
			}
			iString = buf.toString();
		}
		return iString;
	}
	/**
	 * bZ[W̎擾уtH[}bg(P)
	 *
	 * @param msgId		bZ[WID
	 * @param arg		ߍݏP
	 * @param bundle	bZ[W\[X
	 */
	public String get(String msgId, Object arg)
	{
		Object[] args = new Object[] {arg};
		return get(msgId, args);
	}
}
