//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.util;

//===========================================================================
// import
//===========================================================================
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.AddressException;

import org.apache.commons.logging.*;
import java.util.Date;

import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;

/**
 *<PRE>
 * [GgNX
 *
 *
 *</PRE>
 * @version	0.1, 2000/11/30
 * @author	k 
 */
//===========================================================================
// version	0.0, 2000/11/30	VK쐬
//===========================================================================
public class MailSender {
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private static Log log = LogFactory.getLog(MailSender.class.getName());
//===========================================================================
// methods
//===========================================================================
	public static void send(MailElements elements)
		throws MessagingException {

		Properties props = new Properties();
		props.put("mail.smtp.host", elements.getSmtphost());
		Session session = Session.getDefaultInstance(props, null);
		MimeMessage mimeMessage = new MimeMessage(session);
		mimeMessage.setFrom(new InternetAddress(elements.getFrom()));
		if (elements.getTo() != null) {
			mimeMessage.setRecipients(Message.RecipientType.TO,
									  getMultipleAddress(elements.getTo()));
		}
		if (elements.getCc() != null) {
			mimeMessage.setRecipients(Message.RecipientType.CC,
									  getMultipleAddress(elements.getCc()));
		}
		String charset = elements.getCharset();
		mimeMessage.setSubject(elements.getSubject(), charset);
		mimeMessage.setText(elements.getBody(), charset);
		
		mimeMessage.setHeader("X-Mailer", elements.getMailer());
		mimeMessage.setSentDate( new Date());
		if ( elements.getMessageId() != null ) {
			mimeMessage.setHeader( "In-Reply-To", elements.getMessageId());
			mimeMessage.setHeader( "References", elements.getMessageId());
			
			//debug
			log.debug("Reply-To = " + elements.getMessageId());
			
		}
		Transport.send(mimeMessage);
		
		//message-Id擾
		elements.setMessageId(mimeMessage.getMessageID());
		
	}

	private static InternetAddress[]
		getMultipleAddress(String[] addresses) 
		throws AddressException {

		int length = addresses.length;
		InternetAddress[] internetAddress = 
			new InternetAddress[length];
		for (int i=0; i<length; i++) {
			internetAddress[i] = new InternetAddress(addresses[i]);
		}
		return internetAddress;
	}
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << MailSender Test Start >> -----------");
		unitTest1(args[0]);		//
		
		System.out.println("------- << MailSender Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * eXgP
	 *
	 */
	public static void unitTest1(String messageId)
	{
		System.out.println("------- unitTest1 -----------");
		
		String body = "\n" +
					"̏#0001XV܂B\n" +
					"\n" +
					"^CgFXVȂ\n" +
					"dvx@F_E\n" +
					"e@@Fwwwwwwwwł܂B\n" +
					"\n";
					
		
		MailElements me = new MailElements();
		me.setFrom("bugslife<wani-m@mail29.silk.ntts.co.jp>");
		me.setSubject("[̏#0001]ʌoHIȂ");
		me.setBody(body);
		me.setMessageId(messageId);
		
		UserInfo user = new UserInfo(7);
		
		me.addTo(user);
		me.addCc(user);
		try {
			MailSender.send(me);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		System.out.println(me.toString());
	}
}
