//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.util;

//===========================================================================
// import
//===========================================================================
import java.text.*;
import java.util.*;
import java.io.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.*;

import java.util.regex.*; 

import jp.gr.java_conf.bugslife.system.*;
/**
 *<PRE>
 * ϊNX
 *
 *
 *</PRE>
 * @version	0.1, 2000/11/30
 * @author	k 
 */
//===========================================================================
// version	0.0, 2000/11/30	VK쐬
// version	0.0, 2001/06/12	notNull, argument̒ǉ(A)
//===========================================================================
public class Converter
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * ttH[}bg^Cv
	 */
	/**  */
	public static final int DATE_TIME = 1;
	public static final String DATE_TIME_PATTAN = "yyyy/MM/dd HH:mm:ss";
	/** t */
	public static final int DATE = 2;
	public static final String DATE_PATTAN = "yyyy/MM/dd";
	/** t̂݁iNQj*/
	public static final int SHORT_DATE	 = 3;	//t̂݁iNQj
	public static final String SHORT_DATE_PATTAN = "yy/MM/dd";
	/** llcc` */
	public static final int MMDD = 4;
	public static final String MMDD_PATTAN = "MM/dd";
	/** llccggll` */
	public static final int MMDDHHMM = 5;
	public static final String MMDDHHMM_PATTAN = "MM/dd HH:mm";
	/** (Z`) */
	public static final int SHORT_DATE_TIME	 = 6;
	public static final String SHORT_DATE_TIME_PATTAN = "yy/MM/dd HH:mm";
	
	/**
	 * ttH[}bgP
	 */
	private static final DateFormat DATE_TIME_FORMAT =  new SimpleDateFormat(DATE_TIME_PATTAN);
	/**
	 * ttH[}bgQ
	 */
	private static final DateFormat DATE_FORMAT =  new SimpleDateFormat(DATE_PATTAN);
	/**
	 * ttH[}bgR
	 */
	private static final DateFormat SHORT_DATE_FORMAT =  new SimpleDateFormat(SHORT_DATE_PATTAN);
	/**
	 * ttH[}bgS
	 */
	private static final DateFormat MMDD_FORMAT =  new SimpleDateFormat(MMDD_PATTAN);
	/**
	 * ttH[}bgT
	 */
	private static final DateFormat MMDDHHMM_FORMAT =  new SimpleDateFormat(MMDDHHMM_PATTAN);
	/**
	 * ttH[}bgU
	 */
	private static final DateFormat SHORT_DATE_TIME_FORMAT =  new SimpleDateFormat(SHORT_DATE_TIME_PATTAN);
	/**
	 * Log
	 */
	private static Log log = LogFactory.getLog(new Converter().getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	String to HTML String
	 *
	 * @param	s	
	 */ 
	public static final String StringToHtml(String s) {
		
		if ((s == null) || (s.length() == 0)) {
			return (new String());
		}
		
		String LF = "\n";
		String BR = "<br>";
		int sPos = 0, ePos;
		
		StringBuffer sb = new StringBuffer(s);
		do {
			sPos = sb.indexOf(LF, sPos);
			
			if (sPos != -1) {
				sb.replace(sPos, sPos+1, BR);
				sPos += BR.length();
			}
		} while(sPos != -1);
		
		return new String(sb);
	}
	/**
	 *	String to HTML String2
	 *
	 * @param	s	
	 */ 
	public static final String StringToHtml2(String s) {
		
		if ((s == null) || (s.length() == 0)) {
			return (new String());
		}
		
		//NXTCgXNvg΍
		String newS = ResponseUtils.filter(s);
		
		//̏ԍɃN
		StringBuffer sb = new StringBuffer();
		String pattan = "(̏|̏ԍ|Q|Qԍ|bug|#)(:|F|#|)?(\\d{1,4})";
		Pattern p = Pattern.compile(pattan);
		Matcher reg = p.matcher(newS);
		int offset = 0;
		int sPos = 0;
		int ePos = 0;
		int sPos2 = 0;
		int ePos2 = 0;
		while (reg.find()) {
			//}b`̎擾
			sPos = reg.start();
			ePos = reg.end();
			sPos2 = reg.start(3);
			ePos2 = reg.end(3);
			
			//擪Ń}b`ȊO
			if (sPos != 0) {
				//}b`܂łRs[
				sb.append(newS.substring(offset, sPos));
			}
			
//			System.out.println("s = " + sPos + " e = " + ePos + " " + newS.substring(sPos, ePos));
//			System.out.println("s2 = " + sPos2 + " e2 = " + ePos2 + " " + newS.substring(sPos2, ePos2));
			
			String word = newS.substring(sPos, ePos);	//}b`P𔲂o
			String bno = newS.substring(sPos2, ePos2);	//}b`P𔲂o
			String url = "<A href=\"../showAll.do?bno=" + bno + "\">" + word + "<A>";//URL
			
			sb.append(url);
			offset = ePos;
			
		}
		if(offset < newS.length()) {
			//}b`܂łRs[
			sb.append(newS.substring(offset));
		}
		
		//url̕t
//		sb = new StringBuffer(matchUrl(sb.toString()));
		
		String text = sb.toString().replaceAll("(http://|https://)([\\w\\[\\]\\-:/?#@!$&'()*+,;=.~%+]+)", "<a href='$0' target='_blank'>$1$2</a>");
		text = text.replaceAll("\\n", "<br>");
		return text;
		
//		//sR[h<br>
//		String LF = "\n";
//		String BR = "<br>";
//		sPos = 0; 
//		ePos = 0;;
//		
//		do {
//			sPos = sb.indexOf(LF, sPos);
//			
//			if (sPos != -1) {
//				sb.replace(sPos, sPos+1, BR);
//				sPos += BR.length();
//			}
//		} while(sPos != -1);
//		
//		return new String(sb);
	}

	/**
	 * URLNt
	 * @param s
	 * @return
	 */
	private static String matchUrl(String s) {
	    
		//URLɃN
		StringBuffer sb = new StringBuffer();

		String pattan2 = "[url:|URL:].*";
		Pattern p2 = Pattern.compile(pattan2);
		Matcher match = p2.matcher(s);
		int offset = 0;
		int sPos = 0;
		int ePos = 0;
		boolean copyed = false;
		while (match.find()) {
			//}b`̎擾
			sPos = match.start();
			ePos = match.end();
			
			//擪Ń}b`ȊO
			if ((sPos != 0) && (!copyed)){
				//}b`܂łRs[
				sb.append(s.substring(offset, sPos));
				copyed = true;
			}


			//Ȃ:ă}b`̂ŁASȏłSڂF̏ꍇAH悤ɔǉ
			//ꂩĂB
			if ((ePos - sPos >= 4) && (":".equals(s.substring(sPos+3, sPos+4)))) {
			
			    String header = s.substring(sPos, sPos+4);
				String url = s.substring(sPos+4, ePos);					//}b`URL𔲂o
				String url2 = "<A href=\"" + url + "\" target=\"_blank\">";	//AJ[
				
				sb.append(header);
				sb.append(url2);
				sb.append(url);
				sb.append("</A>");
				
				offset = ePos;
				copyed = false;
				
			} else {
			    
			}
		}
		if(offset < s.length()) {
			//}b`܂łRs[
			sb.append(s.substring(offset));
		}
		return sb.toString();
	    
	}
	
	/**
	 * tϊiftHgtH[}bg
	 *
	 * param	date	t
	 @ return ϊ
	 */
	public static String getDateString(Date date) {
		
		return getDateString(date, DATE_TIME);
	}
	/**
	 * tϊ
	 *
	 * param	date	t
	 @ return ϊ
	 */
	public static String getDateString(Date date, int format) {
		
		String s = null;
		if (date == null) {
			s = "";
		} else {
			switch(format) {
			case DATE_TIME :
				s = DATE_TIME_FORMAT.format(date);
				break;
			case DATE :
				s = DATE_FORMAT.format(date);
				break;
			case SHORT_DATE :
				s = SHORT_DATE_FORMAT.format(date);
				break;
			case MMDD :
				s = MMDD_FORMAT.format(date);
				break;
			case MMDDHHMM :
				s = MMDDHHMM_FORMAT.format(date);
				break;
			case SHORT_DATE_TIME :
				s = SHORT_DATE_TIME_FORMAT.format(date);
				break;
			default :
				s = DATE_TIME_FORMAT.format(date);
				break;
			}
		}
		return s;
	}
	/**
	 * tϊ
	 *
	 * param	date	t
	 @ return ϊ
	 */
	public static Date toDate(String date, String format){
		
	    Date ret = null;
	    try {
	        SimpleDateFormat sdf = new SimpleDateFormat(format);
	        ret = sdf.parse(date);
	    }catch (Exception e) {
	        //Ԃ
	    }
	    return ret; 
	}
	/**
	 * l擾
	 *
	 * param	num		l
	 * param	format	tH[}bg
	 @ return ϊ
	 */
	public static String getNumberString(long num, String pattan) {
		
		NumberFormat nf = new DecimalFormat(pattan);
		
		return (nf.format(num));
	}
	/**
	 * GR[hꂽ擾
	 *
	 * param	s		
	 @ return ϊ
	 */
	public static String getEncodingString(String s) {
		
		String ss = null;
		try {
			ss = new String(s.getBytes("ISO-8859-1"), "SJIS");
		} catch(IOException e) {
			throw new BLError("Encodeing error", e);
		}
		return ss;
	}
	/**
	 * w肵Xy[XԂ
	 *
	 * param	num		
	 @ return 
	 */
	public static String space(int num) {
		StringBuffer sb = new StringBuffer(num);
		for (int i = 0; i < num; i++) {
			sb.append(" ");
		}
		return (new String(sb));
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[Converter]" + s);
		 
	}
//===========================================================================
// test code
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << AddText Test Start >> -----------");
//		unitTest1();	//tϊ
//		unitTest2();	//K\
		unitTest3();	//K\2
		
		System.out.println("------- << AddText Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * tϊeXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		Date date = new Date();
		String s = null;
		
		//default
		s = Converter.getDateString(date);
		System.out.println("default:" + s);
		
		//DATE_TIME
		s = Converter.getDateString(date, Converter.DATE_TIME);
		System.out.println("DATE_TIME:" + s);
		
		//DATE
		s = Converter.getDateString(date, Converter.DATE);
		System.out.println("DATE:" + s);
		
		//SHORT_DATE
		s = Converter.getDateString(date, Converter.SHORT_DATE);
		System.out.println("SHORT_DATE:" + s);
		
		//MMDD
		s = Converter.getDateString(date, Converter.MMDD);
		System.out.println("MMDD:" + s);
		
		
		
	}
	/**
	 *	unitTest2
	 *
	 * K\eXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//test1
		String s1 = " ̏ԍ:123͌̏456ƏdAQƎv邪AQ7܂͏Qԍ0145̏ł";
		String res = Converter.StringToHtml2(s1);
		System.out.println("s1  = " + s1);
		System.out.println("res = " + res);
		
		//test2
		String s2 = " ̏ԍ#111\n̏ԍ\n0222ƌ̏1";
		res = Converter.StringToHtml2(s2);
		System.out.println("s2  = " + s2);
		System.out.println("res = " + res);
		
		//test3
		String s3 = " #111:123bug12a3Əd";
		res = Converter.StringToHtml2(s3);
		System.out.println("s3  = " + s3);
		System.out.println("res = " + res);
	}
	/**
	 *	unitTest2
	 *
	 * K\eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//test1
		String s1 = " IT2̏ url:https://pjshr118.soln.jp/IJS0012/pjwebroot/tool2/t2DetlList.jsp?TID=7&TD_ID=7&cflag=1\nł";
		String res = Converter.StringToHtml2(s1);
		System.out.println("s1  = " + s1);
		System.out.println("res = " + res);

		//test1
		String s2 = " IT2̏URL\nURL:https://pjshr118.soln.jp/IJS0012/pjwebroot/tool2/t2DetlList.jsp?TID=7&TD_ID=7&cflag=1\nł";
		String res2 = Converter.StringToHtml2(s2);
		System.out.println("s2  = " + s2);
		System.out.println("res2 = " + res2);
		
		
		
		//test3
		String s3 = 
		"url\t\n"+

		"p҃}jA\n"+
		"url:https://pjshr118.soln.jp/IJS0012/pjwebroot/login.jsp?DIRECTOPT=14&categoryNo=13&basedNo=558&targetDir=ELnks8EAsiMlvF1c5q0cfJPSfh61uLD37pMgSN2V-5Hb5qyb--YwHv75_JUwTv7g5jKK\n"+
		"MK\n"+
		"url:https://pjshr118.soln.jp/IJS0012/pjwebroot/login.jsp?DIRECTOPT=14&categoryNo=13&basedNo=558&targetDir=ELnks8EAsiMlvF1c5q0cfJPSfh61uLDS7YUZ_OhwSO7__OhwqYa%25AOdEqqpb5qyb--YwHv75_JUwTv7gf5tVggUZdGEf\n"+
		"A܂ˁB\n";
		String res3 = Converter.StringToHtml2(s3);
		System.out.println("s3  = " + s3);
		System.out.println("res3 = " + res3);

	}
}
