//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.user;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * DispatchListNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class DispatchList implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	[Uԍ
	 */
	private int m_uno = 0;
	/**
	 *	fBXpb`[UNo
	 */
	private int m_dispatchUno = 0;
	/**
	 *	\
	 */
	private int m_dispNo = 0;
	/**
	 *	fBXpb`[U̗
	 */
	private String m_nickname = null;
	/**
	 *	fBXpb`[U̎
	 */
	private String m_name = null;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean m_exclusion = false;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean m_atoIncrement = false;	//
	/**
	 * PK 
	 */
	private static final String[] PK = {"uno", "dispatchUno"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"uno","dispatchUno","dispNo",
									"updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public DispatchList()
	{
		
	}
	/**
	 *	RXgN^([Uԍj
	 *
	 * @param	uid		String^
	 */
	public DispatchList(int uno, int dispatchUno)
	{
		setUno(uno);
		setDispatchUno(dispatchUno);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.insert(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
		
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		
		DAO.load(this);
		
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		
		return DAO.findAll(new DispatchList());
		
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return true;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return true;
	}
//======================================
// Collection
//======================================
	/**
	 *	fBXpb`̎擾
	 *
	 * @return	
	 */
	public static Collection getDispatchList(int uno)
	{
		String sql = 
		    	"SELECT A.uno as uno," +
				"A.dispatchUno as dispatchUno,"+
				"A.dispNo as dispNo," +
				"A.updateUno as updateUno," +
				"A.updateDate as updateDate," +
				"B.nickname as nickname," +
				"B.name as name" +
				" FROM dispatchList AS A" + 
				" LEFT JOIN userinfo AS B ON A.dispatchUno = B.uno" +
				" WHERE A.uno = ?" + 
				" ORDER BY A.dispNo, A.dispatchUno";
		ArrayList params = new ArrayList();
		params.add(new Integer(uno));
		
		return (DAO.find(new DispatchList(), sql, params));
	}
	/**
	 *	fBXpb`̎擾
	 *
	 * @return	
	 */
	public static Collection getEnableDispatchList(int uno)
	{
		String sql = 
		    	"SELECT A.uno as uno," +
				"A.dispatchUno as dispatchUno,"+
				"A.dispNo as dispNo," +
				"A.updateUno as updateUno," +
				"A.updateDate as updateDate," +
				"B.nickname as nickname," +
				"B.name as name" +
				" FROM dispatchList AS A" + 
				" LEFT JOIN userinfo AS B ON A.dispatchUno = B.uno" +
				" WHERE A.uno = ?" + 
				" and B.enableDispatch = 1" +
				" and B.enableLogin = 1" +
				" ORDER BY A.dispNo, A.dispatchUno";
		ArrayList params = new ArrayList();
		params.add(new Integer(uno));
		
		return (DAO.find(new DispatchList(), sql, params));
	}
	/**
	 *	fBXpb`̑݃`FbN
	 *
	 * @return	:true ݂Ȃ:false
	 */
	public static boolean isExist(int uno, int dispatchUno)
	{
		String sql = 
		    	"SELECT uno" +  
				" FROM dispatchList" + 
				" WHERE uno = ? and dispatchUno = ?"; 
		ArrayList params = new ArrayList();
		params.add(new Integer(uno));
		params.add(new Integer(dispatchUno));
		
		ArrayList list = DAO.find(new DispatchList(), sql, params);
		
		return ((list == null) || (list.size() == 0)) ? false : true;
		 
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
	
		HashMap map = new HashMap();
		map.put("uno", Integer.toString(getUno()));
		map.put("dispatchUno", Integer.toString(getDispatchUno()));
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * [Uԍ̎擾
	 * 
	 * @return [Uԍ
	 */
	public int getUno()
	{
		return m_uno;
	}
	/**
	 * [Uԍ̃Zbg
	 * 
	 * @param uno [Uԍ
	 */
	public void setUno(int uno)
	{
		m_uno = uno;
	}
	/**
	 * fBXpb`[U̎擾
	 * 
	 * @return fBXpb`[U
	 */
	public int getDispatchUno()
	{
		return m_dispatchUno;
	}
	/**
	 * fBXpb`[ŨZbg
	 * 
	 * @param uid [Uhc
	 */
	public void setDispatchUno(int dispatchUno)
	{
		m_dispatchUno = dispatchUno;
	}
	/**
	 * \̎擾
	 * 
	 * @return \
	 */
	public int getDispNo()
	{
		return m_dispNo;
	}
	/**
	 * \
	 * 
	 * @param dispNo \
	 */
	public void setDispNo(int dispNo)
	{
		m_dispNo = dispNo;
	}
	/**
	 * ̂̎擾
	 * 
	 * @return 
	 */
	public String getNickname()
	{
		return m_nickname;
	}
	/**
	 * fBXpb`̃fBXpb`s̎擾
	 * 
	 * @return /s
	 */
	public String getEnableDispatchString()
	{
	    String ret = "NG";
        UserInfo dispatch = UserInfo.getUser(m_dispatchUno);
	    if ((dispatch != null) && (dispatch.checkEnableDispatch())){
	        ret = "OK";
	    }
		return ret;
	}
	/**
	 * [U̎擾
	 * 
	 * @return [U
	 */
	public UserInfo getUser()
	{
	    return  UserInfo.getUser(m_dispatchUno);
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [DISPATCH LIST] --- \n");
		sb.append("uno     : " + m_uno + "\n");
		sb.append("dispatch: " + m_dispatchUno + "\n");
		sb.append("dispNo  : " + m_dispNo + "\n");
		sb.append("nickname: " + m_nickname + "\n");
		sb.append("updateUno  : " + m_updateUno + "\n");
		sb.append("updateDate : " + m_updateDate + "\n");
		sb.append("--- [DISPATCH LIST] --- \n");
		return sb.toString();
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[DISPATCH LIST]" + s);
		 
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << dispatchList Test Start >> -----------");
		
/*-------------------------------
		unitTest1();	//VK[U쐬eXg
		unitTest2();	//[UXVeXg
		unitTest3();	//[U폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//[UIDeXg
		unitTest6();	//[UԍwRXgNgeXg
		unitTest7();	//S[U擾eXg
		unitTest8();	//[U擾eXg
-------------------------------*/
		
		System.out.println("------- << dispatchList Test End >> -----------");
	}
	
}