//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.selections;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * SysconfNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Sysconf implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	VXeԍ
	 */
	private byte m_sysno = SYSTEM_NO;
	private static byte SYSTEM_NO = 1;			//VXeԍ͂PŒ
	/**
	 *	VXehc
	 */
	private String m_sysid = null;
	/**
	 *	VXe
	 */
	private String m_sysname = null;
	/**
	 *	VXe
	 */
	private String m_sysinfo = null;
	/**
	 *	JgH
	 */
	private String m_currentPno = null;
	/**
	 *	Jg`oo[W
	 */
	private String m_currentAppver = null;
	/**
	 *	Jgcao[W
	 */
	private String m_currentDbver = null;
	/**
	 *	Jggslko[W
	 */
	private String m_currentHtmlver = null;
	/**
	 *	Jg@\o[W
	 */
	private String m_currentSpecver = null;
	/**
	 *	Ytt@CpX
	 */
	private String m_attachPath = null;
	/**
	 * SMTPAhX
	 */
	private String m_smtpAdress;
	/**
	 * FROMAhX
	 */
	private String m_fromAdress;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = null;
	/**
	 *	[̎gp
	 */
	private int m_disableMail = ENABLE_MAIL;
	public static final int DISABLE_MAIL = 1;//[
	public static final int ENABLE_MAIL = 0;//[L
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"sysno"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
		"sysno","sysid","sysname","sysinfo","currentPno","currentAppver",
		"currentDbver","currentHtmlver","currentSpecver","attachPath",
		"smtpAdress","fromAdress",
		"updateUno" ,"disableMail"};
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Sysconf()
	{
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.insert(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	Sysconf̎擾
	 *
	 * @return	
	 */
	public static Sysconf getSysconf()
	{
		String sql = "SELECT * FROM Sysconf WHERE sysno = ?";
		ArrayList params = new ArrayList();
		params.add(new Byte(SYSTEM_NO));
		ArrayList list = DAO.find(new Sysconf(), sql, params);
		
		Sysconf Sysconf = null;
		if ((list != null) && (list.size() > 0)) {
			Sysconf = (Sysconf)list.get(0);
		}
		return Sysconf;
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// Property
//======================================
	/**
	 * VXeԍ̎擾
	 * 
	 * @return VXeԍ
	 */
	public byte getSysno()
	{
		return m_sysno;
	}
	/**
	 * VXeԍ̃Zbg
	 * 
	 * @param sysno VXeԍ
	 */
	public void setSysno(byte sysno)
	{
		m_sysno = sysno;
	}
	/**
	 * VXeID̎擾
	 * 
	 * @return VXeID
	 */
	public String getSysid()
	{
		return m_sysid;
	}
	/**
	 * VXeID̃Zbg
	 * 
	 * @param sysid VXeID
	 */
	public void setSysid(String sysid)
	{
		m_sysid = sysid;
	}
	/**
	 * VXê̎擾
	 * 
	 * @return VXe
	 */
	public String getSysname()
	{
		return m_sysname;
	}
	/**
	 * VXễZbg
	 * 
	 * @param sysname VXe
	 */
	public void setSysname(String sysname)
	{
		m_sysname = sysname;
	}
	/**
	 * VXe̎擾
	 * 
	 * @return VXe
	 */
	public String getSysinfo()
	{
		return m_sysinfo;
	}
	/**
	 * VXe̎擾
	 * 
	 * @return VXe
	 */
	public String getSysinfoString()
	{
		return Converter.StringToHtml(m_sysinfo);
	}
	/**
	 * VXẽZbg
	 * 
	 * @param sysinfo VXe
	 */
	public void setSysinfo(String sysinfo)
	{
		m_sysinfo = sysinfo;
	}
	/**
	 * JgH̎擾
	 * 
	 * @return JgH
	 */
	public String getCurrentPno()
	{
		return m_currentPno;
	}
	/**
	 * JgH̃Zbg
	 * 
	 * @param currentPno JgH
	 */
	public void setCurrentPno(String currentPno)
	{
		m_currentPno = currentPno;
	}
	/**
	 * Jg`oo[W̎擾
	 * 
	 * @return Jg`oo[W
	 */
	public String getCurrentAppver()
	{
		return m_currentAppver;
	}
	/**
	 * Jg`oo[W̃Zbg
	 * 
	 * @param currentAppver Jg`oo[W
	 */
	public void setCurrentAppver(String currentAppver)
	{
		m_currentAppver = currentAppver;
	}
	/**
	 * Jgcao[W̎擾
	 * 
	 * @return Jgcao[W
	 */
	public String getCurrentDbver()
	{
		return m_currentDbver;
	}
	/**
	 * Jgcao[W̃Zbg
	 * 
	 * @param currentDbver Jgcao[W
	 */
	public void setCurrentDbver(String currentDbver)
	{
		m_currentDbver = currentDbver;
	}
	/**
	 * Jggslko[W̎擾
	 * 
	 * @return Jggslko[W
	 */
	public String getCurrentHtmlver()
	{
		return m_currentHtmlver;
	}
	/**
	 * Jggslko[W̃Zbg
	 * 
	 * @param currentHtmlver Jggslko[W
	 */
	public void setCurrentHtmlver(String currentHtmlver)
	{
		m_currentHtmlver = currentHtmlver;
	}
	/**
	 * Jg@\o[W̎擾
	 * 
	 * @return Jg@\o[W
	 */
	public String getCurrentSpecver()
	{
		return m_currentSpecver;
	}
	/**
	 * Jg@\o[W̃Zbg
	 * 
	 * @param currentSpecver Jg@\o[W
	 */
	public void setCurrentSpecver(String currentSpecver)
	{
		m_currentSpecver = currentSpecver;
	}
	/**
	 * Ytt@CpX̎擾
	 * 
	 * @return Ytt@CpX
	 */
	public String getAttachPath()
	{
		return m_attachPath;
	}
	/**
	 * Ytt@CpX̃Zbg
	 * 
	 * @param attachPath Ytt@CpX
	 */
	public void setAttachPath(String attachPath)
	{
		m_attachPath = attachPath;
	}
	/**
	 * SMTPAhX̎擾
	 * 
	 * @return SMTPAhX
	 */
	public String getSmtpAdress()
	{
		return m_smtpAdress;
	}
	/**
	 * SMTPAhX̃Zbg
	 * 
	 * @param smtpAdress SMTPAhX
	 */
	public void setSmtpAdress(String smtpAdress)
	{
		m_smtpAdress = smtpAdress;
	}
	/**
	 * FROMAhX̎擾
	 * 
	 * @return FROMAhX
	 */
	public String getFromAdress()
	{
		return m_fromAdress;
	}
	/**
	 * FROMAhX̃Zbg
	 * 
	 * @param fromAdress FROMAhX
	 */
	public void setFromAdress(String fromAdress)
	{
		m_fromAdress = fromAdress;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		String s = null;
		if (m_updateDate != null) {
			s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(m_updateDate);
		}
		return s;
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
	// Γc@2007/10/16 insert start
	/**
	 * [Ԃ̃Zbg
	 * 
	 * @param memo 
	 */
	public void setDisableMail(int disableMail) {
		m_disableMail = disableMail;
	}
	/**
	 * [Ԃ̎擾
	 * 
	 * @return 
	 */
	public int getDisableMail() {
		return m_disableMail;
	}
	/**
	 * [wǂ̊mF
	 * 
	 * @return 
	 */
	public boolean isDisableMail(int disableMail)
	{
		return ((m_disableMail & disableMail) > 0 ? true : false);
	}
//	// Γc@2007/10/16 insert end

//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [Sysconf] --- \n");
		sb.append("sysno: " + m_sysno);
		sb.append(" sysid: " + m_sysid);
		sb.append(" sysname: " + m_sysname + "\n");
		
		sb.append("sysinfo   : " + m_sysinfo + "\n");
		
		sb.append("Pno: " + m_currentPno);
		sb.append(" appVer: " + m_currentAppver);
		sb.append(" dbVer: " + m_currentDbver);
		sb.append(" HtmlVer: " + m_currentHtmlver);
		sb.append(" SpecVer: " + m_currentSpecver + "\n");
		
		sb.append("attachPath: " + m_attachPath + "\n");
		sb.append("smtpAdress:"  + m_smtpAdress + "\n");
		sb.append("fromAdress:"  + m_fromAdress + "\n");
		sb.append("updateUno  : " + m_updateUno + "\n");
		sb.append("disableMail : " + m_disableMail + "\n");
		sb.append("updateDate : " + getUpdateDateString() + "\n");
		sb.append("--- [Sysconf] --- \n");
		return sb.toString();
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << Sysconf Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//XVeXg
		unitTest3();	//폜eXg
		
		System.out.println("------- << Sysconf Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//݃`FbN
		Sysconf target = Sysconf.getSysconf();
		if (target != null) {
			//݂Ă폜
			target.delete(1);
		}
		//l̃Zbg
		Sysconf sysconf = new Sysconf();
		sysconf.setSysid("NOF");
		sysconf.setSysname("webI[_[VXe");
		sysconf.setSysinfo("VXe");
		sysconf.setCurrentPno("01");
		sysconf.setCurrentAppver("01");
		sysconf.setCurrentDbver("01");
		sysconf.setCurrentHtmlver("01");
		sysconf.setCurrentSpecver("01");
		sysconf.setAttachPath("/attach/file/hoge/hoge/");
		
		//ǉ
		sysconf.insert(0);
		
		sysconf = Sysconf.getSysconf();		//ǂݍ
		
		System.out.println(sysconf.toString());
	}
	/**
	 *	unitTest2
	 *
	 * XVeXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		Sysconf sysconf = Sysconf.getSysconf();
		if (sysconf == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(sysconf.toString());
		
		sysconf.setSysid("NOF2");
		sysconf.setSysname("webI[_[VXe2");
		sysconf.setSysinfo("VXe2");
		sysconf.setCurrentPno("01");
		sysconf.setCurrentAppver("02");
		sysconf.setCurrentDbver("02");
		sysconf.setCurrentHtmlver("02");
		sysconf.setCurrentSpecver("02");
		sysconf.setAttachPath("/2/");
		//XV
		sysconf.update(1);
		
		sysconf = Sysconf.getSysconf();		//ǂݍ
		System.out.println(sysconf.toString());
	}
	/**
	 *	unitTest3
	 *
	 * [U폜eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//݃`FbN
		Sysconf sysconf = Sysconf.getSysconf();
		if (sysconf == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		//폜
		sysconf.delete(2);
		
		//݃`FbN
		sysconf = Sysconf.getSysconf();
		if (sysconf != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
}