//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.selections;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * SelectionControlNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class SelectionControl
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	e[u
	 */
	private String m_tableName = null;
	/**
	 *	e[u(a)
	 */
	private String m_tableNameJapanses = null;
	/**
	 *	^[QbgNX
	 */
	private Object m_target = null;
	/**
	 *	R[h
	 */
	private String m_code = null;
	/**
	 *	ANV
	 */
	private String m_action = null;
	/**
	 * ΏۃNX
	 */
	private static final String[] SELECTION_CLASS = {
									"ProcessName",
									"Milestone",
									"Subsystem",
									"FunctionName",
									"Resolution",
									"Priority",
									"Severity",
									"Location",
									"Os",
									"Browser",
									"AppVersion",
									"DbVersion",
									"HtmlVersion",
									"SpecVersion",
									"ErrorType",
									"ErrorCause",
									"ErrorPoint",
									"ErrorDelayReason",
									};
	/**
	 * ΏۃNX(a)
	 */
	private static final String[] SELECTION_CLASS_NAME = {
									"H",
									"}CXg[",
									"TuVXe",
									"@\",
									"Ώ@",
									"Dx",
									"̏x",
									"P[V",
									"nr",
									"uEU",
									"`oo[W",
									"cao[W",
									"gslko[W",
									"@\o[W",
									"G[e",
									"G[",
									"G[@\ӏ",
									"G[EoxR",
									};
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public SelectionControl()
	{
		
	}
	/**
	 *	RXgN^(e[uwj
	 *
	 * @param	 tableName	e[u
	 */
	public SelectionControl(String tableName)
	{
		this();
		
		m_target = getTarget(tableName);
		
	}
	/**
	 *	ΏۃNX̐
	 *
	 * @param	 tableName	e[u
	 */
	private Object getTarget(String tableName) {
		//e[u`FbN
		for (int i = 0; i < SELECTION_CLASS.length; i++) {
			if (SELECTION_CLASS[i].equals(tableName)) {
				m_tableName = tableName;
				m_tableNameJapanses = SELECTION_CLASS_NAME[i];
				break;
			}
		}
		if ( m_tableName == null) {
			Assert.check(false, "invalid table name tablename = " + tableName);
		}
		//CX^X
		Object target = null;
		try {
			String className = "jp.gr.java_conf.bugslife.selections." + tableName;
			target = Class.forName(className).newInstance();
			
			if (target == null) {
				Assert.check(false, "instance is null className = " + className);
				
			}
			//ISelectionĂ邩`FbN
			ISelection is  = (ISelection)target;
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return target;
	}
//======================================
// db access methods
//======================================
	/**
	 *	Selection̎擾
	 *
	 * @return	
	 */
	public Object getSelection()
	{
		
		//e[umO
		if (m_tableName == null) {
			
			Assert.check(false, "tableName null");
			
		//e[um
		} else {
			if (m_code != null) {
				ISelection selection = (ISelection)m_target;
				selection.setCode(m_code);
				selection.load();
			}
		}
		return m_target;
	}
	/**
	 *	Collection̎擾
	 *
	 * @return	
	 */
	public Collection getCollection()
	{
		ArrayList list = null;
		
		//e[umO
		if (m_tableName == null) {
			list = new ArrayList(0);
		//e[um
		} else {
			String sql = "SELECT * FROM " + m_tableName + " ORDER BY code";
			ArrayList params = new ArrayList();
			
			//debug
			debug("getCollection" + toString());
			
			list = DAO.find(m_target, sql, params);
		}
		return list;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		if (m_tableName != null) {
			map.put("t", m_tableName);
			if (m_code != null) {
				map.put("code", m_code);
			}
		}
		return map;
	}
	/**
	 *	request parametor̐
	 */
	public String getTableParam(int index) {
		return SELECTION_CLASS[index];
	}
//======================================
// Property
//======================================
	/**
	 * e[u̎擾
	 * 
	 * @return e[u
	 */
	public String getTableName()
	{
		return m_tableName;
	}
	/**
	 * e[ũZbg
	 * 
	 * @param tableName e[u
	 */
	public void setTableName(String tableName)
	{
		m_tableName = tableName;
	}
	/**
	 * e[u̎擾ij
	 * 
	 * @return e[u
	 */
	public String getTableNameString()
	{
		return (m_tableName == null ? "" : m_tableName);
	}
	/**
	 * e[u(a)̎擾
	 * 
	 * @return e[u(a)
	 */
	public String getTableNameJapanese()
	{
		return (m_tableNameJapanses == null ? "" : m_tableNameJapanses);
	}
	/**
	 * R[h̎擾
	 * 
	 * @return R[h
	 */
	public String getCode()
	{
		return m_code;
	}
	/**
	 * R[h̃Zbg
	 * 
	 * @param code R[h
	 */
	public void setCode(String code)
	{
		m_code = code;
	}
	/**
	 * ANV̎擾
	 * 
	 * @return ANV
	 */
	public String getAction()
	{
		return m_action;
	}
	/**
	 * ANṼZbg
	 * 
	 * @param action ANV
	 */
	public void setAction(String action)
	{
		m_action = action;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [SELECTION CONTROL] --- \n");
		sb.append("tableName: " + m_tableName + "(" + m_tableNameJapanses +")\n");
		sb.append("code     : " + m_code + "\n");
		sb.append("target   : " + m_target + "\n");
		sb.append("action   : " + m_action + "\n");
		sb.append("--- [SELECTION CONTROL] --- \n");
		return sb.toString();
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[SelectionControl]" + s);
		 
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << SelectionControl Test Start >> -----------");
		
		unitTest1();	//VK쐬eXg
		unitTest2();	//[heXg
/*------------------------------------------------
		unitTest3();	//폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//R[hwRXgNgeXg
------------------------------------------------*/
		
		System.out.println("------- << SelectionControl Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * XgneXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		SelectionControl sc = null;
		sc = new SelectionControl();
		System.out.println("default contructor");
		System.out.println(sc.getTableNameString());
		System.out.println(sc.getTableNameJapanese());
		displayCollection(sc.getCollection());
		displayMap(sc.getMapping());
		
		String tableName = "Resolution";
		sc = new SelectionControl(tableName);
		System.out.println("table contructor t = " + tableName);
		System.out.println(sc.getTableNameString());
		System.out.println(sc.getTableNameJapanese());
		displayCollection(sc.getCollection());
		displayMap(sc.getMapping());
		
	}
	/**
	 *	unitTest2
	 *
	 * [hneXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		String tableName = "Resolution";
		String code = "01";
		SelectionControl sc = new SelectionControl(tableName);
		sc.setCode(code);
		System.out.println("table = " + tableName + " code = " + code);
		System.out.println(sc.getSelection());
		
		
	}
	/**
	 * RNV̕\
	 */
	private static void displayCollection(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			ISelection col = (ISelection)ite.next();
			
			System.out.println(col.getCode() + "-" + col.getName());
		}
	}
	/**
	 * MAP̕\
	 */
	private static void displayMap(Map map)
	{
		Iterator ite = map.keySet().iterator();
		
		while(ite.hasNext()) {
			String key = (String)ite.next();
			String val = (String)map.get(key);
			
			System.out.println(key + "=" + val);
		}
	}
}