//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.form;

//===========================================================================
// import
//===========================================================================
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.*;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.ValidatorForm;
import java.io.UnsupportedEncodingException;

import java.util.*;

import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.bug.*;

/**
 *<PRE>
 * BugDependencyFormNX
 *
 *</PRE>
 * @author k@
 * @version 1.0.0
 */
public class BugDependencyForm extends ActionForm {
//===========================================================================
// attributes
//===========================================================================
	/**
	 * ANV
	 */
	private String m_action;
	/**
	 * ̏ԍ
	 */
	private int m_bno;
	/**
	 * ȅ
	 */
	private String m_parentBugs;
	/**
	 * ȅ჊Xg
	 */
	private List m_parentBugsList = new ArrayList();
	/**
	 * q̏
	 */
	private String m_childBugs;
	/**
	 * q̏჊Xg
	 */
	private List m_childBugsList = new ArrayList();
	/**
	 * bugDependsNX
	 */
	private BugDepends m_bugDepends = null;
	/**
	 * bZ[WKEY
	 */
	private String m_messageKey;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * ANV̎擾
	 * 
	 * @return ANV
	 */
	public String getAction()
	{
		return m_action;
	}
	/**
	 * ANṼZbg
	 * 
	 * @param action ANV
	 */
	public void setAction(String action)
	{
		m_action = action;
	}
	/**
	 * ̏ԍ̎擾
	 * 
	 * @return ̏ԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * ̏ԍ̃Zbg
	 * 
	 * @param bno ̏ԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * ȅԍ̎擾
	 * 
	 * @return ȅ
	 */
	public String getParentBugs()
	{
		return m_parentBugs;
	}
	/**
	 * ȅ჊Xg̎擾
	 * 
	 * @return ȅ჊Xg
	 */
	public List getParentBugsList()
	{
		return m_parentBugsList;
	}
	/**
	 * ȅ̃Zbg
	 * 
	 * @param parentBugs ȅ
	 */
	public void setParentBugs(String parentBugs)
	{
		m_parentBugs = parentBugs;
	}
	/**
	 * q̏̎擾
	 * 
	 * @return q̏
	 */
	public String getChildBugs()
	{
		return m_childBugs;
	}
	/**
	 * q̏჊Xg̎擾
	 * 
	 * @return q̏჊Xg
	 */
	public List getChildBugsList()
	{
		return m_childBugsList;
	}
	/**
	 * q̏̃Zbg
	 * 
	 * @param childBugs q̏
	 */
	public void setChildBugs(String childBugs)
	{
		m_childBugs = childBugs;
	}
	/**
	 * BugDependsNX̎擾
	 * 
	 * @return BugDependsNX
	 */
	public BugDepends getBugDepends()
	{
		if (m_bugDepends == null) {
			m_bugDepends = new BugDepends();
			m_bugDepends.setBno(m_bno);
			m_bugDepends.load();
		}
		return m_bugDepends;
	}
	/**
	 * ʃbZ[Wkey̎擾
	 * 
	 * @return ʃbZ[Wkey
	 */
	public String getMessageKey()
	{
		return m_messageKey;
	}
	/**
	 * ʃbZ[W̎擾
	 * 
	 * @return ʃbZ[W
	 */
	public String getMessage()
	{
		if (m_messageKey == null) {
			return "";
		} else {
			return Varidater.getMessage(m_messageKey);
		}
	}
	/**
	 * ʃbZ[WkeỹZbg
	 * 
	 * @param messageKey ʃbZ[Wkey
	 */
	public void setMessageKey(String messageKey)
	{
		m_messageKey = messageKey;
	}
//===========================================================================
// Public Methods
//===========================================================================
	/**
	* Zbg
	*
	* @param mapping The mapping used to select this instance
	* @param request The servlet request we are processing
	*/
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		m_action = null;
		m_bno = 0;
		m_parentBugs = null;
		m_parentBugsList = new ArrayList();
		m_childBugs = null;
		m_childBugsList = new ArrayList();
		m_bugDepends = null;
		m_messageKey = null;
	}
	/**
	* Validate the properties that have been set from this HTTP request,
	* and return an <code>ActionErrors</code> object that encapsulates any
	* validation errors that have been found.  If no errors are found, return
	* <code>null</code> or an <code>ActionErrors</code> object with no
	* recorded error messages.
	*
	* @param mapping The mapping used to select this instance
	* @param request The servlet request we are processing
	*/
	public ActionErrors validate(ActionMapping mapping,
								 HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		//debug
		log.debug("validate");
		
		//ANV
		if (Varidater.checkRequired(m_action, "action", errors)) {
			
			//quickH
			if (m_action.equals("update")) {
				
				//̏ԍ̉
				m_parentBugsList = 
						parseChoiceBno(m_parentBugs, "bno", errors);
				m_childBugsList = 
						parseChoiceBno(m_childBugs, "bno", errors);
				
				//̏ԍ̑݃`FbN
				existBno(m_parentBugsList, "bno", errors);
				existBno(m_childBugsList, "bno", errors);
				
				if (errors.empty()) {
					//̏ԍ̈ˑ֌W`FbN
					relationCheck(m_parentBugsList, m_childBugsList, "bno", errors);
				}
			}
		}
		
		return errors;
	}

//===========================================================================
// parser Methods
//===========================================================================
	/**
	 * ̏ԍ̉
	 * 
	 * @return ̏ԍ
	 */
	private List parseChoiceBno(String bnos, String name, ActionErrors errors) {
		
		List bnoList = new ArrayList();
		
		//J}ŕȂA͂Ă
		StringTokenizer st = new StringTokenizer(bnos, ",");
		while (st.hasMoreTokens()) {
			String token = st.nextToken();
			//token͋󂩁H
			if ((token != null) && (token.length() > 0)) {
				//łȂ
				//l`FbN
				if (Varidater.checkNumeric(token, "#" + token, errors)) {
					//Xgǉ
					bnoList.add(new Integer(token));
				}
			}
		}
		
		return bnoList;
	}

	/**
	 * ̏ԍ̑݃`FbN
	 * 
	 * @return ̏ԍ
	 */
	private void existBno(List list, String name, ActionErrors errors) {
		
		Iterator ite = list.iterator();
		
		Bug bug = null;
		int bno = 0;
		while (ite.hasNext()) {
			bno =((Integer)ite.next()).intValue();
			bug = Bug.getBug(bno);
			
			//݃`FbN
			if (bug == null) {
				Varidater.addErrors("varid.invalid_bno", "#" + Converter.getNumberString(bno, "0000"), errors);
			}
		}
	}
	/**
	 * ̏ԍ̈ˑ֌W`FbN
	 * 
	 * @return ̏ԍ
	 */
	private void relationCheck(List parentList, List childList, String name, ActionErrors errors) {
		
		ArrayList parentSet = new ArrayList();
		ArrayList childSet = new ArrayList();
		
		int bno =0;
		BugDependsTree tree = null;
		
		
		//eԍXg̏d`FbN
		boolean duplicateFlag = false;
		for (int i = 0; i < parentList.size(); i++) {
			for (int j = i + 1; j < parentList.size(); j++) {
				if (((Integer)parentList.get(i)).compareTo((Integer)parentList.get(j)) == 0) {
					duplicateFlag = true;
					break;
				}
			}
			if ( ((Integer)parentList.get(i)).compareTo(new Integer(getBno())) == 0 ) {
				duplicateFlag = true;
				break;
			}
		}
		if (duplicateFlag) {
			Varidater.addErrors("varid.relationBno", name, errors);
			return;
		}
		
		//qԍXg̏d`FbN
		duplicateFlag = false;
		for (int i = 0; i < childList.size(); i++) {
			for (int j = i + 1; j < childList.size(); j++) {
				if (((Integer)childList.get(i)).compareTo((Integer)childList.get(j)) == 0) {
					duplicateFlag = true;
					break;
				}
			}
			if ( ((Integer)childList.get(i)).compareTo(new Integer(getBno())) == 0 ) {
				duplicateFlag = true;
				break;
			}
		}
		if (duplicateFlag) {
			Varidater.addErrors("varid.relationBno", name, errors);
			return;
		}
		
		//SĂ̐eTree̍쐬
		Iterator parentIte = parentList.iterator();
		while (parentIte.hasNext()) {
			bno = ((Integer)parentIte.next()).intValue();
			tree = new BugDependsTree(bno);
		//	parentSet = new TreeSet(tree);
			parentSet.add(tree);
			parentSet.addAll(tree.getAllParents());
		}
		//SĂ̎qTree̍쐬
		Iterator childIte = childList.iterator();
		while (childIte.hasNext()) {
			bno = ((Integer)childIte.next()).intValue();
			tree = new BugDependsTree(bno);
		//	childSet = new TreeSet(tree);
			childSet.add(tree);
			childSet.addAll(tree.getAllChilds());
		}
		
		//eSetƎqSetœ̂邩`FbN
		if ( (parentSet != null) && (childSet != null) ) {
			for (int i = 0; i < parentSet.size(); i++) {
				for (int j = 0; j < childSet.size(); j++) {
					if (((BugDependsTree)parentSet.get(i)).getBno() == 
							((BugDependsTree)childSet.get(j)).getBno() ) {
						Varidater.addErrors("varid.relationBno", name, errors);
						return;
					}
				}
			}
		}
	}

//===========================================================================
// Test
//===========================================================================
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << BugDependsTree Test Start >> -----------");
		unitTest1();	//dispTreeeXg
		
		System.out.println("------- << BugDependsTree Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		int bno = 2;	//oOԍ
		//l̃Zbg
		BugDependencyForm form = new BugDependencyForm();
		form.setBno(bno);
		
		List parentList = new ArrayList();
		parentList.add(new Integer(1));
		parentList.add(new Integer(6));
		List childList = new ArrayList();
		childList.add(new Integer(3));
		childList.add(new Integer(5));
		String name = "bno";
		ActionErrors errors = new ActionErrors();
		form.relationCheck(parentList, childList, name, errors);
		
		
	}

}