//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * MemberStatisticsNX
 * 
 * TATvp̃~jNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class MemberStatistics implements ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	SҖ
	 */
	private String m_name;
	/**
	 *	Xe[^X
	 */
	private byte m_status;
	/**
	 *	bno
	 */
	private int m_bno;
	/**
	 *	^Cg
	 */
	private String m_title;
	
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//=====================================
// DBpڒ`
//=====================================
	/**
	 * PK 
	 */
	private static final String[] PK = {"name"};
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public MemberStatistics()
	{
	}
//======================================
// Db Interface
//======================================
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
//======================================
// Property
//======================================
	/**
	 * bno̎擾
	 * 
	 * @return bno
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * bno̎擾()
	 * 
	 * @return bnoString
	 */
	public String getBnoString()
	{
		return Converter.getNumberString(m_bno, "0000");
	}
	/**
	 * bnõZbg
	 * 
	 * @param bno bno
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * Xe[^X̎擾
	 * 
	 * @return Xe[^X
	 */
	public byte getStatus()
	{
		return m_status;
	}
	/**
	 * Xe[^X̎擾()
	 * 
	 * @return Xe[^X
	 */
	public String getStatusString()
	{
		return Bug.getStatusString(m_status);
	}
	/**
	 * Xe[^X̃Zbg
	 * 
	 * @param status Xe[^X
	 */
	public void setStatus(byte status)
	{
		m_status = status;
	}
	/**
	 * S̎擾
	 * 
	 * @return S
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * S̃Zbg
	 * 
	 * @param name S
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * ^Cg̎擾
	 * 
	 * @return ^Cg
	 */
	public String getTitle()
	{
		return m_title;
	}
	/**
	 * ^Cg̃Zbg
	 * 
	 * @param title ^Cg
	 */
	public void setTitle(String title)
	{
		m_title = title;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("bno", new Integer(m_bno));
		return map;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [MemberStatistics] --- \n");
		sb.append("bno   : " + m_bno + "\n");
		sb.append("status: " + m_status + "\n");
		sb.append("name  : " + m_name + "\n");
		sb.append("title : " + m_title + "\n");
		sb.append("--- [MemberStatistics] --- \n");
		return sb.toString();
	}
}