//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;

import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.util.*;
/**
 *<PRE>
 * 
 * ReportActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class ReportAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		/*  
		 */
		HttpSession session = getSession(request);	//sessio̎擾
		UserInfo user = (UserInfo)getAttribute(session,"UserInfo");	//OC[U̎擾
		ActionForward forward = null;
		ReportForm myForm = (ReportForm)form;
		
		String action = myForm.getAction();
		String reportType = myForm.getReportType();
		//debug
		log.debug("action = " + action + " reportType = " + reportType);
		
		//ʕ\
		if (action.equals("show")) {
			
			//JgHftHg̍HɃZbgB
			String[] pno = new String[1];
			pno[0] = Sysconf.getSysconf().getCurrentPno();
			myForm.setProcessName(pno);
			
			//͉ʕ\
			forward = mapping.findForward("init");
			
		//
		} else {
			
			Collection bugNumbers = null;			//oOԍXg
			Collection bugs = null;					//oOXg
			
			//f[^`FbN
			ActionErrors errors = myForm.validate(mapping, request);
			if (!errors.empty()) {
				saveErrors(request, errors);
				//͉ʂɖ߂
				forward = new ActionForward(mapping.getInput());
				
			} else {
				//Wv(Tv)
				if (reportType.equals("1")) {
					//T|[g
					Varidater.addErrors("error.unsuport.type", "reportType", errors);
					saveErrors(request, errors);
					forward = new ActionForward(mapping.getInput());	//͉ʂɖ߂
					
				//Wv(v)
				} else if (reportType.equals("2")) {
					//T|[g
					Varidater.addErrors("error.unsuport.type", "reportType", errors);
					saveErrors(request, errors);
					forward = new ActionForward(mapping.getInput());	//͉ʂɖ߂
					
				//Sҕʌ̏ꗗ
				} else if (reportType.equals("3")) {
					performStatistics3(myForm,session);
					
					//敪ꗗ֑Jڂ
					forward = mapping.findForward("report3");
					
				//sҕʌ̏ꗗ
				} else if (reportType.equals("4")) {
					
					performStatistics4(myForm,session);
					
					//敪ꗗ֑Jڂ
					forward = mapping.findForward("report4");
					
				//敪ʏWv
				} else if (reportType.equals("5")) {
					
					performStatistics5(myForm,session);
					
					//敪ꗗ֑Jڂ
					forward = mapping.findForward("report5");
					
				//G[@\ʏWvi_Wvj
				} else if (reportType.equals("6")) {
					
					performStatistics6(myForm,session);
					
					//敪ꗗ֑Jڂ
					forward = mapping.findForward("report6");
					
				//TuVXeʏQ
				} else if (reportType.equals("7")) {
					//T|[g
					Varidater.addErrors("error.unsuport.type", "reportType", errors);
					saveErrors(request, errors);
					forward = new ActionForward(mapping.getInput());	//͉ʂɖ߂
					
				//s`sWv
				} else if (reportType.equals("8")) {
					performStatistics8(myForm,session);
					
					//敪ꗗ֑Jڂ
					forward = mapping.findForward("report8");
					
				//oOWviij
				} else if (reportType.equals("9")) {
					//T|[g
					Varidater.addErrors("error.unsuport.type", "reportType", errors);
					saveErrors(request, errors);
					forward = new ActionForward(mapping.getInput());	//͉ʂɖ߂
					
				} else {
					
					Assert.check(false, "invalid reportType type = " + reportType);
					
				}
				
			}
		}
		// Forward control to the specified success URI
		return forward;
	}
	/**
	 * SҕʏWv
	 */
	private void performStatistics3(ReportForm myForm, HttpSession session) {
		//
		String where = new String(myForm.getWhere());
		
		//SҕʏWv
		Collection dispatchs = BugFinder.getDispatchStatistics(
						where, myForm.getParams());
		
		//ZbVɃZbg
		session.setAttribute("stDispatchs", dispatchs);
		
	}
	/**
	 * sҕʏWv
	 */
	private void performStatistics4(ReportForm myForm, HttpSession session) {
		//
		String where = new String(myForm.getWhere());
		
		//sҕʏWv
		Collection issuers = BugFinder.getIssuerStatistics(
						where, myForm.getParams());
		
		//debug
/*-----------------------------
		Iterator ite = issuers.iterator();
		while(ite.hasNext()) {
			BugListStatistics bug = (BugListStatistics)ite.next();
			
			log.debug(bug.toString());
		}
-----------------------------*/
		
		//ZbVɃZbg
		session.setAttribute("stIssuers", issuers);
		
	}
	/**
	 * 敪Wv
	 */
	private void performStatistics5(ReportForm myForm, HttpSession session) {
		//
		String where = new String(myForm.getWhere());
		
		//G[^CvWv
		Collection errorTypes = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_ERROR_TYPE,		//G[^CvWv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stErrorTypes", errorTypes);
		
		//G[Wv
		Collection errorCause = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_ERROR_CAUSE,		//G[Wv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stErrorCauses", errorCause);
		
		//QHWv
		Collection issuPnos = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_ISSU_PNO,		//HWv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stIssuPnos", issuPnos);
		
		//QHWv
		Collection trainPnos = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_TRAIN_PNO,		//HWv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stTrainPnos", trainPnos);
		
		//EoׂHWv
		Collection shouldFindPnos = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_SHOULD_FIND_PNO,		//EoׂHWv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stShouldFindPnos", shouldFindPnos);
		
		//EoxRWv
		Collection errorDelayReason = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_ERROR_DELAY_REASON,		//EoxRWv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stErrorDelayReasons", errorDelayReason);
		
	}
	/**
	 * G[@\Wv
	 */
	private void performStatistics6(ReportForm myForm, HttpSession session) {
		//
		String where = new String(myForm.getWhere());
		
		//G[^CvWv
		Collection errorPoints = BugFinder.getSelectionStatistics(
						BugFinder.STYPE_ERROR_POINT,		//G[@\Wv
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stErrorPoints", errorPoints);
		
	}
	/**
	 * s`sWv
	 */
	private void performStatistics8(ReportForm myForm, HttpSession session) {
		//
		String where = new String(myForm.getWhere());
		
		//s`sWv
		Collection tats = BugFinder.getTatStatistics(
						where, myForm.getParams());
		//ZbVɃZbg
		session.setAttribute("stTats", tats);
		
	}
	/**
	 * display(debug)
	 */
	private void display(Collection list) {
		
		Iterator ite = list.iterator();
		while(ite.hasNext()) {
			
			ChoiceBug bug = (ChoiceBug)ite.next();
//			Bug bug = (Bug)ite.next();
			log.debug(bug.toString());
			
		}
		
	}
}
