//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.db.*;
import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.system.*;
import jp.gr.java_conf.bugslife.util.Converter;
import jp.gr.java_conf.bugslife.util.Assert;
import jp.gr.java_conf.bugslife.util.Varidater;
/**
 *<PRE>
 * 
 * EditAddTextActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class EditAddTextAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Form
	 */
    EditAddTextForm m_form;
	/**
	 * session
	 */
	HttpSession m_session;
	/**
	 * logonUser
	 */
	UserInfo m_logonUser;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public synchronized ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		ActionForward forward = null;
		/*
		 * 
		 */
		m_form = (EditAddTextForm)form;	//form̎擾
		m_session = getSession(request);//sessio̎擾
		m_logonUser = (UserInfo)getAttribute(m_session,"UserInfo");	//OC[U̎擾
		FullBug bug = (FullBug)getAttribute(m_session,"showBug");	//oO̎擾
		
		String action = m_form.getAction();
		//debug
		log.debug(	"action =" + action + 
					" bno = " + m_form.getBno() );
		
		//\̏ꍇ
		if (action.equals("show")){
			
		    AddText text = new AddText();
		    text.setBno(m_form.getBno());
		    text.setEntryDate(new Date(m_form.getEntryDateLong()));
		    text.load();
		    //͏Zbg
			PropertyUtils.copyProperties(m_form, text);
			//ʕ\p
			m_session.setAttribute("addText", text);
			
			log.debug(text);
			
			//show֑J
			forward = mapping.findForward("show");
			
			
		//XV̏ꍇ
		} else if (action.equals("update")){
			

			//`FbN
			ActionErrors errors = m_form.validate(mapping, request);
			if (!errors.empty()) {
				 saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			try {
			    AddText text = (AddText)m_session.getAttribute("addText");	//eLXg̎擾

			    //͏addtextɃRs[
				PropertyUtils.copyProperties(text, m_form);
				
				//\ݒ̏ꍇ
				if (m_form.getDelFlg() == 1) {
				    text.setDelUno(m_logonUser.getUno());
				    text.setDelDate(new Date());
				} else {
				    //eXV
				    text.setDelUno(0);
				    text.setDelDate(null);
				    
				    text.setModifyUno(m_logonUser.getUno());
				    text.setModifyDate(new Date());
				}
			    text.update(m_logonUser.getUno());
			    
			    //LbVꂽǉeLXgNA
			    bug.clearAddText();
			    
				//success֑J
				forward = mapping.findForward("success");
				
			//rO
			} catch (ExclusionException ee) {
				//debug
				log.debug("ExclusionException", ee);
				
				Varidater.addErrors("exp.exclusion", "addText", errors);
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
				
			}
			//폜̏ꍇ
		}
		// Forward control to the specified success URI
		return forward;
	}
}
