//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.db.*;
import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.system.*;
import jp.gr.java_conf.bugslife.util.Converter;
import jp.gr.java_conf.bugslife.util.Assert;
import jp.gr.java_conf.bugslife.util.Varidater;
/**
 *<PRE>
 * 
 * BugDetail5ActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class BugDetail5Action extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Form
	 */
	BugDetail5Form m_form;
	/**
	 * session
	 */
	HttpSession m_session;
	/**
	 * Bug
	 */
	Bug m_bug = null;
	/**
	 * Bug
	 */
	UserInfo m_logonUser;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
	/**
	 * to
	 */
	private int m_toUno;
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public synchronized ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		ActionForward forward = null;
		/*
		 * 
		 */
		m_form = (BugDetail5Form)form;	//form̎擾
		m_session = getSession(request);//sessio̎擾
		m_logonUser = (UserInfo)getAttribute(m_session,"UserInfo");	//OC[U̎擾
		m_bug = (Bug)m_session.getAttribute("bug");	//oO̎擾
		
		String action = m_form.getAction();
		//debug
		log.debug(	"action =" + action + 
					" submiteType = " + m_form.getSubmitType() +
					" bno = " + m_form.getBno() +
					" bno(s) = " + (m_bug == null ? "null" : ""+m_bug.getBno()));
		
		//\̏ꍇ
		if (action.equals("show")){
			
			//=========================
			//bugCX^X̎擾
			//=========================
			//ZbVɖbnoႤꍇ
			if ((m_bug == null) || (m_bug.getBno() != m_form.getBno())) {
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̃Zbg
				m_session.setAttribute("bug", m_bug);
			
			//̃oOXVĂꍇ
			} else {
				if (m_bug.isChanged()){
					//debug
					log.debug("is changed!");
					
					//oOCX^X̎擾
					m_bug = new Bug(m_form.getBno());
					//oOCX^X̃Zbg
					m_session.setAttribute("bug", m_bug);
				}
			}
			
			//͏Zbg
			PropertyUtils.copyProperties(m_form, m_bug);
			
			//show֑J
			forward = mapping.findForward("show");
			
			
		//XV̏ꍇ
		} else {
			
			//=========================
			//bugCX^X̎擾
			//=========================
			if ((m_bug == null) || (m_bug.getBno() != m_form.getBno())) {
				//xI
				log.warn("unmatch bno ");
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̍ăZbg
				m_session.setAttribute("bug", m_bug);
			}
			
			//`FbN
			ActionErrors errors = m_form.validate(mapping, request);
			if (!errors.empty()) {
				 saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			try {
				//擾Jn
				m_bug.startActivity();
				
				//͏Zbg
				PropertyUtils.copyProperties(m_bug, m_form);
				//͏^CṽZbg
				m_bug.setInputType(Bug.ITYPE_DETAIL5);	
				//Xe[^X̍XV
				updateStatus();
				//r`FbN˂Ă܂XVB
				m_bug.update(m_logonUser.getUno());		//XV
				
				
				//mFe̒ǉ
				m_bug.addText(m_form.getAddText(), m_logonUser);
				//̎擾I
				m_bug.endActivity();
				
				//Ă
				Activitys act = m_bug.getActivitys();
				//[MsvłȂ
				if (! m_form.getDontSendMail()) {
					//[M
					act.sendMail(m_logonUser, request);
				}
				//̏o
				act.addActivity(m_logonUser);
				
				//OUPDATEĂ邽߂ɍXVeςȂꍇA
				//setPersistDateł̃j[NArG[ƂȂ
				//̂JDBChCoςĎ邪AƂ肠r`FbN
				//͂čXVB
				
				m_bug.update(m_logonUser.getUno(), false);		//rȂ̍XV
				
				//success֑J
				forward = mapping.findForward("success");
			//rO
			} catch (ExclusionException ee) {
				//debug
				log.debug("ExclusionException", ee);
				
				Varidater.addErrors("exp.exclusion", "bug", errors);
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
				
			}
		}
		// Forward control to the specified success URI
		return forward;
	}
	/**
	 * Xe[^X̕ύX
	 */
	private void updateStatus() {
		
		String submitType = m_form.getSubmitType();
		
		//log
		log.debug("submiteType = " + submitType);
		log.debug("comfirmer = " + m_form.getRequestAssigne()
		);
		
		//mFnjij
		if (submitType.equals("close")) {
			m_bug.setComfirmer(m_logonUser.getUno());	//mF
			m_bug.setComfirmDate(new Date());			//mF
			m_bug.setReleaseDate(new Date());			//ݒ
			
			m_bug.setStatus(Bug.STS_CLOSE);
		
		//ĊJ
		} else if (submitType.equals("reopen")) {
			
			m_bug.setStatus(Bug.STS_REOPEN);
			
		//C
		} else if (submitType.equals("repaired")) {
			
			m_bug.setStatus(Bug.STS_REPAIRED);
			
		//͒
		} else if (submitType.equals("investigation")) {
			
			m_bug.setStatus(Bug.STS_INVESTIGATION);
			
		//Xe[^XmFɂăfBXpb`
		} else if (submitType.equals("sameAssigne")) {
			int assign = Integer.parseInt(m_form.getRequestAssigne());
			m_bug.setComfirmer(assign);
			//
			m_bug.setStatus(Bug.STS_RESOLVED);
		
		//̂܂
		} else if (submitType.equals("same")) {
			//ȂɂȂ
			
		//Xe[^X󋵕ύX
		} else if (submitType.equals("statusWhitebord")) {
			
			m_bug.setStatusWhitebord(m_form.getRequestStatusWhitebord());
			
		}
	}
}
