//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.db.*;
import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.system.*;
import jp.gr.java_conf.bugslife.util.Converter;
import jp.gr.java_conf.bugslife.util.Assert;
import jp.gr.java_conf.bugslife.util.Varidater;
/**
 *<PRE>
 * 
 * BugDetail1ActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class BugDetail1Action extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Form
	 */
	BugDetail1Form m_form;
	/**
	 * session
	 */
	HttpSession m_session;
	/**
	 * Bug
	 */
	Bug m_bug = null;
	/**
	 * Bug
	 */
	UserInfo m_logonUser;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
	/**
	 * to
	 */
	private int m_toUno;
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public synchronized ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		ActionForward forward = null;
		/*
		 * 
		 */
		m_form = (BugDetail1Form)form;	//form̎擾
		m_session = getSession(request);//sessio̎擾
		m_logonUser = (UserInfo)getAttribute(m_session,"UserInfo");	//OC[U̎擾
		m_bug = (Bug)m_session.getAttribute("bug");	//oO̎擾
		
		String action = m_form.getAction();
		//debug
		log.debug(	"action =" + action + 
					" submiteType = " + m_form.getSubmitType() +
					" bno = " + m_form.getBno() +
					" bno(s) = " + (m_bug == null ? "null" : ""+m_bug.getBno()));
		
		//VK̏ꍇ
		if (action.equals("new")) {
			
			//VKCX^X̐
			m_bug = new Bug();
			//oOCX^X̃Zbg
			m_session.setAttribute("bug", m_bug);
			
			//Jg̃Zbg
			/*
			 * ͏Zbg
			 */
			//VXe̎擾
//			Sysconf sysconf = (Sysconf)m_session.getAttribute("sysconf");
			Sysconf sysconf = Sysconf.getSysconf();
			
			m_form.setIssuPno(sysconf.getCurrentPno());
			m_form.setAppVersion(sysconf.getCurrentAppver());
			m_form.setDbVersion(sysconf.getCurrentDbver());
			m_form.setHtmlVersion(sysconf.getCurrentHtmlver());
			m_form.setSpecVersion(sysconf.getCurrentSpecver());
			
			//add wani 07/10/23
			String pno = m_logonUser.getDefPno();
			if (pno != null) {
				m_form.setIssuPno(pno);
			}
			m_form.setLocation(m_logonUser.getDefLocation());
			m_form.setSubsystem(m_logonUser.getDefSubsystem());
			m_form.setFunctionName(m_logonUser.getDefFunctionName());
			
			
			Date date = new Date();
			m_form.setIssuDate(date);
			m_form.setIssuDateString(Converter.getDateString(date, BugDetail1Form.ISSU_DATE));
			
			//show֑J
			forward = mapping.findForward("show");
			
		//\̏ꍇ
		} else if (action.equals("show")){
			
			//=========================
			//bugCX^X̎擾
			//=========================
			//ZbVɖbnoႤꍇ
			if ((m_bug == null) || (m_bug.getBno() != m_form.getBno())) {
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̃Zbg
				m_session.setAttribute("bug", m_bug);
			
			//̃oOXVĂꍇ
			} else {
				if (m_bug.isChanged()){
					//debug
					log.debug("is changed!");
					
					//oOCX^X̎擾
					m_bug = new Bug(m_form.getBno());
					//oOCX^X̃Zbg
					m_session.setAttribute("bug", m_bug);
				}
			}
			//͏Zbg
			PropertyUtils.copyProperties(m_form, m_bug);
			
			//show֑J
			forward = mapping.findForward("show");
			
		//XV̏ꍇ
		} else {
			
			//=========================
			//bugCX^X̎擾
			//=========================
			if ((m_bug == null) || (m_bug.getBno() != m_form.getBno())) {
				//xI
				log.warn("unmatch bno ");
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̍ăZbg
				m_session.setAttribute("bug", m_bug);
			}
			
			m_form.setBno(m_bug.getBno());
			//`FbN
			ActionErrors errors = m_form.validate(mapping, request);
			if (!errors.empty()) {
				 saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			//VK
			if (m_bug.getBno() == 0) {
				
				//擾Jn
				m_bug.startActivity();
				
				//======================
				// ǉ
				//======================
				//͏Zbg
				PropertyUtils.copyProperties(m_bug, m_form);
				
				//o^Ao^҂̃Zbg
				m_bug.setRegistDate(new Date());
				m_bug.setIssuer(m_logonUser.getUno());
				updateStatus();							//Xe[^X̍XV
				
				//DB̒ǉ
				m_bug.insert(m_logonUser.getUno());		//bnom
				
				//======================
				// XV
				//======================
				// xCT[gȂƌ̏ԍƂȂ߁A
				// CT[gɌ̏ID𐶐UPDATEB
				// ̏ԍmȀhc𐶐AUPDATEB
				//VXe̎擾
//				Sysconf sysconf = (Sysconf)m_session.getAttribute("sysconf");
				m_bug.makeBid(Sysconf.getSysconf().getSysid());		//shc̐
				m_bug.setInputType(Bug.ITYPE_DETAIL0);	//͏^CṽZbg
				
				//̏e̒ǉ
				m_bug.addText(m_form.getTroubleSituation(), m_logonUser);
				//̎擾I
				m_bug.endActivity();
				
				//Ă
				Activitys act = m_bug.getActivitys();
				//[MsvłȂ
				if (! m_form.getDontSendMail()) {
					//[M
					act.sendMail(m_logonUser, request);
				}
				//̏o
				act.addActivity(m_logonUser);
				
				m_bug.update(m_logonUser.getUno(), false);		//XV
				
				//oOCX^X̃Zbg
				m_session.setAttribute("bug", m_bug);
				
			//XV
			} else {
				
				try {
					
					//擾Jn
					m_bug.startActivity();
					
					//͏Zbg
					PropertyUtils.copyProperties(m_bug, m_form);
					//͏^CṽZbg
					m_bug.setInputType(Bug.ITYPE_DETAIL1);	
					//Xe[^X̍XV
					updateStatus();	
					//r`FbN˂Ă܂XVB
					m_bug.update(m_logonUser.getUno());		//XV
					
					//̏e̒ǉ
					m_bug.addText(m_form.getTroubleSituation(), m_logonUser);
					
					//̎擾I
					m_bug.endActivity();
					
					//Ă
					Activitys act = m_bug.getActivitys();
					//[MsvłȂ
					if (! m_form.getDontSendMail()) {
						//[M
						act.sendMail(m_logonUser, request);
					}
					//̏o
					act.addActivity(m_logonUser);
					
					//OUPDATEĂ邽߂ɍXVeςȂꍇA
					//setPersistDateł̃j[NArG[ƂȂ
					//̂JDBChCoςĎ邪AƂ肠r`FbN
					//͂čXVB
					
					m_bug.update(m_logonUser.getUno(), false);		//rȂ̍XV
				//rO
				} catch (ExclusionException ee) {
					//debug
					log.debug("ExclusionException", ee);
					
					Varidater.addErrors("exp.exclusion", "bug", errors);
					saveErrors(request, errors);
					return (new ActionForward(mapping.getInput()));
					
				}
				
			}
			
			//success֑J
			forward = mapping.findForward("success");
			
		}
		
		// Forward control to the specified success URI
		return forward;
	}
	/**
	 * Xe[^X̕ύX
	 */
	private void updateStatus() {
		
		String submitType = m_form.getSubmitType();
		
		//log
		log.debug("submiteType = " + submitType);
		log.debug("auter = " + m_form.getRequestAuther() +
				  " analyst = " + m_form.getRequestAnalyst()
		);
		
		//Q\
		if (submitType.equals("newAuther")) {
			int auther = Integer.parseInt(m_form.getRequestAuther());
			
			m_bug.setRegistDate(new Date());
			m_bug.setIssuer(m_logonUser.getUno());
			m_bug.setAuther(auther);
			
			m_bug.setStatus(Bug.STS_NEW);
			
			//
			m_bug.setDispatch();		//fBXpb`
			
		//Q\
		} else if (submitType.equals("new")) {
			m_bug.setRegistDate(new Date());
			m_bug.setIssuer(m_logonUser.getUno());
			m_bug.setStatus(Bug.STS_NEW);
			
			//
			m_bug.setDispatch();		//fBXpb`
			
		//͎Ҏw
		} else if (submitType.equals("analize")) {
			m_bug.setRegistDate(new Date());
			m_bug.setIssuer(m_logonUser.getUno());
			
			int analyst = Integer.parseInt(m_form.getRequestAnalyst());
			m_bug.setAnalyst(analyst);
			m_bug.setStatus(Bug.STS_INVESTIGATION);
			//
			m_bug.setDispatch();		//fBXpb`
			
		//mF
		} else if (submitType.equals("unconfirmed")) {
			m_bug.setRegistDate(new Date());
			m_bug.setStatus(Bug.STS_UNCONFIRMED);
			//
			m_bug.setDispatch();		//fBXpb`
			
		//\
		} else if (submitType.equals("same")) {
			//ȂɂȂ
			//
			m_bug.setDispatch();		//fBXpb`
			
		//Xe[^X󋵕ύX
		} else if (submitType.equals("statusWhitebord")) {
			m_bug.setStatusWhitebord(m_form.getRequestStatusWhitebord());
			//
			m_bug.setDispatch();		//fBXpb`
			
		} else {
			//ɂ͗Ȃ͂
			Assert.check(false, "invalid submitType type = " + submitType);
			
		}
	}
}
