//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.util.Converter;
import jp.gr.java_conf.bugslife.util.Assert;
/**
 *<PRE>
 * 
 * BugDetail2ActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class BugAssignAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Form
	 */
	BugAssignForm m_form;
	/**
	 * session
	 */
	HttpSession m_session;
	/**
	 * Bug
	 */
	Bug m_bug = null;
	/**
	 * Bug
	 */
	UserInfo m_logonUser;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
		
		ActionForward forward = null;
		/*
		 * 
		 */
		m_form = (BugAssignForm)form;	//form̎擾
		m_session = getSession(request);//sessio̎擾
		m_logonUser = (UserInfo)getAttribute(m_session,"UserInfo");	//OC[U̎擾
		m_bug = (Bug)m_session.getAttribute("bug");	//oO̎擾
		
		String action = m_form.getAction();
		//debug
		log.debug(	"action =" + action + 
					" bno = " + m_form.getBno() +
					" bno(s) = " + (m_bug == null ? "null" : ""+m_bug.getBno()));
		log.debug("ccRequest = " + m_form.getCcRequest());
		
		/*
		 * C
		 */
		//\̏ꍇ
		if (action.equals("show")){
			//=========================
			//bugCX^X̎擾
			//=========================
			if ((m_bug == null) || (m_bug.getBno() != m_form.getBno())) {
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̃Zbg
				m_session.setAttribute("bug", m_bug);
			}
			
			//͏Zbg
			PropertyUtils.copyProperties(m_form, m_bug);
			//bb̃Zbg
			m_session.setAttribute("ccs", m_bug.getCc());
			//show֑J
			forward = mapping.findForward("success");
			
		//submit̏ꍇ
		} else {
			//=========================
			//bugCX^X̎擾
			//=========================
			if ((m_bug == null) || (m_bug.getBno() != m_form.getBno())) {
				//xI
				log.warn("unmatch bno ");
				//oOCX^X̎擾
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̍ăZbg
				m_session.setAttribute("bug", m_bug);
			}
			//`FbN
			ActionErrors errors = m_form.validate(mapping, request);
			if (!errors.empty()) {
				 saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			//CCǉH
			if (m_form.getCcRequest().equals("add")) {
				//bb̒ǉ
				addCc();
				
				forward = mapping.findForward("success");
			//CC̍폜H
			} else if (m_form.getCcRequest().equals("del")) {
				//bb̍폜
				delCc();
				
				forward = mapping.findForward("success");
			//ύX̊m
			} else {
				
				//cc̃Zbg&XV
				Collection ccs = (Collection)m_session.getAttribute("ccs");
				m_bug.setCc(ccs);
				m_bug.updateCc(m_logonUser.getUno());
				
				/*-----------------------------------------------------
 				hbv_EłȂȂȂ߃RgAEg܂B
                                //====================
				//SҕύX
				//====================
				//擾Jn
				m_bug.startActivity();
				
				m_bug.setIssuer(m_form.getIssuer());
				m_bug.setAuther(m_form.getAuther());
				m_bug.setAnalyst(m_form.getAnalyst());
				m_bug.setUpdater(m_form.getUpdater());
				m_bug.setComfirmer(m_form.getComfirmer());
				
				//̎擾I
				m_bug.endActivity();
				
				//Ă
				Activitys act = m_bug.getActivitys();
				//̏o
				act.addActivity(m_logonUser);
				
				m_bug.update(m_logonUser.getUno());		//XV
				-------------------------------------------------------*/
				
				//܂ŗΐ
				m_form.setMessage("XV܂");
				
				//oOCX^X蒼
				m_bug = new Bug(m_form.getBno());
				//oOCX^X̃Zbg
				m_session.setAttribute("bug", m_bug);
				
				
				forward = mapping.findForward("success");
			}
			
		}
		// Forward control to the specified success URI
		return forward;
	}
	/**
	 * CC̒ǉ
	 */
	private void addCc() {
		
		String[] unos = m_form.getAddCcUno();
		Collection ccs = (Collection)m_session.getAttribute("ccs");
		
		for (int i = 0; i < unos.length; i++) {
			int uno = Integer.parseInt(unos[i]);
			//debug
			//log.debug("addCC["+i+"]"+unos[i]);
			
			//unovRNVɒǉȂ
			//߂̈v`FbN
			boolean match = false;
			Iterator ite = ccs.iterator();
			while(ite.hasNext()) {
				Cc cc = (Cc)ite.next();
				if (cc.getUno() == uno) {
					match = true;
					break;
				}
			}
			if (! match) {
				Cc cc = Cc.createCc(m_bug.getBno(), uno);
				ccs.add(cc);
			}
		}
		//formɎcꍇɔ]Ă܂̂ŁA
		m_form.setAddCcUno(null);
		
	}
	/**
	 * CC̍폜
	 */
	private void delCc() {
		
		String[] unos = m_form.getDelCcUno();
		Collection ccs = (Collection)m_session.getAttribute("ccs");
		Iterator ite = ccs.iterator();
		
		while(ite.hasNext()) {
			Cc cc = (Cc)ite.next();
			for (int i = 0; i < unos.length; i++) {
				//unovRNV폜
				if (cc.getUno() == Integer.parseInt(unos[i])) {
					ite.remove();
				}
			}
		}
		//formɎcꍇɔ]Ă܂̂ŁA
		m_form.setDelCcUno(null);
	}
}
