/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.DataSourceConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.util.RequestUtils;

public class ApplicationConfig
implements Serializable {
    protected HashMap actionConfigs = new HashMap();
    protected HashMap dataSources = new HashMap();
    protected HashMap exceptions = new HashMap();
    protected HashMap formBeans = new HashMap();
    protected HashMap forwards = new HashMap();
    protected HashMap messageResources = new HashMap();
    protected ArrayList plugIns = new ArrayList();
    protected boolean configured = false;
    protected ControllerConfig controllerConfig = null;
    protected String prefix = null;
    protected RequestProcessor processor = null;
    protected ActionServlet servlet = null;
    protected String actionMappingClass = "org.apache.struts.action.ActionMapping";

    public ApplicationConfig(String prefix, ActionServlet servlet) {
        this.prefix = prefix;
        this.servlet = servlet;
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public ControllerConfig getControllerConfig() {
        if (this.controllerConfig == null) {
            this.controllerConfig = new ControllerConfig();
        }
        return this.controllerConfig;
    }

    public void setControllerConfig(ControllerConfig cc) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.controllerConfig = cc;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public synchronized RequestProcessor getProcessor() throws ServletException {
        if (this.processor == null) {
            try {
                this.processor = (RequestProcessor)RequestUtils.applicationInstance(this.getControllerConfig().getProcessorClass());
                this.processor.init(this.servlet, this);
            }
            catch (Throwable t) {
                throw new UnavailableException("Cannot initialize RequestProcessor of class " + this.getControllerConfig().getProcessorClass() + ": " + t);
            }
        }
        return this.processor;
    }

    public ActionServlet getServlet() {
        return this.servlet;
    }

    public String getActionMappingClass() {
        return this.actionMappingClass;
    }

    public void setActionMappingClass(String actionMappingClass) {
        this.actionMappingClass = actionMappingClass;
    }

    public void addActionConfig(ActionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        config.setApplicationConfig(this);
        this.actionConfigs.put(config.getPath(), config);
    }

    public void addDataSourceConfig(DataSourceConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.put(config.getKey(), config);
    }

    public void addExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.put(config.getType(), config);
    }

    public void addFormBeanConfig(FormBeanConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.put(config.getName(), config);
    }

    public void addForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.put(config.getName(), config);
    }

    public void addMessageResourcesConfig(MessageResourcesConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.put(config.getKey(), config);
    }

    public void addPlugIn(PlugIn plugIn) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.plugIns.add(plugIn);
    }

    public ActionConfig findActionConfig(String path) {
        return (ActionConfig)this.actionConfigs.get(path);
    }

    public ActionConfig[] findActionConfigs() {
        ActionConfig[] results = new ActionConfig[this.actionConfigs.size()];
        return this.actionConfigs.values().toArray(results);
    }

    public DataSourceConfig findDataSourceConfig(String key) {
        return (DataSourceConfig)this.dataSources.get(key);
    }

    public DataSourceConfig[] findDataSourceConfigs() {
        DataSourceConfig[] results = new DataSourceConfig[this.dataSources.size()];
        return this.dataSources.values().toArray(results);
    }

    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    public FormBeanConfig findFormBeanConfig(String name) {
        return (FormBeanConfig)this.formBeans.get(name);
    }

    public FormBeanConfig[] findFormBeanConfigs() {
        FormBeanConfig[] results = new FormBeanConfig[this.formBeans.size()];
        return this.formBeans.values().toArray(results);
    }

    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    public MessageResourcesConfig findMessageResourcesConfig(String key) {
        return (MessageResourcesConfig)this.messageResources.get(key);
    }

    public MessageResourcesConfig[] findMessageResourcesConfigs() {
        MessageResourcesConfig[] results = new MessageResourcesConfig[this.messageResources.size()];
        return this.messageResources.values().toArray(results);
    }

    public PlugIn[] findPlugIns() {
        PlugIn[] results = new PlugIn[this.plugIns.size()];
        return this.plugIns.toArray(results);
    }

    public void freeze() {
        this.configured = true;
        ActionConfig[] aconfigs = this.findActionConfigs();
        int i = 0;
        while (i < aconfigs.length) {
            aconfigs[i].freeze();
            ++i;
        }
        this.getControllerConfig().freeze();
        DataSourceConfig[] dsconfigs = this.findDataSourceConfigs();
        int i2 = 0;
        while (i2 < dsconfigs.length) {
            dsconfigs[i2].freeze();
            ++i2;
        }
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        int i3 = 0;
        while (i3 < econfigs.length) {
            econfigs[i3].freeze();
            ++i3;
        }
        FormBeanConfig[] fbconfigs = this.findFormBeanConfigs();
        int i4 = 0;
        while (i4 < fbconfigs.length) {
            fbconfigs[i4].freeze();
            ++i4;
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        int i5 = 0;
        while (i5 < fconfigs.length) {
            fconfigs[i5].freeze();
            ++i5;
        }
        MessageResourcesConfig[] mrconfigs = this.findMessageResourcesConfigs();
        int i6 = 0;
        while (i6 < mrconfigs.length) {
            mrconfigs[i6].freeze();
            ++i6;
        }
    }

    public void removeActionConfig(ActionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        config.setApplicationConfig(null);
        this.actionConfigs.remove(config.getPath());
    }

    public void removeExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.remove(config.getType());
    }

    public void removeDataSourceConfig(DataSourceConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.dataSources.remove(config.getKey());
    }

    public void removeFormBeanConfig(FormBeanConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.formBeans.remove(config.getName());
    }

    public void removeForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.remove(config.getName());
    }

    public void removeMessageResourcesConfig(MessageResourcesConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.messageResources.remove(config.getKey());
    }
}

