/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class SetNextRule
extends Rule {
    protected String methodName = null;
    protected String paramType = null;

    public SetNextRule(Digester digester, String methodName) {
        this(digester, methodName, null);
    }

    public SetNextRule(Digester digester, String methodName, String paramType) {
        super(digester);
        this.methodName = methodName;
        this.paramType = paramType;
    }

    public void end() throws Exception {
        Object child = this.digester.peek(0);
        Object parent = this.digester.peek(1);
        if (this.digester.log.isDebugEnabled()) {
            if (parent == null) {
                this.digester.log.debug((Object)("[SetNextRule]{" + this.digester.match + "} Call [NULL PARENT]." + this.methodName + "(" + child + ")"));
            } else {
                this.digester.log.debug((Object)("[SetNextRule]{" + this.digester.match + "} Call " + parent.getClass().getName() + "." + this.methodName + "(" + child + ")"));
            }
        }
        Class[] paramTypes = new Class[]{this.paramType != null ? this.digester.getClassLoader().loadClass(this.paramType) : child.getClass()};
        MethodUtils.invokeExactMethod((Object)parent, (String)this.methodName, (Object[])new Object[]{child}, (Class[])paramTypes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SetNextRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramType=");
        sb.append(this.paramType);
        sb.append("]");
        return sb.toString();
    }
}

