/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class[] paramTypes = null;

    public CallMethodRule(Digester digester, String methodName, int paramCount) {
        this(digester, methodName, paramCount, (Class[])null);
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, String[] paramTypes) {
        super(digester);
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(paramTypes[i]);
                }
                catch (ClassNotFoundException e) {
                    this.paramTypes[i] = null;
                }
                ++i;
            }
        }
    }

    public CallMethodRule(Digester digester, String methodName, int paramCount, Class[] paramTypes) {
        super(digester);
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = "abc".getClass();
                ++i;
            }
        } else {
            this.paramTypes = new Class[paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                this.paramTypes[i] = paramTypes[i];
                ++i;
            }
        }
    }

    public void begin(Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            String[] parameters = new String[this.paramCount];
            int i = 0;
            while (i < parameters.length) {
                parameters[i] = null;
                ++i;
            }
            this.digester.pushParams(parameters);
        }
    }

    public void body(String bodyText) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = bodyText.trim();
        }
    }

    public void end() throws Exception {
        String[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (String[])this.digester.popParams();
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else {
            if (this.bodyText == null) {
                return;
            }
            parameters = new String[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[1];
                this.paramTypes[0] = "abc".getClass();
            }
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        int i = 0;
        while (i < this.paramTypes.length) {
            paramValues[i] = ConvertUtils.convert((String)parameters[i], (Class)this.paramTypes[i]);
            ++i;
        }
        Object top = this.digester.peek();
        if (this.digester.log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("[CallMethodRule]{");
            sb.append(this.digester.match);
            sb.append("} Call ");
            if (top == null) {
                sb.append("[NULL TOP]");
            } else {
                sb.append(top.getClass().getName());
            }
            sb.append(".");
            sb.append(this.methodName);
            sb.append("(");
            int i2 = 0;
            while (i2 < paramValues.length) {
                if (i2 > 0) {
                    sb.append(",");
                }
                if (paramValues[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(paramValues[i2].toString());
                }
                sb.append("/");
                if (this.paramTypes[i2] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.paramTypes[i2].getName());
                }
                ++i2;
            }
            sb.append(")");
            this.digester.log.debug((Object)sb.toString());
        }
        MethodUtils.invokeExactMethod((Object)top, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes);
    }

    public void finish() throws Exception {
        this.bodyText = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallMethodRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramCount=");
        sb.append(this.paramCount);
        sb.append(", paramTypes={");
        if (this.paramTypes != null) {
            int i = 0;
            while (i < this.paramTypes.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.paramTypes[i].getName());
                ++i;
            }
        }
        sb.append("}");
        sb.append("]");
        return sb.toString();
    }
}

