/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;

public abstract class TransformerFactory {
    private static final String defaultPropName = "javax.xml.transform.TransformerFactory";
    private static String foundFactory = null;
    private static boolean debug;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;

    static {
        try {
            debug = System.getProperty("jaxp.debug") != null;
        }
        catch (SecurityException securityException) {}
    }

    protected TransformerFactory() {
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static String findFactory(String factoryId, String defaultFactory) {
        block19: {
            block18: {
                try {
                    String systemProp = null;
                    try {
                        systemProp = System.getProperty(factoryId);
                    }
                    catch (SecurityException securityException) {}
                    if (systemProp != null) {
                        if (debug) {
                            System.err.println("JAXP: found system property" + systemProp);
                        }
                        return systemProp;
                    }
                }
                catch (SecurityException securityException) {}
                if (foundFactory != null) {
                    return foundFactory;
                }
                try {
                    String javah = System.getProperty("java.home");
                    String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
                    File f = new File(configFile);
                    if (f.exists()) {
                        Properties props = new Properties();
                        props.load(new FileInputStream(f));
                        foundFactory = props.getProperty(factoryId);
                        if (debug) {
                            System.err.println("JAXP: found java.home property " + foundFactory);
                        }
                        if (foundFactory != null) {
                            return foundFactory;
                        }
                    }
                }
                catch (Exception ex) {
                    if (!debug) break block18;
                    ex.printStackTrace();
                }
            }
            String serviceId = "META-INF/services/" + factoryId;
            try {
                ClassLoader cl = (class$javax$xml$transform$TransformerFactory != null ? class$javax$xml$transform$TransformerFactory : (class$javax$xml$transform$TransformerFactory = TransformerFactory.class$(defaultPropName))).getClassLoader();
                InputStream is = null;
                is = cl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : cl.getResourceAsStream(serviceId);
                if (is != null) {
                    if (debug) {
                        System.err.println("JAXP: found  " + serviceId);
                    }
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    foundFactory = rd.readLine();
                    rd.close();
                    if (debug) {
                        System.err.println("JAXP: loaded from services: " + foundFactory);
                    }
                    if (foundFactory != null && !"".equals(foundFactory)) {
                        return foundFactory;
                    }
                }
            }
            catch (Exception ex) {
                if (!debug) break block19;
                ex.printStackTrace();
            }
        }
        return defaultFactory;
    }

    public abstract Source getAssociatedStylesheet(Source var1, String var2, String var3, String var4) throws TransformerConfigurationException;

    public abstract Object getAttribute(String var1) throws IllegalArgumentException;

    public abstract ErrorListener getErrorListener();

    public abstract boolean getFeature(String var1);

    public abstract URIResolver getURIResolver();

    public static TransformerFactory newInstance() throws TransformerFactoryConfigurationError {
        TransformerFactory factoryImpl;
        String classname = TransformerFactory.findFactory(defaultPropName, "org.apache.xalan.processor.TransformerFactoryImpl");
        if (classname == null) {
            throw new TransformerFactoryConfigurationError("No default implementation found");
        }
        try {
            Class<?> clazz = Class.forName(classname);
            factoryImpl = (TransformerFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerFactoryConfigurationError(cnfe);
        }
        catch (IllegalAccessException iae) {
            throw new TransformerFactoryConfigurationError(iae);
        }
        catch (InstantiationException ie) {
            throw new TransformerFactoryConfigurationError(ie);
        }
        return factoryImpl;
    }

    public abstract Templates newTemplates(Source var1) throws TransformerConfigurationException;

    public abstract Transformer newTransformer() throws TransformerConfigurationException;

    public abstract Transformer newTransformer(Source var1) throws TransformerConfigurationException;

    public abstract void setAttribute(String var1, Object var2) throws IllegalArgumentException;

    public abstract void setErrorListener(ErrorListener var1) throws IllegalArgumentException;

    public abstract void setURIResolver(URIResolver var1);
}

