/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Code;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.ConstantValue;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Deprecated;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Exceptions;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.InnerClasses;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.LineNumberTable;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.LocalVariableTable;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.SourceDir;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.SourceFile;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Synthetic;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.Unknown;

public abstract class AttributeInfo {
    public static final String SOURCE_FILE = "SourceFile";
    public static final String CONSTANT_VALUE = "ConstantValue";
    public static final String CODE = "Code";
    public static final String EXCEPTIONS = "Exceptions";
    public static final String LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String LOCAL_VARIABLE_TABLE = "LocalVariableTable";
    public static final String INNER_CLASSES = "InnerClasses";
    public static final String SOURCE_DIR = "SourceDir";
    public static final String SYNTHETIC = "Synthetic";
    public static final String DEPRECATED = "Deprecated";
    public static final String UNKNOWN = "Unknown";
    protected int name_index;
    protected ConstantPool constantPool;

    protected AttributeInfo(int attr_index, ConstantPool pool) {
        this.name_index = attr_index;
        this.constantPool = pool;
    }

    protected void read(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        dis.skipBytes(len);
    }

    public String getName() {
        return Utils.getUTF8Value(this.constantPool, this.name_index);
    }

    public static AttributeInfo newAttribute(int attr_index, DataInputStream dis, ConstantPool pool) throws IOException {
        AttributeInfo attr = null;
        String name = Utils.getUTF8Value(pool, attr_index);
        attr = SOURCE_FILE.equals(name) ? new SourceFile(attr_index, pool) : (CONSTANT_VALUE.equals(name) ? new ConstantValue(attr_index, pool) : (CODE.equals(name) ? new Code(attr_index, pool) : (EXCEPTIONS.equals(name) ? new Exceptions(attr_index, pool) : (LINE_NUMBER_TABLE.equals(name) ? new LineNumberTable(attr_index, pool) : (LOCAL_VARIABLE_TABLE.equals(name) ? new LocalVariableTable(attr_index, pool) : (INNER_CLASSES.equals(name) ? new InnerClasses(attr_index, pool) : (SOURCE_DIR.equals(name) ? new SourceDir(attr_index, pool) : (SYNTHETIC.equals(name) ? new Synthetic(attr_index, pool) : (DEPRECATED.equals(name) ? new Deprecated(attr_index, pool) : new Unknown(attr_index, pool))))))))));
        ((AttributeInfo)attr).read(dis);
        return attr;
    }
}

