//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.selections;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.Locale;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import java.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.bug.*;
import jp.gr.java_conf.bugslife.form.*;
/**
 *<PRE>
 * 
 * SelectionSetNX
 * ʂɕ\hbv_EXgݒ肷NX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class SelectionSet
{
//===========================================================================
// attributes
//===========================================================================
    //Application scope(ServletContext)ɒu敪̑I
	public static final String APP_VERSIONS = "appVersions";
	public static final String BROWSERS = "browsers";
	public static final String DB_VERSIONS = "dbVersions";
	public static final String ERROR_CAUSES = "errorCauses";
	public static final String ERROR_DELAYREASONS = "errorDelayReasons";
	public static final String ERROR_POINTS = "errorPoints";
	public static final String ERROR_TYPES = "errorTypes";
	public static final String HTML_VERSIONS = "htmlVersions";
	public static final String SPEC_VERSIONS = "specVersions";
	public static final String LOCATIONS = "locations";
	public static final String MILESTONES = "milestones";
	public static final String OSS = "oss";
	public static final String PRIORITYS = "prioritys";
	public static final String PROCESS_NAMES = "processNames";
	public static final String RESOLUTIONS = "resolutions";
	public static final String SEVERITYS = "severitys";
	public static final String SUBSYSTEMS = "subsystems";
	public static final String SCREENS = "screens";
	public static final String FUNCTIONS = "functions";
	public static final String COMPONENTS = "components";
	public static final String STATUSES = "statuses";
	public static final String SYSCONF = "sysconf";				//Collectionł͂Ȃ
	public static final String[] ALL = {
	    	APP_VERSIONS,BROWSERS,DB_VERSIONS,ERROR_CAUSES,
	    	ERROR_DELAYREASONS,ERROR_POINTS,ERROR_TYPES,HTML_VERSIONS,SPEC_VERSIONS,
	    	LOCATIONS,MILESTONES,OSS,PRIORITYS,PROCESS_NAMES,
	    	RESOLUTIONS,SEVERITYS,SUBSYSTEMS,SCREENS,FUNCTIONS,COMPONENTS,
	    	STATUSES
	};
	
	//sessionɒu
	//OI[UɈႤ̂̓ZbVɒu
	public static final String DISPATCH_LIST = "dispatchList";
	public static final String LOGON_USER = "UserInfo";
	
	/**
	 * Log
	 */
	private static Log log = LogFactory.getLog(SelectionSet.class.getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * ׂĂ̋敪Zbg
	 */
	public static void setAll(ServletContext sc, UserInfo logonUser, boolean reset) {
	    
	    //敪Zbg
	    for (int i = 0; i < ALL.length; i++) {
	        setSelection(ALL[i], sc, reset);
	    }
	    
		//VXe퐔(sysconf)Zbg
		if (!reset) {
			Sysconf sysconf = (Sysconf)sc.getAttribute("sysconf");
			if (sysconf == null) {
				sysconf = Sysconf.getSysconf();
				sc.setAttribute("sysconf", sysconf);
			}
		} else {
		    Sysconf sysconf = Sysconf.getSysconf();
			sc.setAttribute("sysconf", sysconf);
		}
		
		
		setUserList(sc, reset);
	}
	/**
     * 敪̃Zbg
     */
    public static void setSelection(String key, ServletContext sc, boolean reset) {

        //ZbgłȂꍇ
		if (!reset) {
		    //łɑ݂Ă΁AȂɂȂ
			if (sc.getAttribute(key) != null) return;
		}
		
        Collection col = null;

		//ƃ_TB
        if (key.equals(APP_VERSIONS)) {
            col = AppVersion.getLabelCollection();
        }else if (key.equals(BROWSERS)) {
            col = Browser.getLabelCollection();
    	}else if (key.equals(DB_VERSIONS)) {
            col = DbVersion.getLabelCollection();
    	}else if (key.equals(ERROR_CAUSES)) {
            col = ErrorCause.getLabelCollection();
    	}else if (key.equals(ERROR_DELAYREASONS)) {
            col = ErrorDelayReason.getLabelCollection();
    	}else if (key.equals(ERROR_POINTS)) {
            col = ErrorPoint.getLabelCollection();
    	}else if (key.equals(ERROR_TYPES)) {
            col = ErrorType.getLabelCollection();
    	}else if (key.equals(HTML_VERSIONS)) {
            col = HtmlVersion.getLabelCollection();
    	}else if (key.equals(SPEC_VERSIONS)) {
            col = SpecVersion.getLabelCollection();
    	}else if (key.equals(LOCATIONS)) {
            col = Location.getLabelCollection();
    	}else if (key.equals(MILESTONES)) {
            col = Milestone.getLabelCollection();
    	}else if (key.equals(OSS)) {
            col = Os.getLabelCollection();
    	}else if (key.equals(PRIORITYS)) {
            col = Priority.getLabelCollection();
    	}else if (key.equals(PROCESS_NAMES)) {
            col = ProcessName.getLabelCollection();
    	}else if (key.equals(RESOLUTIONS)) {
            col = Resolution.getLabelCollection();
    	}else if (key.equals(SEVERITYS)) {
            col = Severity.getLabelCollection();
    	}else if (key.equals(SUBSYSTEMS)) {
            col = Subsystem.getLabelCollection();
    	}else if (key.equals(SCREENS)) {
            col = Screen.getLabelCollection();
    	}else if (key.equals(FUNCTIONS)) {
            col = FunctionName.getLabelCollection();
    	}else if (key.equals(COMPONENTS)) {
            col = ComponentName.getLabelCollection();
    	}else if (key.equals(STATUSES)) {
            col = Bug.getStatusCollection();
    	}
        
		sc.setAttribute(key, col);

    }

    /**
	 *VXe퐔(sysconf)Zbg
	 * 
	 * @param sc
	 * @param reset
	 */
    private static void setSysconf(ServletContext sc, boolean reset) {
	
        //Zbgł
        if (!reset) {
			Sysconf sysconf = (Sysconf)sc.getAttribute("sysconf");
			if (sysconf == null) {
				sysconf = Sysconf.getSysconf();
				sc.setAttribute("sysconf", sysconf);
			}
		} else {
		    Sysconf sysconf = Sysconf.getSysconf();
			sc.setAttribute("sysconf", sysconf);
		}
    }
	/**
	 * [UXg̃Zbg
	 * @param sc
	 * @param reset
	 */
    private static void setUserList(ServletContext sc, boolean reset) {
		
		Collection allUsers = new ArrayList();
		Collection allUsers2 = new ArrayList();
		Iterator ite = null;
		
		
        //ZbgłȂ
        if (!reset) {
            allUsers = (Collection)sc.getAttribute("allUsers");
            allUsers2 = (Collection)sc.getAttribute("allUsers2");
            //Ƃ݂Ă
            if ((allUsers != null) && (allUsers2 != null)) {
                return;		//ȂɂȂ
            }
        }
        
		allUsers = new ArrayList();
		allUsers2 = new ArrayList();
        Collection users = UserInfo.getAllUser();	//[U擾
                
        //Lȃ[UPł
        if (users != null) {
	
            //alluserZbg
            allUsers = users;					//[UZbg
	
			//allUser2Zbg
			allUsers2.add(new UserInfo());		//̃[UPԖڂɒǉ
			ite = users.iterator();
			while(ite.hasNext()) {
				allUsers2.add(ite.next());		//ȍ~[Uǉ
			}
        }
		sc.setAttribute("allUsers", allUsers);
		sc.setAttribute("allUsers2", allUsers2);
		
	}
    /**
	 *fBXpb`XgZbg
	 * 
	 * @param sc
	 * @param reset
	 */
    public static void setDispatchList(HttpSession session, UserInfo logonUser) {
	
        Collection dispatchList = DispatchList.getEnableDispatchList(logonUser.getUno());
        session.setAttribute(DISPATCH_LIST, dispatchList);    
	}
    /**
	 *OC[UZbg
	 * 
	 * @param sc
	 * @param reset
	 */
    public static void setLogonUser(HttpSession session, UserInfo logonUser) {
	
        session.setAttribute(LOGON_USER, logonUser);    
	}

}
