//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.selections;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;

// DB API
import jp.gr.java_conf.bugslife.db.*;

// Util API
import jp.gr.java_conf.bugslife.util.*;
//import jp.gr.java_conf.bugslife.system.*;


/**
 *<PRE>
 * 
 * ScreenNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Screen implements IUpdatable, ILoadable
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	ʂhc
	 */
	private String m_scid = null;
	/**
	 *	ʖ
	 */
	private String m_name = null;
	/**
	 *	\[X
	 */
	private String m_resource = null;
	/**
	 *	
	 */
	private String m_info = null;
	/**
	 *	XV
	 */
	private int m_updateUno = 0;
	/**
	 *	XV
	 */
	private Date m_updateDate = new Date();
//=====================================
// DBpڒ`
//=====================================
	/**
	 * r
	 */
	private static final boolean EXCLUSION = true;	//
	/**
	 * AutoIncrement
	 */
	private static final boolean ATOINCREMENT = false;	//Ȃ
	/**
	 * PK 
	 */
	private static final String[] PK = {"scid"};
	/**
	 * XVږ
	 */
	private static final String[] DB_ITEMS = {
									"scid","name","resource",
									"info","updateUno" };
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Screen()
	{
		
	}
	/**
	 *	RXgN^(hcwj
	 *
	 * @param	 scid		String^
	 */
	public Screen(String scid)
	{
		setScid(scid);
		
		load();
		
	}
//======================================
// db access methods
//======================================
	/**
	 *	insertDB
	 *
	 * @return	
	 */
	public void insert(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.insert(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	update
	 *
	 * @return	
	 */
	public void update(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.update(this);
		load();		//ŏIXVق̂ōă[h
	}
	/**
	 *	delete
	 *
	 * @return	
	 */
	public void delete(int updateUno)
	{
		setUpdateUno(updateUno);
		DAO.delete(this);
	}
	/**
	 *	load
	 *
	 * @return	
	 */
	public void load()
	{
		DAO.load(this);
	}
	/**
	 *	findAll
	 *
	 * @return	
	 */
	public static Collection findAll()
	{
		return DAO.findAll(new Screen());
	}
	/**
	 *	Screen̎擾iR[hwj
	 *
	 * @return	
	 */
	public static Screen getScreen(String scid)
	{
		String sql = "SELECT * FROM Screen WHERE scid = ?";
		ArrayList params = new ArrayList();
		params.add(scid);
		
		ArrayList list = DAO.find(new Screen(), sql, params);
		
		Screen Screen = null;
		if ((list != null) && (list.size() > 0)) {
			Screen = (Screen)list.get(0);
		}
		return Screen;
	}
	/**
	 * x\pRNV
	 */
	public static Collection getLabelCollection()
	{
		String sql = "SELECT scid,name FROM Screen ORDER BY scid";
		ArrayList params = new ArrayList();
		
		ArrayList list = DAO.find(new Screen(), sql, params);
		
		return list;
	}
//======================================
// Db Interface
//======================================
	/**
	 * 
	 */
	public String[] getUpdateItemNames() {
		
		return DB_ITEMS;
		
	}
	/**
	 * PK items
	 */
	 public String[] getPKItems() {
		return PK;
	}
	/**
	 * r䂠Ȃ
	 */
	public boolean isExclusion() {
		return EXCLUSION;
	}
	/**
	 * AutoIncrementȂ
	 */
	public boolean isAutoIncrement() {
		return ATOINCREMENT;
	}
//======================================
// request param
//======================================
	/**
	 *	request parametor̐
	 */
	public Map getMapping() {
		HashMap map = new HashMap();
		map.put("t", "Screen");
		map.put("scid", m_scid);
		return map;
	}
//======================================
// Property
//======================================
	/**
	 * ID̎擾
	 * 
	 * @return ID
	 */
	public String getScid()
	{
		return m_scid;
	}
	/**
	 * ID̃Zbg
	 * 
	 * @param scid ID
	 */
	public void setScid(String scid)
	{
		m_scid = scid;
	}
	/**
	 * O̎擾
	 * 
	 * @return O
	 */
	public String getName()
	{
		return m_name;
	}
	/**
	 * O̎擾(xp)
	 * 
	 * @return O
	 */
	public String getNameLabel()
	{
		String s = null;
		if ((m_scid == null) || (m_scid.equals(""))) {
			s = "";
		} else {
			s = m_scid + "-" + m_name;
		}
		return s;
	}
	/**
	 * ÕZbg
	 * 
	 * @param name O
	 */
	public void setName(String name)
	{
		m_name = name;
	}
	/**
	 * \[X̎擾
	 * 
	 * @return \[X
	 */
	public String getResource()
	{
		return m_resource;
	}
	/**
	 * \[X̃Zbg
	 * 
	 * @param resource \[X
	 */
	public void setResource(String resource)
	{
		m_resource = resource;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getInfo()
	{
		return m_info;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param info 
	 */
	public void setInfo(String info)
	{
		m_info = info;
	}
	/**
	 * XV҂̎擾
	 * 
	 * @return XV
	 */
	public int getUpdateUno()
	{
		return m_updateUno;
	}
	/**
	 * XV҂̃Zbg
	 * 
	 * @param updateUno XV
	 */
	public void setUpdateUno(int updateUno)
	{
		m_updateUno = updateUno;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public Date getUpdateDate()
	{
		return m_updateDate;
	}
	/**
	 *	XV̎擾
	 *
	 * @return	update		XV
	 */
	public String getUpdateDateString()
	{
		String s = null;
		if (m_updateDate != null) {
			s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(m_updateDate);
		}
		return s;
	}
	/**
	 *	XṼZbg
	 *
	 * @return	update		XV
	 */
	public void setUpdateDate(Date date)
	{
		m_updateDate = date;
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [Screen] --- \n");
		sb.append("scid     : " + m_scid + "\n");
		sb.append("name     : " + m_name + "\n");
		sb.append("resource : " + m_resource + "\n");
		sb.append("info     : " + m_info + "\n");
		sb.append("updateUno: " + m_updateUno + "\n");
		sb.append("updateDat: " + getUpdateDateString() + "\n");
		sb.append("--- [Screen] --- \n");
		return sb.toString();
	}
	/**
	 * debug
	 */
	private static void debug(String s) {
		 
		 System.out.println("[Screen]" + s);
		 
	}
	/**
	 *	eXgC
	 */
	public static void main(String[] args)
	{
		System.out.println("------- << Screen Test Start >> -----------");
		unitTest1();	//VK쐬eXg
		unitTest2();	//XVeXg
		unitTest3();	//폜eXg
		unitTest4();	//S擾eXg
		unitTest5();	//R[hwRXgNgeXg
		unitTest6();	//xpRNVeXg
		
		System.out.println("------- << Screen Test End >> -----------");
	}
	
	/**
	 *	unitTest1
	 *
	 * VK쐬eXg
	 *
	 */
	public static void unitTest1()
	{
		System.out.println("------- unitTest1 -----------");
		
		//݃`FbN
		Screen target = Screen.getScreen("NOF_AXXDXX");
		if (target != null) {
			//݂Ă폜
			target.delete(1);
		}
		//l̃Zbg
		Screen screen = new Screen();
		screen.setScid("NOF_AXXDXX");
		screen.setName("O");
		screen.setResource("");
		screen.setInfo("");
		
		//ǉ
		screen.insert(0);
		
		System.out.println(screen.toString());
	}
	/**
	 *	unitTest2
	 *
	 * XVeXg
	 *
	 */
	public static void unitTest2()
	{
		System.out.println("------- unitTest2 -----------");
		
		//݃`FbN
		Screen screen = Screen.getScreen("NOF_AXXDXX");
		if (screen == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(screen.toString());
		
		screen.setName("OQ");
		screen.setResource("̂Q");
		screen.setInfo("Q");
		//XV
		screen.update(1);
		
		System.out.println(screen.toString());
	}
	/**
	 *	unitTest3
	 *
	 * 폜eXg
	 *
	 */
	public static void unitTest3()
	{
		System.out.println("------- unitTest3 -----------");
		
		//݃`FbN
		Screen screen = Screen.getScreen("NOF_AXXDXX");
		if (screen == null) {
			//݂ĂȂeXg~
			throw new Error("target is nothing");
		}
		
		System.out.println(screen.toString());
		
		//폜
		screen.delete(2);
		
		//݃`FbN
		screen = Screen.getScreen("NOF_AXXDXX");
		if (screen != null) {
			//݂ĂȂeXg~
			throw new Error("delete failer");
		}
	}
	/**
	 *	unitTest4
	 *
	 * S擾eXg
	 *
	 */
	public static void unitTest4()
	{
		System.out.println("------- unitTest4 -----------");
		
		Collection list = Screen.findAll();
		display(list);
	}
	/**
	 *	unitTest5
	 *
	 * R[hRXgNgeXg
	 *
	 */
	public static void unitTest5()
	{
		System.out.println("------- unitTest5 -----------");
		
		Screen Screen = new Screen("NOF_A01D01");
		
		System.out.println(Screen.toString());
	}
	/**
	 *	unitTest6
	 *
	 * xpRNV̎擾
	 *
	 */
	public static void unitTest6()
	{
		System.out.println("------- unitTest6 -----------");
		
		display(Screen.getLabelCollection());
		
	}
	/**
	 * Xg̕\
	 *
	 */
	private static void display(Collection list)
	{
		Iterator ite = list.iterator();
		
		while(ite.hasNext()) {
			Screen Screen = (Screen)ite.next();
			
			System.out.println(Screen.getNameLabel());
		}
	}
}