//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.form;

//===========================================================================
// import
//===========================================================================
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.upload.MultipartRequestHandler;
import org.apache.commons.logging.*;

import java.io.UnsupportedEncodingException;

import java.util.*;
import java.text.*;

import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.bug.*;

/**
 *<PRE>
 * FormNX
 *
 *</PRE>
 * @author k@
 * @version 1.0.0
 */
public class BugAttachmentForm extends ActionForm {
//===========================================================================
// attributes
//===========================================================================
	/**
	 * ANV
	 */
	private String m_action;
	/**
	 * t@Cԍ
	 */
	private int m_ano;
	/**
	 * ̏ԍ
	 */
	private int m_bno;
	/**
	 * t@C^Cv
	 */
	private String m_fileType;
	/**
	 * MIME^Cv
	 */
	private String m_mimeType;
	/**
	 * 
	 */
	private String m_info;
	/**
	 * t@C
	 */
	private FormFile m_file;
	/**
	 * ʃbZ[Wkey
	 */
	private String m_messageKey;
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// other attribute
//===========================================================================
	private static final String DEFAULT_FILETYPE = "8";		//binary
//===========================================================================
// methods
//===========================================================================
	/**
	 * ANV̎擾
	 * 
	 * @return ANV
	 */
	public String getAction()
	{
		return m_action;
	}
	/**
	 * ANṼZbg
	 * 
	 * @param action ANV
	 */
	public void setAction(String action)
	{
		m_action = action;
	}
	/**
	 * t@Cԍ̎擾
	 * 
	 * @return t@Cԍ
	 */
	public int getAno()
	{
		return m_ano;
	}
	/**
	 * t@Cԍ̃Zbg
	 * 
	 * @param ano t@Cԍ
	 */
	public void setAno(int ano)
	{
		m_ano = ano;
	}
	/**
	 * ̏ԍ̎擾
	 * 
	 * @return ̏ԍ
	 */
	public int getBno()
	{
		return m_bno;
	}
	/**
	 * ̏ԍ̃Zbg
	 * 
	 * @param bno ̏ԍ
	 */
	public void setBno(int bno)
	{
		m_bno = bno;
	}
	/**
	 * t@C^Cv̎擾
	 * 
	 * @return t@C^Cv
	 */
	public String getFileType()
	{
		return m_fileType;
	}
	/**
	 * t@C^CṽZbg
	 * 
	 * @param fileType t@C^Cv
	 */
	public void setFileType(String fileType)
	{
		m_fileType = fileType;
	}
	/**
	 * MIME^Cv̎擾
	 * 
	 * @return MIME^Cv
	 */
	public String getMimeType()
	{
		return m_mimeType;
	}
	/**
	 * MIME^CṽZbg
	 * 
	 * @param mimeType MIME^Cv
	 */
	public void setMimeType(String mimeType)
	{
		m_mimeType = mimeType;
	}
	/**
	 * ̎擾
	 * 
	 * @return 
	 */
	public String getInfo()
	{
		return m_info;
	}
	/**
	 * ̃Zbg
	 * 
	 * @param info 
	 */
	public void setInfo(String info)
	{
		m_info = Converter.getEncodingString(info);
	}
	/**
	 * t@C̎擾
	 * 
	 * @return t@C
	 */
	public FormFile getFile()
	{
		return m_file;
	}
	/**
	 * t@C̃Zbg
	 * 
	 * @param file t@C
	 */
	public void setFile(FormFile file)
	{
		m_file = file;
	}
	/**
	 * ʃbZ[Wkey̎擾
	 * 
	 * @return ʃbZ[Wkey
	 */
	public String getMessageKey()
	{
		return m_messageKey;
	}
	/**
	 * ʃbZ[W̎擾
	 * 
	 * @return ʃbZ[W
	 */
	public String getMessage()
	{
		if (m_messageKey == null) {
			return "";
		} else {
			return Varidater.getMessage(m_messageKey);
		}
	}
	/**
	 * ʃbZ[WkeỹZbg
	 * 
	 * @param messageKey ʃbZ[Wkey
	 */
	public void setMessageKey(String messageKey)
	{
		m_messageKey = messageKey;
	}
//===========================================================================
// Public Methods
//===========================================================================
	/**
	* Zbg
	*
	* @param mapping The mapping used to select this instance
	* @param request The servlet request we are processing
	*/
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		
		//debug
		log.debug("reset");
		//encodeing Zbg
		try {
			request.setCharacterEncoding("SJIS");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		
		m_action = null;
		m_ano = 0;
		m_bno = 0;
		m_fileType = DEFAULT_FILETYPE;
		m_mimeType = null;
		m_info = null;
		m_file = null;
		m_messageKey = null;
	}
	/**
	* ľ(Validate) 
	*
	* @param mapping The mapping used to select this instance
	* @param request The servlet request we are processing
	*/
	public ActionErrors validate(ActionMapping mapping,
								 HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		
		log.debug("validate");
		log.debug("filetype = " + m_fileType + " info = " + m_info);
		
		
		
		
		//action
		Varidater.checkRequired(m_action, "action", errors);
		
		//filetype
		if (Varidater.checkRequired(m_fileType, "fileType", errors)) {
			byte type = Byte.parseByte(m_fileType);
			if (type == Attachment.TYPE_OTHER) {
				//mimeType
				Varidater.checkRequired(m_mimeType, "mimeType", errors);
			}
		}
		//info
		Varidater.checkRequired(m_info, "info", errors);
		//file
		if(Varidater.checkRequired(m_file, "file", errors)) {
			if (m_file.getFileSize() == 0) {
				Varidater.addErrors("error.zeroByteFile", "file", errors);
			} else if (m_file.getFileSize() > Attachment.MAX_SIZE) {
				Varidater.addErrors("error.sizeOrverFile", "file", errors);
			}
		}
		//has the maximum length been exceeded?
/*--------------------------------
		Boolean maxLengthExceeded = (Boolean)
			request.getAttribute(MultipartRequestHandler.ATTRIBUTE_MAX_LENGTH_EXCEEDED);
		if ((maxLengthExceeded != null) && (maxLengthExceeded.booleanValue())) {
			errors.add(ERROR_PROPERTY_MAX_LENGTH_EXCEEDED, new ActionError("maxLengthExceeded"));
		}
--------------------------------*/
		return errors;
	}
}