//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.bug;

//===========================================================================
// import
//===========================================================================
// Java core API
import java.util.*;
import java.text.*;
import org.apache.commons.logging.*;
import javax.servlet.http.*;

// API
import jp.gr.java_conf.bugslife.db.*;
import jp.gr.java_conf.bugslife.user.*;
import jp.gr.java_conf.bugslife.util.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.system.*;

/**
 *<PRE>
 * 
 * ActivitysNX
 * 
 * ActivityCollecitonNX
 * 
 *</PRE>
 * @version	0.0, 2001/09/10
 * @author	k@
 */
//===========================================================================
public class Activitys
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 *	bug
	 */
	private Bug m_bug;
	/**
	 *	to
	 */
	private UserInfo m_to;
	/**
	 *	cc
	 */
	private Map m_cc = new HashMap();
	/**
	 *	AddText
	 */
	private String m_addText;
	/**
	 *	Activity
	 */
	private Map m_activitys = new HashMap();
	/**
	 *	MailElement
	 */
	private MailElements m_mail;
	
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 *	ftHgRXgN^
	 *
	 */
	public Activitys()
	{
		m_activitys.clear();
		m_mail = new MailElements();
		m_cc.clear();
	}
//======================================
// Property
//======================================
	/**
	 * Activity̒ǉ
	 * 
	 * @param activity ANeBreB
	 */
	public void add(Activity activity) {
		
		if (m_activitys.containsKey(activity.getId())) {
			//debug
			log.debug("duprecate key = " + activity.getId());
		}
		m_activitys.put(activity.getId(), activity);
	}
	/**
	 * elements̎擾
	 */
	public MailElements getMailElements() {
		return m_mail;
	}
	/**
	 * Bug̃Zbg
	 * 
	 * @param Bug bug
	 */
	public void setBug(Bug bug)
	{
		m_bug = bug;
	}
	/**
	 * TõZbg
	 * 
	 * @param to to
	 */
	public void setTo(UserInfo to)
	{
		m_to = to;
	}
	/**
	 * cc̒ǉ
	 * 
	 * @param cc cc
	 */
/*-------------------------------------------
	public void addCc(Collection cc)
	{
		m_cc.addAll(cc);
	}
-------------------------------------------*/
	/**
	 * ǉeLXg̃Zbg
	 * 
	 * @param addText ǉeLXg
	 */
	public void setAddText(String addText)
	{
		m_addText = addText;
	}
	/**
	 * [̑M
	 * 
	 * @param to to
	 */
	public void sendMail(UserInfo logonUser, HttpServletRequest request) {
		
	    
		Sysconf sysconf = Sysconf.getSysconf();
		//add 2007.10.22
		//[MȂꍇÂ܂܃^[
		if(sysconf.getDisableMail() == Sysconf.DISABLE_MAIL){
		    return;
		}
		
		// smtp host
		m_mail.setSmtphost(sysconf.getSmtpAdress());
		
		// FROM
		m_mail.setFrom(sysconf.getFromAdress());
		
		//messageId
		m_mail.setMessageId(m_bug.getMessageId());
		
		//subject
		StringBuffer subject = new StringBuffer();
		ProcessName pName = ProcessName.getProcessName(sysconf.getCurrentPno());
		subject.append("[" + pName.getShortName());
		//add wani 03/01/05
		//wb_ɃTuVXe
		Subsystem ss = new Subsystem(m_bug.getSubsystem());
		subject.append(ss.getShortName());
		
		subject.append("̏#" + m_bug.getBnoString() + "]");		//[̏#0001]
		subject.append("y" + m_bug.getInputTypeString() + "z");	//y̏z
		subject.append(m_bug.getDispatchName() + " ");				//k(hoge)
		subject.append(m_bug.getTitle());							//wwwł܂
		m_mail.setSubject(subject.toString());
		
		//{
		StringBuffer content = new StringBuffer();
		
		//
//		content.append("\n");
		content.append("̌̏");
		content.append(logonUser.getNickname());
		content.append("ɂ");
		if (m_bug.getInputType() == Bug.ITYPE_DETAIL0) {
			content.append("s܂B\n");
		} else {
			if (m_bug.getStatus() == Bug.STS_CLOSE) {
				content.append("܂B\n");
			} else {
				content.append("XV܂B\n");
			}
		}
		if (m_bug.getStatus() != Bug.STS_CLOSE) {
			//fBXpb`斢
			content.append("fBXpb`");
			if (m_bug.getDispatch() == 0) {	//
				content.append("ł\n");
			} else {
				content.append(m_bug.getDispatchName() + "ł\n");
			}
		}
		//wb_
		content.append("\n");
		content.append("[ԍ]" + m_bug.getBnoString() + "\n");
		content.append("[\]" + m_bug.getTitle() + "\n");
		content.append("[]" + m_bug.getStatusString() + "\n");
		
		//ǉeLXg͂H
		if (m_bug.isAddTextEnable()) {
/*---------------------------------------
			content.append("\n");
			
			AddText text = m_bug.getLastAddText();
			content.append("[" + text.getTextTypeString() + "]");		//[VK]
			content.append(text.getEntryUname());						//k(XXX)
			content.append("(" + text.getEntryDateString() + ")\n");	//mm/dd hh:mm
			content.append("\n");
---------------------------------------*/
			AddText text = m_bug.getLastAddText();
			content.append("[" + text.getTextTypeString() + "]");		//[VK]
			content.append("\n");
			content.append(text.getContent());							//e
			content.append("\n");
		}
		content.append("\n");
		content.append("---------ύXe------------\n");
		if((m_activitys != null) && (m_activitys.size() > 0)){
			//[o͍ڂActivityo͂
			//[nnn ]xxxx̌`B
			//[]̒sɂȂƌÂ炢̂ŁAnnn̍ő咷
			//CfgȂlo͂B
			
			//o͍ږ̍ő咷߂
			int maxLen = 0;
			int nameLen = 0;
			for (int i = 0; i < BugItem.MAIL_ITEM_SEQ.length; i++) {
				if (m_activitys.containsKey(BugItem.MAIL_ITEM_SEQ[i])) {
					Activity act = (Activity)m_activitys.get(BugItem.MAIL_ITEM_SEQ[i]);
					nameLen = act.getName().getBytes().length;		//oCgŐ
					maxLen = (maxLen < nameLen ? nameLen : maxLen);
				}
			}
			//tH[}bgȂ獀ڂo͂
			for (int i = 0; i < BugItem.MAIL_ITEM_SEQ.length; i++) {
				if (m_activitys.containsKey(BugItem.MAIL_ITEM_SEQ[i])) {
					Activity act = (Activity)m_activitys.get(BugItem.MAIL_ITEM_SEQ[i]);
					content.append("[" + 
									act.getName() + 
									//ږ
									Converter.space(maxLen-act.getName().getBytes().length) + 
									"]");
					content.append(act.toStringForMail() + "\n");
				}
			}
		}
		content.append("\n");
		
		//[̃OCpURL𐶐B
		
		String baseURL = request.getScheme() + 
						"://" + request.getServerName() + 
						":" + 
						request.getServerPort() + 
						request.getContextPath();
		
		content.append("URL:");
		content.append(baseURL + "/logon.do?bno=" + m_bug.getBno() + "\n");
		content.append("\n");
		
		//[̈
		setMailAdress(logonUser, content);
		
		content.append("\n");
		content.append("---\n");
		content.append(m_mail.getFrom());
		
		m_mail.setBody(content.toString());
		
		/**
		 *[̑M
		*/
		try {
			MailSender.send(m_mail);
			
		} catch (Exception e) {
			log.error("mail send error", e);
		}
		
		m_bug.setMessageId(m_mail.getMessageId());
	}
	/**
	 * [AhX̐
	 */
	private void setMailAdress(UserInfo logonUser, StringBuffer content) {
		
		
		//[IuWFNgփZbg
		
		//----------------------------
		// from̐
		//----------------------------
		//emailɂ̓ZbgȂ
		content.append("from:" + logonUser.getNickname() + "\n");	//{
		
		//----------------------------
		// to̐
		//----------------------------
		m_to = m_bug.getDispatchUser();		//SҎ擾
		if (m_to != null) {
			m_mail.addTo(m_to);
			content.append("to  :" + m_to.getNickname() + "\n");	//{
		}
		
		//----------------------------
		// cc̐
		//----------------------------
		//fromccɉ
		m_cc.put(logonUser.getEmail(), logonUser);
		
		//bug̎ĂCCǉ
		Collection ccs = m_bug.getCc();
		if (ccs != null) {
			Iterator ite = ccs.iterator();
			while(ite.hasNext()){
				Cc cc = (Cc)ite.next();
				UserInfo user = UserInfo.getUser(cc.getUno());
				m_cc.put(user.getEmail(), user);
			}
		}
		//֌W҂CCɉ
		//s
		if (m_bug.getIssuer() != 0) {
			UserInfo user = UserInfo.getUser(m_bug.getIssuer());
			m_cc.put(user.getEmail(), user);
		}
		//F
		if (m_bug.getAuther() != 0) {
			UserInfo user = UserInfo.getUser(m_bug.getAuther());
			m_cc.put(user.getEmail(), user);
		}
		//͎
		if (m_bug.getAnalyst() != 0) {
			UserInfo user = UserInfo.getUser(m_bug.getAnalyst());
			m_cc.put(user.getEmail(), user);
		}
		//C
		if (m_bug.getUpdater() != 0) {
			UserInfo user = UserInfo.getUser(m_bug.getUpdater());
			m_cc.put(user.getEmail(), user);
		}
		//mF
		if (m_bug.getComfirmer() != 0) {
			UserInfo user = UserInfo.getUser(m_bug.getComfirmer());
			m_cc.put(user.getEmail(), user);
		}
		
		//̃[^CvwǂĂlCCɒǉ
		Collection ccUsers = null;
		switch(m_bug.getInputType()) {
		case Bug.ITYPE_DETAIL0 :		//s
			ccUsers = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL0);
			break;
		case Bug.ITYPE_DETAIL1 :		//̏
			ccUsers = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL1);
			break;
		case Bug.ITYPE_DETAIL2 :		//j
			ccUsers = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL2);
			break;
		case Bug.ITYPE_DETAIL3 :		//
			ccUsers = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL3);
			break;
		case Bug.ITYPE_DETAIL4 :		//u
			ccUsers = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL4);
			break;
		case Bug.ITYPE_DETAIL5 :		//mF
			ccUsers = UserInfo.getUserForMailType(UserInfo.MAIL_DETAIL5);
			break;
		}
		
		if (ccUsers != null) {
			Iterator ite = ccUsers.iterator();
			while(ite.hasNext()){
				UserInfo user = (UserInfo)ite.next();
				m_cc.put(user.getEmail(), user);
			}
		}
		//toɓĂlcc폜
		if (m_to != null) {
			m_cc.remove(m_to.getEmail());		//to
		}
		
		//CC̃Zbg
		Iterator ite2 = m_cc.keySet().iterator();
		int i = 0;
		while(ite2.hasNext()){
			String email = (String)ite2.next();
			UserInfo user = (UserInfo)m_cc.get(email);
			
			m_mail.addCc(user);				//[ɒǉ
			
			//CC̓e
			if (i == 0) {
				content.append("cc  :");
			} else if( (i % 3) == 0) {
				content.append("\n     ");
			} else {
				content.append(", ");
			}
			content.append(user.getNickname());
			i++;
			
		}
		
	}
	/**
	 * ̒ǉ
	 * 
	 * @param to to
	 */
	public void addActivity(UserInfo logonUser) {
		
		//邩H
		if (m_activitys.size() != 0) {
			ArrayList list = new ArrayList();
			//擾ڃXgƏƂ炵킹ȂRNVĂ
			for (int i = 0; i < BugItem.MAIL_ITEM_SEQ.length; i++) {
				//H
				if (m_activitys.containsKey(BugItem.MAIL_ITEM_SEQ[i])) {
					Activity act = (Activity)m_activitys.get(BugItem.MAIL_ITEM_SEQ[i]);
/*-------------------------
					//
					//̏ꍇ́AÂlΗ擾ȂB
					//[̏ꍇWebɌ̂ŁAlĂȂĂo
					//̏ꍇ͕ςƂ낵Ȃ̂ŁA{̍̂ݏo
					//AVlɂȂiwjꍇ͗Ƃ
					//ĉƂB
					if (act.getOldValueString().length() != 0) {
-------------------------*/
						//ǉ
						list.add(act);
/*-------------------------
					}
-------------------------*/
				}
			}
			//o
			BugActivity.addBugActivity(list, m_bug.getBno(), logonUser.getUno());
		}
		
	}
//===========================================================================
// methods
//===========================================================================
	/**
	 *	NX
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("--- [ACTIVITYS] --- \n");
		if((m_activitys != null) && (m_activitys.size() > 0)){
			Collection values = m_activitys.values();
			Iterator ite = values.iterator();
			while(ite.hasNext()) {
				Activity act = (Activity)ite.next();
				sb.append(act.toStringForMail() + "\n");
			}
		} else {
			sb.append("no activity\n");
		}
		sb.append("--- [ACTIVITYS] --- \n");
		return sb.toString();
	}
}