//===========================================================================
// package
//===========================================================================
package jp.gr.java_conf.bugslife.action;

//===========================================================================
// import
//===========================================================================
import java.io.IOException;
import java.util.*;

import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
import org.apache.commons.beanutils.*;

import jp.gr.java_conf.bugslife.form.*;
import jp.gr.java_conf.bugslife.selections.*;
import jp.gr.java_conf.bugslife.user.*;
/**
 *<PRE>
 * 
 * LogonActionNX
 *
 *</PRE>
 * @version	0.0
 * @author	k 
 */
public final class LogonAction extends BaseAction 
{
//===========================================================================
// attributes
//===========================================================================
	/**
	 * Log
	 */
	private Log log = LogFactory.getLog(this.getClass().getName());
//===========================================================================
// methods
//===========================================================================
	/**
	 * exevute
	 *
	 * @param mapping The ActionMapping used to select this instance
	 * @param actionForm The optional ActionForm bean for this request (if any)
	 * @param request The HTTP request we are processing
	 * @param response The HTTP response we are creating
	 *
	 * @exception Exception if business logic throws an exception
	 */
	public ActionForward doAction(ActionMapping mapping,
				 ActionForm form,
				 HttpServletRequest request,
				 HttpServletResponse response)
				throws Exception {
	
		// Extract attributes we will need
		Locale locale = getLocale(request);
		MessageResources messages = getResources(request);
		
		ActionForward forward = null;
		
		//form̎擾
		LogonForm myForm = (LogonForm)form;
		//sessio̎擾
		
		String action = myForm.getAction();
		//debug
		log.debug("action = " + action);
		log.debug("bno = " + myForm.getBno());
		
		//\
		if ((action == null) || (action.equals("show"))) {
			
			forward = mapping.findForward("init");
			
		//OI
		} else {
			//`FbN
			ActionErrors errors = myForm.validate(mapping, request);
			if (!errors.empty()) {
				 saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			String username = myForm.getUserName();
			String password = myForm.getPassword();
			
			UserInfo userInfo = UserInfo.findUid(username);
			
			/*-------------------------------
			//debug
			log.debug("userInfo get " + userInfo);
			-------------------------------*/
			//AJEg͂H
			if (userInfo == null) {
				errors.add("username", new ActionError("error.username.invalid"));
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			//OC\H
			if (!userInfo.checkEnableLogin()) {
				errors.add("username", new ActionError("error.user.notlogin"));
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			//pX[hH
			if (! password.equals(userInfo.getPassword())) {
				errors.add("password", new ActionError("error.password.unmatch"));
				saveErrors(request, errors);
				return (new ActionForward(mapping.getInput()));
			}
			
			//-------------------------
			//񃍃OC̏
			//------------------------
			HttpSession session = request.getSession(false);
			//ɃZbV邩H
			if (session != null) {
				//̃ZbV͔j
				session.invalidate();
			}
			session = request.getSession(true);		//

			
			
			//fBXpb`Xgł΁AɃfBXpb`o悤ɒǉB
		    Collection dispatchList = DispatchList.getEnableDispatchList(userInfo.getUno());
		    if (dispatchList == null) {				//fBXpb`XgPȂꍇ
		        DispatchList dl = new DispatchList();
		        dl.setUno(userInfo.getUno());
		        dl.setDispatchUno(userInfo.getUno());
		        dl.insert(userInfo.getUno());
		    }
			
			//session.setAttribute("UserInfo", userInfo);
		    
		    //OI[UZbVɃZbg
		    SelectionSet.setLogonUser(session, userInfo);
		    //fBXpb`ZbVɃZbg
		    SelectionSet.setDispatchList(session, userInfo);
		    
		    
			//e敪Xg̐ݒ
		    //{Ȃ珉ɍsׂAł́ANOC^C~O
		    //sĂ
			SelectionSet.setAll(session.getServletContext(), userInfo, false);
			

			//ʑJ
			//[̃OȈꍇASʕ\֍s
			int bno = myForm.getBno();
			//bnoȂiʏ̃OIj
			if (bno == 0) {
				forward = mapping.findForward("success");
			//bnoi[̃OIj
			} else {
				forward = new ActionForward("/showAll.do?action=show&bno=" + bno);
			}
			
		}
		// Forward control to the specified success URI
		return forward;
	}
}
