/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class GenericValidator
implements Serializable {
    public static boolean isBlankOrNull(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean matchRegexp(String string, String string2) throws RESyntaxException {
        if (string2 != null && string2.length() > 0) {
            RE rE = new RE(string2);
            return rE.match(string);
        }
        return false;
    }

    public static boolean isByte(String string) {
        try {
            Byte.parseByte(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isShort(String string) {
        try {
            Short.parseShort(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isInt(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String string) {
        try {
            Long.parseLong(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isFloat(String string) {
        try {
            Float.parseFloat(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isDate(String string, Locale locale) {
        boolean bl = true;
        if (string != null) {
            try {
                DateFormat dateFormat = null;
                dateFormat = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
                dateFormat.setLenient(false);
                Date date = dateFormat.parse(string);
            }
            catch (ParseException parseException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isDate(String string, String string2, boolean bl) {
        boolean bl2 = true;
        if (string != null && string2 != null && string2.length() > 0) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                if (bl && string2.length() != string.length()) {
                    bl2 = false;
                }
            }
            catch (ParseException parseException) {
                bl2 = false;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public static boolean isCreditCard(String string) {
        return GenericValidator.validateCreditCardLuhnCheck(string) && GenericValidator.validateCreditCardPrefixCheck(string);
    }

    protected static boolean validateCreditCardLuhnCheck(String string) {
        int n = string.length();
        int n2 = n & 1;
        long l = 0L;
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            try {
                n4 = Integer.parseInt(String.valueOf(string.charAt(n3)));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if ((n3 & 1 ^ n2) == 0 && (n4 *= 2) > 9) {
                n4 -= 9;
            }
            l += (long)n4;
            ++n3;
        }
        if (l == 0L) {
            return false;
        }
        return l % 10L == 0L;
    }

    protected static boolean validateCreditCardPrefixCheck(String string) {
        int n = string.length();
        if (n < 13) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        String string2 = string.substring(0, 2) + ",";
        if ("34,37,".indexOf(string2) != -1) {
            n2 = 3;
        }
        if (string.substring(0, 1).equals("4")) {
            n2 = 4;
        }
        if ("51,52,53,54,55,".indexOf(string2) != -1) {
            n2 = 5;
        }
        if (string.substring(0, 4).equals("6011")) {
            n2 = 6;
        }
        if (n2 == 3 && n == 15) {
            bl = true;
        }
        if (n2 == 4 && (n == 13 || n == 16)) {
            bl = true;
        }
        if (n2 == 5 && n == 16) {
            bl = true;
        }
        if (n2 == 6 && n == 16) {
            bl = true;
        }
        return bl;
    }

    public static boolean isEmail(String string) {
        boolean bl;
        block20: {
            bl = true;
            try {
                String string2;
                RE rE = new RE("^(.+)@(.+)$");
                String string3 = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
                String string4 = "[^\\s" + string3 + "]";
                String string5 = "(\"[^\"]*\")";
                RE rE2 = new RE("^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$");
                String string6 = string4 + '+';
                String string7 = "(" + string6 + "|" + string5 + ")";
                RE rE3 = new RE("^" + string7 + "(\\." + string7 + ")*$");
                RE rE4 = new RE("^" + string6 + "(\\." + string6 + ")*$");
                boolean bl2 = rE.match(string);
                if (!bl2) {
                    bl = false;
                }
                if (bl) {
                    if (bl2) {
                        string2 = rE.getParen(1);
                        if (!rE3.match(string2)) {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                string2 = rE.getParen(2);
                if (!bl) break block20;
                if (rE2.match(string2)) {
                    int n = 1;
                    while (n <= 4) {
                        String string8 = rE2.getParen(n);
                        if (string8 != null && string8.length() > 0) {
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(string8);
                            }
                            catch (Exception exception) {
                                bl = false;
                            }
                            if (n2 > 255) {
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                        ++n;
                    }
                    break block20;
                }
                if (bl && !rE4.match(string2)) {
                    bl = false;
                }
                if (bl) {
                    RE rE5 = new RE("(" + string6 + ")");
                    boolean bl3 = true;
                    int n = 0;
                    int n3 = 0;
                    String[] stringArray = new String[10];
                    while (bl3) {
                        bl3 = rE5.match(string2, n);
                        if (!bl3) continue;
                        stringArray[n3] = rE5.getParen(1);
                        n += stringArray[n3].length() + 1;
                        ++n3;
                    }
                    int n4 = n3;
                    if (stringArray[n4 - 1].length() < 2 || stringArray[n4 - 1].length() > 3) {
                        bl = false;
                    }
                    if (n4 < 2) {
                        bl = false;
                    }
                }
            }
            catch (RESyntaxException rESyntaxException) {
                bl = false;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean maxLength(String string, int n) {
        return string.length() <= n;
    }

    public static boolean minLength(String string, int n) {
        return string.length() >= n;
    }
}

