/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.w3c.dom.Node;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class CompiledTemplate
extends ElemTemplate
implements Serializable {
    protected Object[] m_interpretArray;
    protected transient Hashtable m_nsThreadContexts = new Hashtable();

    public CompiledTemplate(ElemTemplate original, int lineNumber, int columnNumber, String publicId, String systemId, Object[] interpretArray) {
        SAXSourceLocator locator = new SAXSourceLocator();
        locator.setLineNumber(lineNumber);
        locator.setColumnNumber(columnNumber);
        locator.setPublicId(publicId);
        locator.setSystemId(systemId);
        this.setLocaterInfo(locator);
        this.m_interpretArray = interpretArray;
        this.setMatch(original.getMatch());
        this.setMode(original.getMode());
        this.setName(original.getName());
        this.setPriority(original.getPriority());
        this.setStylesheet(original.getStylesheet());
        int i = 0;
        while (i < this.m_interpretArray.length) {
            if (this.m_interpretArray[i] instanceof ElemTemplateElement) {
                ElemTemplateElement ete = (ElemTemplateElement)this.m_interpretArray[i];
                this.appendChild(ete.getParentElem().removeChild(ete));
            }
            ++i;
        }
    }

    public abstract void execute(TransformerImpl var1, Node var2, QName var3) throws TransformerException;

    public String getNamespaceForPrefix(String nsPrefix) {
        String nsuri = "";
        NamespaceSupport nsSupport = (NamespaceSupport)this.m_nsThreadContexts.get(Thread.currentThread());
        if (nsSupport != null) {
            nsuri = nsSupport.getURI(nsPrefix);
        }
        if (nsuri == null || nsuri.length() == 0) {
            nsuri = this.m_parentNode.getNamespaceForPrefix(nsPrefix);
        }
        return nsuri;
    }

    public boolean isCompiledTemplate() {
        return true;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_nsThreadContexts = new Hashtable();
    }
}

