/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import org.apache.commons.logging.Log;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public final class Log4JCategoryLog
implements Log {
    private Category category = null;

    public Log4JCategoryLog(String name) {
        this.category = Category.getInstance((String)name);
    }

    public Log4JCategoryLog(Category category) {
        this.category = category;
    }

    public void trace(Object message) {
        this.category.debug(message);
    }

    public void trace(Object message, Throwable t) {
        this.category.debug(message, t);
    }

    public void debug(Object message) {
        this.category.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.category.debug(message, t);
    }

    public void info(Object message) {
        this.category.info(message);
    }

    public void info(Object message, Throwable t) {
        this.category.info(message, t);
    }

    public void warn(Object message) {
        this.category.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.category.warn(message, t);
    }

    public void error(Object message) {
        this.category.error(message);
    }

    public void error(Object message, Throwable t) {
        this.category.error(message, t);
    }

    public void fatal(Object message) {
        this.category.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.category.fatal(message, t);
    }

    public boolean isDebugEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.category.isEnabledFor(Priority.ERROR);
    }

    public boolean isFatalEnabled() {
        return this.category.isEnabledFor(Priority.FATAL);
    }

    public boolean isInfoEnabled() {
        return this.category.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.category.isDebugEnabled();
    }

    public boolean isWarnEnabled() {
        return this.category.isEnabledFor(Priority.WARN);
    }
}

