/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlPreparedObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.XADataSource;

public class gweMysqlRowSet
implements RowSet,
Serializable {
    private static final int TRANSACTION_UNKNOWN = -1;
    private String dataSourceName = null;
    private Properties properties = null;
    private String url = null;
    private String username = null;
    private String password = null;
    private int transactionIsolation = -1;
    private int queryTimeout = 0;
    private int maxFieldSize = 0;
    private int maxRows = 0;
    private boolean readOnly = true;
    private Map typemap = null;
    private Vector listeners = new Vector();
    private boolean escapeProcessing = false;
    private String command = null;
    private Object[] param_obj_array = null;
    private int[] param_type_array = null;
    private ArrayList rows = null;
    private int index = 0;
    private boolean last_null = false;
    private int resultSetType = 1003;
    private int resultSetConcurrency = 1007;
    private int fetchDirection = 1002;
    private int fetchSize = 0;
    private ResultSetMetaData rs_meta = null;
    private Hashtable columnName = null;
    private Hashtable columnFullName = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) throws SQLException {
        this.dataSourceName = string;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) throws SQLException {
        this.properties = properties;
    }

    public String getUrl() throws SQLException {
        return this.url;
    }

    public void setUrl(String string) throws SQLException {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) throws SQLException {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.transactionIsolation = n;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setConcurrency(int n) throws SQLException {
        this.resultSetConcurrency = n;
    }

    public void setType(int n) throws SQLException {
        this.resultSetType = n;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (!bl) {
            throw new SQLException("mysql does not support setReadOnly(false).");
        }
        this.readOnly = bl;
    }

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.typemap = map;
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.listeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.listeners.remove(rowSetListener);
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (bl) {
            throw new SQLException("mysql does not support setEscapeProcessing(true).");
        }
        this.escapeProcessing = bl;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(this.command, "?", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string2.equals("?")) continue;
            ++n;
        }
        this.param_obj_array = new Object[n];
        this.param_type_array = new int[n];
        int n2 = 0;
        while (n2 < this.param_obj_array.length) {
            this.param_obj_array[n2] = null;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.param_type_array.length) {
            this.param_type_array[n2] = 0;
            ++n2;
        }
    }

    public void clearParameters() throws SQLException {
        if (this.param_obj_array != null && this.param_type_array != null) {
            int n = 0;
            while (n < this.param_obj_array.length) {
                this.param_obj_array[n] = null;
                ++n;
            }
            n = 0;
            while (n < this.param_type_array.length) {
                this.param_type_array[n] = 0;
                ++n;
            }
        } else {
            throw new SQLException("mysql error : clearParameters(), no parameter.");
        }
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSourceName != null) {
            try {
                InitialContext initialContext = null;
                initialContext = this.properties != null ? new InitialContext(this.properties) : new InitialContext();
                Object object = initialContext.lookup(this.dataSourceName);
                if (object == null) {
                    throw new SQLException("Invalid DataSource Object!! : null");
                }
                if (object instanceof DataSource) {
                    DataSource dataSource = (DataSource)object;
                    if (this.username != null && this.password != null) {
                        return dataSource.getConnection(this.username, this.password);
                    }
                    return dataSource.getConnection();
                }
                if (object instanceof ConnectionPoolDataSource) {
                    ConnectionPoolDataSource connectionPoolDataSource = (ConnectionPoolDataSource)object;
                    if (this.username != null && this.password != null) {
                        return connectionPoolDataSource.getPooledConnection(this.username, this.password).getConnection();
                    }
                    return connectionPoolDataSource.getPooledConnection().getConnection();
                }
                if (object instanceof XADataSource) {
                    XADataSource xADataSource = (XADataSource)object;
                    if (this.username != null && this.password != null) {
                        return xADataSource.getXAConnection(this.username, this.password).getConnection();
                    }
                    return xADataSource.getXAConnection().getConnection();
                }
                throw new SQLException("Invalid DataSource Object!! : " + object.toString());
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        if (this.url != null) {
            if (this.username != null && this.password != null) {
                return DriverManager.getConnection(this.url, this.username, this.password);
            }
            if (this.properties != null) {
                return DriverManager.getConnection(this.url, this.properties);
            }
            return DriverManager.getConnection(this.url);
        }
        return null;
    }

    private void prepareSQLStatement(PreparedStatement preparedStatement) throws SQLException {
        int n = 1;
        while (n <= this.param_obj_array.length) {
            preparedStatement.setObject(n, this.param_obj_array[n - 1], this.param_type_array[n - 1]);
            ++n;
        }
    }

    private void buildResultSet(ResultSet resultSet) throws SQLException {
        Object object;
        this.resultSetType = resultSet.getType();
        this.resultSetConcurrency = resultSet.getConcurrency();
        this.rs_meta = resultSet.getMetaData();
        int n = this.rs_meta.getColumnCount();
        this.columnName = new Hashtable();
        this.columnFullName = new Hashtable();
        int n2 = 1;
        while (n2 <= n) {
            String string = this.rs_meta.getColumnName(n2);
            object = this.rs_meta.getTableName(n2) + "." + string;
            Integer n3 = new Integer(n2 - 1);
            this.columnName.put(string, n3);
            this.columnFullName.put(object, n3);
            ++n2;
        }
        int n4 = 0;
        this.rows = new ArrayList();
        while (resultSet.next()) {
            object = new ArrayList(n);
            int n5 = 1;
            while (n5 <= n) {
                Object object2 = resultSet.getObject(n5);
                if (resultSet.wasNull()) {
                    object2 = null;
                }
                ((ArrayList)object).add(object2);
                ++n5;
            }
            this.rows.add(object);
            if (this.maxRows != 0 && ++n4 >= this.maxRows) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SQLException {
        Exception exception3;
        Statement statement;
        Connection connection;
        block17: {
            connection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                connection = this.getConnection();
                if (this.transactionIsolation != -1) {
                    connection.setTransactionIsolation(this.transactionIsolation);
                }
                connection.setReadOnly(this.readOnly);
                connection.setTypeMap(this.typemap);
                statement = connection.prepareStatement(this.command, this.resultSetType, this.resultSetConcurrency);
                statement.setFetchDirection(this.fetchDirection);
                statement.setFetchSize(this.fetchSize);
                statement.setMaxFieldSize(this.maxFieldSize);
                statement.setMaxRows(this.maxRows);
                statement.setQueryTimeout(this.queryTimeout);
                this.prepareSQLStatement((PreparedStatement)statement);
                resultSet = statement.executeQuery();
                this.buildResultSet(resultSet);
                Object var5_4 = null;
                if (resultSet == null) break block17;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var5_5 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                resultSet.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception3) {}
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.setObject(n, null, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support setBoolean(int, boolean).");
    }

    public void setByte(int n, byte by) throws SQLException {
        Byte by2 = new Byte(by);
        this.setObject(n, (Object)by2, -6);
    }

    public void setShort(int n, short s) throws SQLException {
        Short s2 = new Short(s);
        this.setObject(n, (Object)s2, 5);
    }

    public void setInt(int n, int n2) throws SQLException {
        Integer n3 = new Integer(n2);
        this.setObject(n, (Object)n3, 4);
    }

    public void setLong(int n, long l) throws SQLException {
        Long l2 = new Long(l);
        this.setObject(n, (Object)l2, -5);
    }

    public void setFloat(int n, float f) throws SQLException {
        Float f2 = new Float(f);
        this.setObject(n, (Object)f2, 6);
    }

    public void setDouble(int n, double d) throws SQLException {
        Double d2 = new Double(d);
        this.setObject(n, (Object)d2, 8);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setObject(n, (Object)bigDecimal, 3);
    }

    public void setString(int n, String string) throws SQLException {
        this.setObject(n, (Object)string, 12);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setObject(n, (Object)byArray, -3);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.setObject(n, (Object)date, 91);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.setObject(n, (Object)time, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setObject(n, (Object)timestamp, 93);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support setAsciiStream(int, InputStream, int).");
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support setUnicodeStream(int, InputStream, int).");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setObject(n, (Object)new gweMysqlPreparedObject(inputStream, n2), -4);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object, n2);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (this.param_obj_array != null && this.param_type_array != null && n <= this.param_obj_array.length && n <= this.param_type_array.length) {
            this.param_obj_array[n - 1] = object;
            if (object instanceof byte[] && n2 != -3) {
                n2 = -3;
            }
            if (object instanceof InputStream && n2 != -4) {
                n2 = -4;
            }
            this.param_type_array[n - 1] = n2;
            return;
        }
        throw new SQLException("gweMysqlPreparedStatement Error : setObject(int, Object, int).");
    }

    public void setObject(int n, Object object) throws SQLException {
        throw new SQLException("mysql does not support setObject(int, Object).");
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("mysql does not support setCharacterStream(int, Reader, int).");
    }

    public void setRef(int n, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support setRef(int, Ref).");
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
    }

    public void setClob(int n, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support setClob(int, Clob).");
    }

    public void setArray(int n, Array array) throws SQLException {
        throw new SQLException("mysql does not support setArray(int, Array).");
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.setObject(n, (Object)date, 91);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.setObject(n, (Object)time, 92);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setObject(n, (Object)timestamp, 93);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new SQLException("mysql does not support setNull(int, int, String).");
    }

    public boolean next() throws SQLException {
        int n = this.rows.size();
        if (this.index + 1 <= n) {
            ++this.index;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        this.rows = null;
    }

    public boolean wasNull() throws SQLException {
        return this.last_null;
    }

    public String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object instanceof Character) {
            return object != null ? String.valueOf((int)((Character)object).charValue()) : null;
        }
        return object != null ? object.toString() : null;
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Boolean.valueOf(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public byte getByte(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Byte.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Short.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return Double.valueOf(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return (BigDecimal)this.getObject(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getObject(n);
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getObject(n);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getObject(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getObject(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.getObject(n);
        return null;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.getObject(n);
        return null;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs_meta;
    }

    public Object getObject(int n) throws SQLException {
        try {
            ArrayList arrayList = (ArrayList)this.rows.get(this.index - 1);
            Object e = arrayList.get(n - 1);
            this.last_null = e == null;
            return e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        try {
            Integer n = (Integer)this.columnName.get(string);
            if (n == null) {
                n = (Integer)this.columnFullName.get(string);
            }
            if (n != null) {
                return n + 1;
            }
            throw new SQLException("Invalid column name : " + string);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 10);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == 0;
    }

    public boolean isAfterLast() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == n + 1;
    }

    public boolean isFirst() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == 1;
    }

    public boolean isLast() throws SQLException {
        int n = this.rows.size();
        return n > 0 && this.index == n;
    }

    public void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = 0;
            this.notifyCursorMoved();
        }
    }

    public void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = n + 1;
            this.notifyCursorMoved();
        }
    }

    public boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = 1;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n = this.rows.size();
        if (n > 0) {
            this.index = n;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public int getRow() throws SQLException {
        return this.index;
    }

    public boolean absolute(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        if (n == 0) {
            return false;
        }
        int n2 = this.rows.size();
        if (n < 0) {
            n = n2 + 1 + n;
        }
        this.index = n;
        if (this.index >= 1 && this.index <= n2) {
            this.notifyCursorMoved();
            return true;
        }
        if (this.index <= 0) {
            this.beforeFirst();
        } else {
            this.afterLast();
        }
        return false;
    }

    public boolean relative(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        int n2 = this.rows.size();
        this.index += n;
        if (this.index >= 1 && this.index <= n2) {
            this.notifyCursorMoved();
            return true;
        }
        if (this.index <= 0) {
            this.beforeFirst();
        } else {
            this.afterLast();
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (this.getType() == 1003) {
            throw new SQLException("TYPE_FORWARD_ONLY ResultSet does not support previous().");
        }
        if (this.index - 1 >= 1) {
            --this.index;
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getType() throws SQLException {
        return this.resultSetType;
    }

    public int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("mysql does not support rowUpdated().");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("mysql does not support rowInserted().");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("mysql does not support rowDeleted().");
    }

    public void updateNull(int n) throws SQLException {
        throw new SQLException("mysql does not support updateNull(int).");
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(int, boolean).");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("mysql does not support updateByte(int, byte).");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("mysql does not support updateShort(int, short).");
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateInt(int, int).");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("mysql does not support updateLong(int, long).");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(int, float).");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(int, double).");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(int, BigDecimal).");
    }

    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("mysql does not support updateString(int, String).");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(int, byte[]).");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("mysql does not support updateDate(int, Date).");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("mysql does not support updateTime(int, Time).");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(int, Timestamp).");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(int, InputStream, int).");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(int, InputStream, int).");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(int, Reader, int).");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object, int).");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("mysql does not support updateObject(int, Object).");
    }

    public void updateNull(String string) throws SQLException {
        throw new SQLException("mysql does not support updateNull(String).");
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("mysql does not support updateBoolean(String, boolean).");
    }

    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("mysql does not support updateByte(String, byte).");
    }

    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("mysql does not support updateShort(String, short).");
    }

    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("mysql does not support updateInt(String, int).");
    }

    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("mysql does not support updateLong(String, long).");
    }

    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("mysql does not support updateFloat(String, float).");
    }

    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("mysql does not support updateDouble(String, double).");
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("mysql does not support updateBigDecimal(String, BigDecimal).");
    }

    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("mysql does not support updateString(String, String).");
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("mysql does not support updateBytes(String, byte[]).");
    }

    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("mysql does not support updateDate(String, Date).");
    }

    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("mysql does not support updateTime(String, Time).");
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("mysql does not support updateTimestamp(String, Timestamp).");
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("mysql does not support updateAsciiStream(String, InputStream, int).");
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("mysql does not support updateBinaryStream(String, InputStream, int).");
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("mysql does not support updateCharacterStream(String, Reader, int).");
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object, int).");
    }

    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("mysql does not support updateObject(String, Object).");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("mysql does not support updateRow().");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("mysql does not support deleteRow().");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("mysql does not support refreshRow().");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("mysql does not support cancelRowUpdates().");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("mysql does not support moveToInsertRow().");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("mysql does not support moveToCurrentRow().");
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(int, Map).");
    }

    public Ref getRef(int n) throws SQLException {
        throw new SQLException("mysql does not support getRef(int).");
    }

    public Blob getBlob(int n) throws SQLException {
        throw new SQLException("mysql does not support getBlob(int).");
    }

    public Clob getClob(int n) throws SQLException {
        throw new SQLException("mysql does not support getClob(int).");
    }

    public Array getArray(int n) throws SQLException {
        throw new SQLException("mysql does not support getArray(int).");
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new SQLException("mysql does not support getObject(String, Map).");
    }

    public Ref getRef(String string) throws SQLException {
        throw new SQLException("mysql does not support getRef(String).");
    }

    public Blob getBlob(String string) throws SQLException {
        throw new SQLException("mysql does not support getBlob(String).");
    }

    public Clob getClob(String string) throws SQLException {
        throw new SQLException("mysql does not support getClob(String).");
    }

    public Array getArray(String string) throws SQLException {
        throw new SQLException("mysql does not support getArray(String).");
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        throw new SQLException("mysql does not support getURL(int).");
    }

    public URL getURL(String string) throws SQLException {
        throw new SQLException("mysql does not support getURL(String).");
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support updateRef(int, Ref).");
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("mysql does not support updateRef(String, Ref).");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(int, Blob).");
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("mysql does not support updateBlob(String, Blob).");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support updateClob(int, Blob).");
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("mysql does not support updateClob(String, Blob).");
    }

    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("mysql does not support updateArray(int, Array).");
    }

    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("mysql does not support updateArray(String, Array).");
    }

    private void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent(this);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).cursorMoved(rowSetEvent);
            }
        }
    }

    private void notifyRowChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent(this);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowChanged(rowSetEvent);
            }
        }
    }

    private void notifyRowSetChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent(this);
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((RowSetListener)iterator.next()).rowSetChanged(rowSetEvent);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

