/*
 * Decompiled with CFR 0.152.
 */
package gwe.sql;

import gwe.sql.gweMysqlColumn;
import gwe.sql.gweMysqlException;
import gwe.sql.gweMysqlPacket;
import gwe.sql.gweMysqlPacketChannel;
import gwe.sql.gweMysqlPacketNormal;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;

public class gweMysql {
    public static final int SLEEP = 0;
    public static final int QUIT = 1;
    public static final int INIT_DB = 2;
    public static final int QUERY = 3;
    public static final int FIELD_LIST = 4;
    public static final int CREATE_DB = 5;
    public static final int DROP_DB = 6;
    public static final int RELOAD = 7;
    public static final int SHUTDOWN = 8;
    public static final int STATISTICS = 9;
    public static final int PROCESS_INFO = 10;
    public static final int CONNECT = 11;
    Socket sock;
    SocketChannel socketchannel;
    boolean useSocketChannel;
    gweMysqlPacket packet;
    String host;
    int port;
    String database;
    String user;
    String password;
    byte protocolVersion;
    String serverVersion;
    int serverMajorVersion;
    int serverMinorVersion;
    int serverSubminorVersion;
    long threadId;
    String cryptSeed;
    long columnCount;
    gweMysqlColumn[] columnResult;
    Hashtable columnName;
    Hashtable columnFullName;
    int[] dataStart;
    String encoding;

    public gweMysql(String string, boolean bl) {
        this.encoding = string;
        this.useSocketChannel = bl;
    }

    public synchronized void Connect(String string, int n, String string2, String string3, String string4) throws gweMysqlException {
        this.host = string;
        this.port = n;
        this.database = string2;
        this.user = string3;
        this.password = string4;
        if (this.user.equals("")) {
            this.user = "nobody";
        }
        try {
            if (this.useSocketChannel) {
                this.socketchannel = SocketChannel.open();
                this.socketchannel.connect(new InetSocketAddress(this.host, this.port));
                SocketChannel socketChannel = this.socketchannel;
                SocketChannel socketChannel2 = this.socketchannel;
                this.packet = new gweMysqlPacketChannel(socketChannel, socketChannel2, this.encoding);
            } else {
                this.sock = new Socket(this.host, this.port);
                DataInputStream dataInputStream = new DataInputStream(this.sock.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(this.sock.getOutputStream());
                this.packet = new gweMysqlPacketNormal(dataInputStream, dataOutputStream, this.encoding);
            }
            this.packet.next();
            this.protocolVersion = this.packet.readByte();
            this.serverVersion = this.packet.readString();
            this.parseServerVersion(this.serverVersion);
            long l = this.packet.read4Bytes();
            this.cryptSeed = this.packet.readString();
            this.packet.clear_w();
            this.packet.write2Bytes(0);
            this.packet.write3Bytes(65535);
            this.packet.writeString(this.user);
            this.packet.writeString(this.cryptPassword(this.password, this.cryptSeed));
            this.packet.send();
            this.packet.next();
            byte by = this.packet.readByte();
            if (by == 255) {
                String string5 = this.packet.readString();
                throw new gweMysqlException(string5);
            }
            if (by != 0) {
                throw new gweMysqlException("Unknown status code '" + by + "'");
            }
            long l2 = this.packet.readLength();
            long l3 = this.packet.readLength();
            this.packet.clear_w();
            this.packet.resetPacketSequence();
            this.packet.writeByte((byte)2);
            this.packet.writeStringNoNull(this.database);
            this.packet.send();
            this.packet.next();
            by = this.packet.readByte();
            if (by == 255) {
                String string6 = this.packet.readString();
                throw new gweMysqlException(string6);
            }
            if (by != 0) {
                throw new gweMysqlException("Unknown status code '" + by + "'");
            }
            l2 = this.packet.readLength();
            l3 = this.packet.readLength();
        }
        catch (Exception exception) {
            throw new gweMysqlException("gweMysql.Connect: " + exception);
        }
    }

    void parseServerVersion(String string) throws gweMysqlException {
        this.serverMajorVersion = -1;
        this.serverMinorVersion = -1;
        this.serverSubminorVersion = -1;
        int n = string.indexOf(46);
        if (n >= 1) {
            try {
                this.serverMajorVersion = Integer.parseInt(string.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                throw new gweMysqlException("Illegal Server Version : " + string);
            }
        } else {
            throw new gweMysqlException("Illegal Server Version : " + string);
        }
        String string2 = string.substring(n + 1, string.length());
        n = string2.indexOf(46);
        if (n >= 1) {
            try {
                this.serverMinorVersion = Integer.parseInt(string2.substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                throw new gweMysqlException("Illegal Server Version : " + string);
            }
        } else {
            throw new gweMysqlException("Illegal Server Version : " + string);
        }
        string2 = string2.substring(n + 1, string2.length());
        int n2 = 0;
        while (n2 < string2.length()) {
            char c = string2.charAt(n2);
            if (c < '0' || c > '9') break;
            ++n2;
        }
        try {
            this.serverSubminorVersion = Integer.parseInt(string2.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            throw new gweMysqlException("Illegal Server Version : " + string);
        }
    }

    int judgeServerVersion(int n, int n2, int n3) {
        if (this.serverMajorVersion > n) {
            return 1;
        }
        if (this.serverMajorVersion < n) {
            return -1;
        }
        if (this.serverMinorVersion > n2) {
            return 1;
        }
        if (this.serverMinorVersion < n2) {
            return -1;
        }
        if (this.serverSubminorVersion > n3) {
            return 1;
        }
        if (this.serverSubminorVersion < n3) {
            return -1;
        }
        return 0;
    }

    String getServerVersion() {
        return this.serverVersion;
    }

    int getServerMajorVersion() {
        return this.serverMajorVersion;
    }

    int getServerMinorVersion() {
        return this.serverMinorVersion;
    }

    int getServerSubminorVersion() {
        return this.serverSubminorVersion;
    }

    long hashPassword(String string) {
        long l = 1345345333L;
        long l2 = 7L;
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                long l3 = string.charAt(n);
                l ^= ((l & 0x3FL) + l2) * l3 + (l << 8);
                l2 += l3;
            }
            ++n;
        }
        return l & Integer.MAX_VALUE;
    }

    String cryptPassword(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        long l = 0x1FFFFFFL;
        long l2 = this.hashPassword(string);
        long l3 = this.hashPassword(string2);
        long l4 = l2 ^ l3;
        long l5 = l4 %= l;
        long l6 = l4 / 2L;
        char[] cArray = new char[string2.length()];
        int n = 0;
        while (n < string2.length()) {
            l5 = (l5 * 3L + l6) % l;
            l6 = (l5 + l6 + 33L) % l;
            double d = (double)l5 / (double)l;
            byte by = (byte)Math.floor(d * 31.0 + 64.0);
            cArray[n] = (char)by;
            ++n;
        }
        return new String(cArray);
    }

    public gweMysql sqlQuery(String string) throws gweMysqlException {
        this.packet.clear_w();
        this.packet.resetPacketSequence();
        this.packet.writeByte((byte)3);
        this.packet.writeStringNoNull(string);
        this.packet.send();
        this.packet.next();
        this.columnCount = this.packet.readLength();
        if (this.columnCount == 255L || this.columnCount == -1L) {
            String string2 = this.packet.readString();
            throw new gweMysqlException(string2);
        }
        if (this.columnCount == 0L) {
            return null;
        }
        this.columnResult = new gweMysqlColumn[(int)this.columnCount];
        this.columnName = new Hashtable((int)this.columnCount);
        this.columnFullName = new Hashtable((int)this.columnCount);
        this.dataStart = new int[(int)this.columnCount];
        int n = 0;
        while ((long)n < this.columnCount) {
            this.packet.next();
            String string3 = this.packet.readLenString();
            String string4 = this.packet.readLenString();
            int n2 = this.packet.readnBytes();
            int n3 = this.packet.readnBytes();
            this.packet.readByte();
            short s = (short)this.packet.ub(this.packet.readByte());
            int n4 = this.packet.ub(this.packet.readByte());
            this.columnResult[n] = new gweMysqlColumn(string3, string4, n2, n3, s, n4);
            this.columnName.put(string4, new Integer(n));
            String string5 = string3.concat(".").concat(string4);
            this.columnFullName.put(string5, new Integer(n));
            ++n;
        }
        this.packet.next();
        return this;
    }

    public long[] sqlUpdate(String string) throws gweMysqlException {
        this.packet.clear_w();
        this.packet.resetPacketSequence();
        this.packet.writeByte((byte)3);
        this.packet.writeStringNoNull(string);
        this.packet.send();
        this.packet.next();
        int n = this.packet.ub(this.packet.readByte());
        if (n == 255) {
            String string2 = this.packet.readString();
            throw new gweMysqlException(string2);
        }
        long l = this.packet.readLength();
        long l2 = this.packet.readLength();
        long[] lArray = new long[]{l, l2};
        return lArray;
    }

    public void sqlQuit() throws gweMysqlException {
        this.packet.clear_w();
        this.packet.resetPacketSequence();
        this.packet.writeByte((byte)1);
        this.packet.send();
    }

    public boolean nextResult() throws gweMysqlException {
        this.packet.next();
        if (!this.packet.isLastDataPacket_r()) {
            int n = 0;
            while ((long)n < this.columnCount) {
                int n2;
                this.dataStart[n] = n2 = this.packet.currentPos_r();
                switch (this.packet.ub(this.packet.getCurDataPos_r())) {
                    case 252: {
                        n2 += 2;
                        break;
                    }
                    case 253: {
                        n2 += 3;
                        break;
                    }
                    case 254: {
                        n2 += 4;
                        break;
                    }
                }
                long l = this.packet.readLength();
                if (l == -1L) {
                    l = 0L;
                }
                this.packet.setPos_r(1 + n2 + (int)l);
                ++n;
            }
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return (int)this.columnCount;
    }

    public gweMysqlColumn getColumn(int n) throws gweMysqlException {
        if ((long)(--n) < this.columnCount && n >= 0) {
            return this.columnResult[n];
        }
        throw new gweMysqlException("Invalid column number : " + n);
    }

    public boolean isNull(int n) throws gweMysqlException {
        if ((long)(--n) < this.columnCount && n >= 0) {
            this.packet.setPos_r(this.dataStart[n]);
            long l = this.packet.readLength();
            return l == -1L;
        }
        throw new gweMysqlException("Invalid column number : " + n);
    }

    public int getColumnNum(String string) throws gweMysqlException {
        Integer n = (Integer)this.columnName.get(string);
        if (n == null) {
            n = (Integer)this.columnFullName.get(string);
        }
        if (n != null) {
            return n + 1;
        }
        throw new gweMysqlException("Invalid column name : " + string);
    }

    public String getString(int n) throws gweMysqlException {
        if ((long)(--n) < this.columnCount && n >= 0) {
            this.packet.setPos_r(this.dataStart[n]);
            return this.packet.readLenString();
        }
        throw new gweMysqlException("Invalid column number : " + n);
    }

    public String getString(String string) throws gweMysqlException {
        int n;
        Integer n2 = (Integer)this.columnName.get(string);
        if (n2 == null) {
            n2 = (Integer)this.columnFullName.get(string);
        }
        if (n2 != null && (long)(n = n2 + 1) < this.columnCount) {
            this.packet.setPos_r(this.dataStart[n]);
            return this.packet.readLenString();
        }
        throw new gweMysqlException("Invalid column string : " + string);
    }

    public byte[] getBytes(int n) throws gweMysqlException {
        if ((long)(--n) < this.columnCount && n >= 0) {
            this.packet.setPos_r(this.dataStart[n]);
            long l = this.packet.readLength();
            if (l == -1L) {
                return null;
            }
            byte[] byArray = this.packet.readByteBlock((int)l);
            return byArray;
        }
        throw new gweMysqlException("Invalid column number : " + n);
    }

    public void reConnect() throws gweMysqlException {
        try {
            this.sqlQuit();
            this.sock.close();
            this.Connect(this.host, this.port, this.database, this.user, this.password);
        }
        catch (Exception exception) {
            throw new gweMysqlException("gweMysql.reConnect: " + exception);
        }
    }

    public void Close() throws gweMysqlException {
        try {
            this.sqlQuit();
            this.sock.close();
        }
        catch (Exception exception) {
            throw new gweMysqlException("gweMysql.Close: " + exception);
        }
    }

    gweMysqlPacket getPacket() {
        return this.packet;
    }

    String getEncoding() {
        return this.encoding;
    }
}

