/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;

public class ANTLR
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File target;
    private File outputDirectory;
    private boolean fork = false;
    private File dir;

    public ANTLR() {
        this.commandline.setVm("java");
        this.commandline.setClassname("antlr.Tool");
    }

    public void setTarget(File target) {
        this.log("Setting target to: " + target.toString(), 3);
        this.target = target;
    }

    public void setOutputdirectory(File outputDirectory) {
        this.log("Setting output directory to: " + outputDirectory.toString(), 3);
        this.outputDirectory = outputDirectory;
    }

    public void setFork(boolean s) {
        this.fork = s;
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.target.lastModified() > this.getGeneratedFile().lastModified()) {
            this.commandline.createArgument().setValue("-o");
            this.commandline.createArgument().setValue(this.outputDirectory.toString());
            this.commandline.createArgument().setValue(this.target.toString());
            if (this.fork) {
                this.log("Forking " + this.commandline.toString(), 3);
                int err = this.run(this.commandline.getCommandline());
                if (err == 1) {
                    throw new BuildException("ANTLR returned: " + err, this.location);
                }
            } else {
                Execute.runCommand((Task)this, (String[])this.commandline.getCommandline());
            }
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.target == null || !this.target.isFile()) {
            throw new BuildException("Invalid target: " + this.target);
        }
        if (this.outputDirectory == null) {
            String fileName = this.target.toString();
            this.setOutputdirectory(new File(this.target.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
        if (this.fork && (this.dir == null || !this.dir.isDirectory())) {
            throw new BuildException("Invalid working directory: " + this.dir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private File getGeneratedFile() throws BuildException {
        String generatedFileName = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.target));
            while ((line = in.readLine()) != null) {
                void var3_4;
                int extendsIndex = var3_4.indexOf(" extends ");
                if (!var3_4.startsWith("class ") || extendsIndex <= -1) continue;
                generatedFileName = var3_4.substring(6, extendsIndex).trim();
                break;
            }
            in.close();
        }
        catch (Exception e) {
            throw new BuildException("Unable to determine generated class");
        }
        if (generatedFileName == null) {
            throw new BuildException("Unable to determine generated class");
        }
        return new File(this.outputDirectory, generatedFileName + ".java");
    }

    private int run(String[] command) throws BuildException {
        Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), null);
        exe.setAntRun(((ProjectComponent)this).project);
        exe.setWorkingDirectory(this.dir);
        exe.setCommandline(command);
        try {
            return exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

