/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.jocl.JOCLContentHandler;
import org.apache.commons.pool.ObjectPool;

public class PoolingDriver
implements Driver {
    protected static HashMap _pools;
    protected static String URL_PREFIX;
    protected static int URL_PREFIX_LEN;
    protected static int MAJOR_VERSION;
    protected static int MINOR_VERSION;
    static /* synthetic */ Class class$java$lang$String;

    public synchronized ObjectPool getPool(String string) {
        InputStream inputStream;
        ObjectPool objectPool = (ObjectPool)_pools.get(string);
        if (null == objectPool && null != (inputStream = this.getClass().getResourceAsStream(String.valueOf(string) + ".jocl"))) {
            JOCLContentHandler jOCLContentHandler = null;
            try {
                jOCLContentHandler = JOCLContentHandler.parse(inputStream);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
            if (jOCLContentHandler.getType(0).equals(class$java$lang$String == null ? (class$java$lang$String = PoolingDriver.class$("java.lang.String")) : class$java$lang$String)) {
                objectPool = this.getPool((String)jOCLContentHandler.getValue(0));
                if (null != objectPool) {
                    this.registerPool(string, objectPool);
                }
            } else {
                objectPool = ((PoolableConnectionFactory)jOCLContentHandler.getValue(0)).getPool();
                if (null != objectPool) {
                    this.registerPool(string, objectPool);
                }
            }
        }
        return objectPool;
    }

    public synchronized void registerPool(String string, ObjectPool objectPool) {
        _pools.put(string, objectPool);
    }

    public boolean acceptsURL(String string) throws SQLException {
        try {
            return string.startsWith(URL_PREFIX);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            ObjectPool objectPool = this.getPool(string.substring(URL_PREFIX_LEN));
            if (null == objectPool) {
                throw new SQLException("No pool found for " + string + ".");
            }
            try {
                return (Connection)objectPool.borrowObject();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
        return null;
    }

    public int getMajorVersion() {
        return MAJOR_VERSION;
    }

    public int getMinorVersion() {
        return MINOR_VERSION;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new PoolingDriver());
        }
        catch (Exception exception) {
            // empty catch block
        }
        _pools = new HashMap();
        URL_PREFIX = "jdbc:apache:commons:dbcp:";
        URL_PREFIX_LEN = URL_PREFIX.length();
        MAJOR_VERSION = 1;
        MINOR_VERSION = 0;
    }
}

