#include <emsg: see ... '~$ sh aaa.sh.c -h'   (other opt:no/-m/-w/)>	/*
C='^[#]SH_'     ;O=${0##*[/]};R=`dirname $0`;R=${R%/}/;R0=$R$O;R=$R${O%%.*}
O=${0##*.};Rs=$R.$O;Rm=$R.tmp.$O;Rh=$R.h;R=$Rs$Rh$Rm;Rp='printf %s\n ';Rc=:;O="
";[ "${R##*$R0*}" = '' ]&&$Rp"$0:NGsuffix"&&exit 1;R='sed -ne ';Cm=$R'"/[E]ND/!d
:l;n;p;bl"<$R0>$Rm;$Rp"$Rm"';RB=$($R"s/${C}OP//p"<$R0|(F=mw;while read -r a b;do
B=${a%:};F=`$Rp"$F"|$R"s#$B:*##1;p"`${a%_};$Rp"C$B=\$(cat<<'E'$O$b${O}E$O)";done
$Rp"R1=$F"));Rw=$R'"/$C$R/!d;:l;n;/${C}ED/q;p;bl"<$R0';Cw="(R=LS;$Rw;$Rw>&3;R=HD
$Rw;R=SC;$Rw>&3)"'>$Rh 3>$Rs;$Rp"$Rh $Rs"';Re=eval\ ;$Re"$RB";while getopts $R1\
 R;do case $R in \?)exit 1;;*)$Re"O$R=\$OPTARG";Rc=$Rc$O`$Re'$Rp"$C'$R\"`;;esac
done;[ "$Rc" = : ]&&Rc=$Cm;shift $((OPTIND-1));$Re"$C_$O$Rc";exit   #END GPL3+*/

#SH_LS
#!/bin/sh
cat << 'EEE' > /dev/null
/* Copyright (C) 2021 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

cat << 'EEE' > /dev/null
#SH_doc
title=*SH_bn* section=1 repnl=\040
@name *SH_bn*
@_brief line oriented universal preprocesser using posix-shell
@_syno
	brp [-hHQsS]
@tl;dr
		@(code)@
	~$ brp -s | tee src.sh.c
	~$ sh src.sh.c -a	#>>output 'hw'
	~$ sh src.sh.c -a -b -a		#>>hw, exec ls, hw
		@()
@_opt
	@(list_o)
	-hHV: usage, version
	-Q: output corecode
	-sS: output sample
	@()
@_desc
	*SH_bn* is portable preprocesser. code is separated with 2 parts,
	main code(#inc...#END) and option code (//SH_OP ...). workflow is:
	@(code)--@
	  1: exec src as shell script. ~$ sh src.sh.c -a
	  2: main code searches regex suitable line (dfl: //SH_OP, /*SH_OP etc)
	  3: read hitline and save string to vars ($Ca, $Cb, $C... etc)
	  4: exec option code if you use -a >> eval "$Ca", -z >> eval "$Cz"
	@()--@

	@(raw).SS main code@()
	--
	brp exec the head 10 line code as shell script and exit.
	@(code)--
	#inc...
	C='^[/][/*]SH_'    ; ...
		...#END
	@()--
	main code holds regex string var `C` to get option code line. this var is
	used as:
	@(code)--
	~$ cat src.sh.c | sed -ne "/$C/p"		#BRE-reg. 
	@()--
	and gather //SH_OP or //SH_??? etc. linetop '#include...' is assert()
	for c/cpp (~$ cc src.sh.c #stop) so you can delete if you want.	--
	main code holds predefined option code, -w, -m. see below for details.
	--
	@(raw).SS option code@()
	--
	you can expand the brp working with option code.
	@(code)
	//SH_OP  b: z=100;echo "good-bye $2 $Ob $1 $z $R0"
	  1  2 3 4                5
	@()
	@(list)
	1: dfl opthead is "//SH_" or "/*SH_". see below '$C'.
	2: option line suffix `OP` is fixed. 
	3: separate with blank char(spaces or tabs)
	4: optchar is [a-zA-Z0-9] or `_`(see below). add colon if use optarg
	5: write raw sh-script with 'ONE LINE'. code is used as below.
		@(code)@
		Cb=$(cat<<'E'
		z=100;echo "good-bye $2 $Ob $1 $z $R0"
		E
		)
		eval "$Cb"		#if -b set
		@()
	-: if you set special optchar `_`, it works only once at the script
		beginning. --
		@(code)@
		//SH_OP _ echo "preset AA";AA=1
		//SH_OP a echo "$AA"	#>>~$ sh src.sh.c -a ... disp "1"
		@()@
	
	-: adopt new one if overlap the option setting.
		@(code)@
		//SH_OP a echo "hw"	#>> ignored. sh src.sh.c -a  -> disp "gw"
		//SH_OP a echo "gw"
		@()@
	@()

	@(raw).SS about reserved vars or other@()--
	1-2char var names R?, C?, O? are reserved (R,C,O,Ra,R7,Cg,O5 ...).
	optarg is set to $O? ( a: >> $Oa ,  v: >> $Ov etc)
	@(list)
	$R0,Rm,Rs,Rh: orig/tMp/src/header fname. ($Rm -> src.tmp.c etc)
		fname uses topname + last suffix. eg) src.xx.yy.py3 -> ./src.py3 --
		original fname should avoid tmp/src/header fname. --
		(sh src.c -w >> src.h / src.c ...orig destroyed)
		
	$C?: $Ca/$Cb etc. code buffer.
		@(code)@
		//SH_OP a echo "$Rm"	# ~$ sh brp.sh.c -a >> disp brp.tmp.c
		//SH_OP b printf "$Ca"	# ~$ sh brp.sh.c -b >> disp echo "$Rm"
		//SH_OP c eval "$Ca"	#.. -c works as equals to -a
		@()@

	$Cw: predefined -w option. uses for c-lang. you will make sense of
		the work by exec.
		@(code)--@
		~$ brp -S > src.sh.c	#sample
		~$ sh src.sh.c -w
		
		1. write SH_LS - SH_ED(LS_block) to both src.h($Rh)/src.c($Rs)
		2. add HD_block to src.h, SC_block to src.c
		3. disp filename to stdout.  (src.h src.c)
		-. suffixes(LS,HD,SC,ED) are fixed
		@()@

	$Cm: predefined -m option. remove brp maincode(#inc...#END) and output
		to $Rm (XX.tmp.XX). you may uses for general perpose. 

	$C: comment regex. dfl is  C=`^[/][/*]SH_`, //SH_xx or /*SH_yy etc. --
		brp uses linecmt as directive. if you want to use other
		pg-lang(python etc), edit srctop `C=...` directly. use BRE-reg.
		@(code)--@
		shell : C='^#ANYSTR_';	>>  #ANYSTR_LS, #ANYSTR_ED etc
		python: C='^["]["]["]MARKER_';	>> """MARKER_OP   etc
		basic : C="^[']SH_";	>> 'SH_OP etc
	    @()--@
		$C is used as follows. escape slash '/' plz. --
		  ''sed -e "/${C}ED/"  ...  (bad)C='^/[/*]SH_' (good)C='^\/[/*]SH_' ''
	
	$O?: ''optargs. //SH_OP a: echo "$Oa"  .. ~$ sh src.sh.c -a 11 ..11''
	$O: newline(\n).  eg) //SH_OP a echo "a${O}b" >> disp a(\n)b
	$0,1,2: normal args. this pg uses getopts. checked opts are removed. --
	eg) //SH_OP a echo "$1"	 #~$ sh src.sh.c -a -c 11 >> output 11
	  
	@()
@_eg
	@(raw).SS sample for cxx@()--
	@(code)--@
	--- copy & paste main script ---
	#include <iostream>
	int main(void){
	  std::cout << "hw" << std::endl;
	}
	//SH_OP b eval "$Cm";g++ "$Rm"; ./a.out
	@()--@
	...save as `src.brp.cpp` and run ~$ sh src.brp.c -b  >>> hw.
	--
	@(raw).SS one liner script@()
	--
	this app frequency uses one liner. introduce some tips.
	@(code)--@
	//SH_OP m sed -ne "/[E]ND/{n;bl};d;:l;p;n;bl"<"$R0">"$Rm";echo "$Rm"
	>>
	sed -ne '*see below*' < "$R0" > "$Rm"
	echo "$Rm"
	>>
	cat 'foo.sh.c' | sed -ne '...' > foo.tmp.c
	echo "foo.tmp.c"
	@()--@

	sed command pseudocode is the follows:
	@(code)--@
	------
	sed -ne '/[E]ND/{n;bl};d;:l;p;n;bl'
	>>
	sed -n(o print. print only when requested) -e(xpression as script)
	
	if (line==/END/){  .../[E]ND/
	  n(ext read) ...n (if not -n opt, print nowline & readnext)
	  goto label l ...b l (b=jump/goto. babc -> b abc -> goto abc)
	}
	del line (& read nextline & *goto top*) ...d (d cmd is hard worker)
	label l:		... :l (label. ':' + 'lbl name') 
	p(rint line)		... p
	n(extline read)		... n
	goto label l		... b l
	
	...del lines until 1st hit 'END'. print all lines until EOF.
	-------
	@()--@
	sed cmd is difficult but very powerful. Most requests can be solved 
	by referring to the above.
	--
	@(raw).SS edit string with sed/shell@()
	--
	sed cant use shortest match, but shell is possible(shotest+longest).
		@(code)--
	str="aa_bb_cc"
	echo "${str#*_}" 	#>> bb_cc (match aa_ and del)
	echo "${str##*_}" 	#>> cc (longet)
	echo "${str%_*}" 	#>> aa_bb (from tail)
	echo "${str%%_*}" 	#>> aa
		@()--
	shell pattern(glob pattern) is very similar to sed-regex:
	@(code)
	aa_bb_cc -> a_bb_cc
	reg: s/^.//g
	sh : ${str#?}	... any one char. reg:'.'    sh:'?'
	
	aa_bb_cc -> (del)
	reg: ^[.]*
	sh : ${str#*}	... all. sh can uses wild card.
	
	aa_bb_cc -> aa_
	reg: [^a_]*
	sh : ${str%%[!a_]*}	... not.  reg:'^'    sh:'!'
	...[], bracket works as same, 'one char'
	
	escape
	sh: ${str%123"*"*}  ... "*" uses as literal. 0123*567 -> 0
		@()--
	see https://en.wikipedia.org/wiki/Glob_%28programming%29  ..or.. --
	~$ man sh + input `/` + input `pattern` + enter + `n` + `shift_n`

@exit_status	-
@notes
	@(code)@
	--- concept
	I wondered why to write dependencies or compile options to makefiles.
	The source code should contain all the necessary information.
	Because the programmer's will is written in it. I dont like writing
	in separate files and increasing the workflow.
	
	- avoid info fragmentation (script/src/header/gcc opt/ini/config etc)
	- small. avoid disturbing the main code.
	- (consider readability)
	- portable. avoid vender lockin, bashism etc.
	- low learning cost. good usage help, dont need installation etc
	- others ... see unix philosophy.
		@()
@conforming_to	posix-shell
@copyright
	Copyright (C) 2021 Momi-g --
	License GPLv3+ <https://gnu.org/licenses/gpl.html>
@_ver 2021-09-14 v1.0.2
@_see
https://en.wikipedia.org/wiki/Glob_%28programming%29	--
http://catb.org/%7Eesr/writings/taoup/html/ch10s05.html

#SH_docE
EEE
#SH_ED

#SH_HD
#SH_ED

#SH_SC
f_usage(){
cat << 'EEE'
HowTo (*SH_bn*, line oriented universal preprocessor using posix-sh)
opt: -hH(elp), -V(ersion), -Q(corecode), -sS(ample)
------
 this script works by just copying and pasting into your file top.
	~$ brp 	#>> output maincode
	~$ brp -s	#>> output sample
 
 sample usage is:
 	~$ brp -S | tee src.sh.c
	~$ sh src.sh.c -a	#>> output 'hw'
	~$ sh src.sh.c -c	#>> compile, link then exec a.out
	~$ ls	#>> check output files

 brp holds predefined option, -m/-w
  ~$ sh src.sh.c -m #>> make tMp file (src.tmp.c)
  ~$ sh src.sh.c -w #>> make src.h + src.c. if src.sh.java, src.h + src.java

 your extension: add '//SH_OP z echo "12345"' to this file end and run.
	~$ sh src.sh.c -z -w -z  #>> 12345 x2 ..see also  ~$ brp -H|less
EEE
exit 0
}

f_usage_H(){
 cat << 'E E'|sed -e'1d;$d'
	#SH_rf* *SH_bn*.1.txt	*
E E
exit 0
}

f_version_info(){
cat << 'EEE'
*SH_bn* *SH_ver*
Copyright (C) 2021 Momi-g
License GPLv3+: GNU GPL version 3 or later <https://gnu.org/licenses/gpl.html>
EEE
exit 0
}

f_eg1(){
cat<<-HDOC
$code

	//SH_OP a echo "hw"
	//SH_OP b ls -al
HDOC
exit 0
}

f_eg2(){
cat<<-HDOC; cat<<-'HDOC_'
$code

HDOC
//SH_LS
	//license is XXX
	//SH_ED

//SH_HD
#include <stdio.h>
int myf(void);
	//SH_ED

/*SH_SC*/
int myf(void){puts("cc_hw");return 0;}
int main(int argc, char** argv){return myf();}
	//SH_ED

	//SH_OP a echo "hw"
	//SH_OP c eval "$Cw";cat "$Rh" "$Rs">"$Rm"; cc "$Rm"; ./a.out
HDOC_
exit 0
}

code=$(cat<<'HDOC' | sed -e '1d;$d;s@\[#]@[/][/*]@1'
#SH_rf* *SH_bn*.head	*
HDOC
)

f_err(){ echo "*SH_bn*: err. $*">/dev/stderr;exit 1; }
*SH_bn*_main()(
	while getopts ":hHVQsS" c; do case "$c" in				
	[?:]) f_err "bad opt: $OPTARG, $*" ;;	
	h) f_usage	;;
	H) f_usage_H	;;
	V) f_version_info	;;
	Q) printf '%s\n' "$code"; exit 0	;;
	s) f_eg1	;;
	S) f_eg2	;;
	esac; done; shift $(($OPTIND-1))
	
	#direct use
	printf '%s\n' "$code"
)
*SH_bn*_main "$@" || exit	#SH_MAIN

#SH_TSS
test_1(){
	buf=`./brp -h`;	_suc 1
	buf=`./brp -H`;	_suc 2
	buf=`./brp -V`;	_suc 3
	buf=`./brp -Q`;	_suc 4
	buf=`./brp -s`;	_suc 5
	buf=`./brp -S`;	_suc 6
}
#SH_TSE

#SH_TSS
test_2(){
	_eq 1 1
}
#SH_TSE


cat<<'EEE'>/dev/null
 change log
 --
2021-09-14  Momi-g	<dmy@dmy.dmy>

	* *SH_bn*: new pkg. add doc etc. v1.0.2 

2021-05-11  Momi-g	<dmy@dmy.dmy>

	* brp.sh.c : v1.0.1 add mandoc, improve brp script 

2020-01-04  Momi-g	<dmy@dmy.dmy>

	* brp.sh.c : v1.0.0 releases. 
EEE

#SH_ED

#SH_OP _ a=`sed -ne "/${C}DF/!d;:l;n;/${C}DE/q;p;bl"<$R0`;eval "$a";set +e	#*/
#SH_OP h $p"-tsbS:test/eg/.o/.so -LMP:leak,mem,prof -f:funcs -o:bldout		GPLv3+"	 #*/
#SH_OP f sed -ne "/${C}DF/q;/;/d;/^[a-z].*)/p"<$R0 #*/
#SH_OP t $e"$Cb";ftt "$@">$Rm;mv $Rm $tf;bash --posix $tf "$@"

#SH_OP b sed -ne 'p;/END/q'<$R0>$bn.head
#SH_OP W $e"$Cb;$Cm$O$Cw">/dev/null;$i0;$i1;rm -f $bn;cp $Rs $bn;chmod 755 $bn;$p"$bn $Rs $Rh $tf"	#*/
#SH_OP o $p'$Cb;fman $Rs 1'|fv		#*/

#SH_DF
#-- noob
fman()( $p"fgr0 '${C}doc' '${C}docE'<$1|fbn|amn >$bn.$2
 mandoc -Thtml <$bn.$2 >$bn.$2.html
 ## mandoc -Tps <$bn.$2 >${bn}_$2.ps
 ## mandoc -Tpdf <$bn.$2 >${bn}__$2.pdf
 (echo '.mso ja.tmac';cat $bn.$2)|man -Tutf8 -l -|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
 # man -Tutf8 /dev/stdin<$Rm|sed -e 's/.`printf \"\\b\"`//g'>$bn.$2.txt"|fv
 # cat ${bn}_$2.txt|enscript -f Ricty11 -p $bn$2.ps
 # ps2pdf ${bn}_$2.ps ${bn}_$2.pdf
 # ps2pdf ${bn}$2.ps ${bn}$2.pdf"|fv
)
#mandoc -Tascii <$bn.$2 |sed -e 's/."`printf '\010'`"//g'>${bn}_$2.txt

#-- local

#-- vars
bn=`basename ${Rs%.*}`; tf=${Rs%/*}/${bn}.ts.${Rs##*.}; e="eval "; p="$Rp"
#-- mod
fv()(while read -r a;do $e"cat<<E$O# $a${O}E"|sed -e 's@-L.*-L[^ ]*@-L(omit)@g'>/dev/stderr;$e"$a";done)

fbn()(sed -e "s@\*${C##*]}bn\*@$bn@g"|frf|frv)
fsn()(tr -s ' \t' '\n')
fsl()(tr -s '\n' ' ')
fu()(fsn|sort -u)
fU()(fu|fsl;$p)

fgr()(sed -e "/$1/!d;:l;/$2/{p;d};n;bl")	#切出
fgr0()(sed -ne "/$1/!d;:l;n;/$2/d;p;bl")	#抜き切出
fgR()(sed -ne "/$1/bl;p;d;:l;n;/$2/d;bl")	#切すて
fg()(sed -ne "s/.*${C##*]}co\*\([^*]*\).*$/\1/p" "$@"|fsn|awk '!a[$0]{a[$0]=1;print}'|fsl)

#-- longcmd
frf()(
 awk -v r="${C##*]}rf" 'match($0,r){
 s=substr($0, RSTART+RLENGTH+1)	# /*SH_rf*, #SH_rf* abc.txt 123.txt *  ..etc 
 gsub(/.[^*]*$/, "", s);split(s, a)
 m="[ -f %s ]&&echo \"/*--copyfrom %s*\"/&&cat %s&&echo \"/*--copyend %s*\"/"
 for(i=1;v=a[i];i++){ system( sprintf(m, v,v,v,v)) }
 next
 }
 {print}'
)
frv()(buf=`awk '$1=="@_ver" {print $3;exit}'<$R0`;sed -e "s@\*${C##*]}ver\*@$buf@g")

ftt()(
 suite=$(cat $tf|awk '$1~/^test_[^(]*\(\)/{print $1}'|sed -e 's/[(].*//g')
 [ $# = 0 ] || suite="$suite $@"
 [ $# != 0 ]  || suite="$suite $suite"
 suite=`$p'%s\n' "$suite"|tr '[ \t]' '\n'|sort|uniq -d`
 (shunit_m;cat $bn $tf|grep -vF "${C##*]}MAIN"
 $p' [ $# = 0 ] && set -- '"$suite"';for fc;do $fc ;done;_res')
)

i0=$e'fgr "${C}TSS" "${C}TSE"<$Rm|fbn>$tf'
i1=$e'fgR "${C}TSS" "${C}TSE"<$Rs|fbn>$Rm;mv $Rm $Rs'
#SH_DE
