/*
 *  Breeze  --  An application launcher with command-line style
 *  Copyright (C) 2005, 2006, 2008 Hironao Komatsu
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "commands.h"
#include "user_commands.h"
#include "editorwin.h"

GHashTable *preset_commands = NULL;

static void free_preset_commands(void)
{
  if (!preset_commands)
    ;   /* commands already freed or not loaded. */
  else {
    g_hash_table_destroy(preset_commands);
    preset_commands = NULL;
  }
}

static void preset_command_about(void)
{
#ifdef HAVE_CONFIG_H
  const char *program_name = "Breeze " VERSION;
#else
  const char *program_name = "Breeze";
#endif
  const char *comments = "An application launcher with command-line style";
  const char *authors[] = {
    "Hironao Komatsu <hironao{at}users.sourceforge.net>",
    "",
    "Some parts of the code is from utilities of Oroborus\n(http://www.oroborus.org/) written by:",
    "Ken Lynch <kenlynch{at}blueyonder.co.uk>",
    "Stefan Pfetzing <dreamind{at}dreamind.de>",
    NULL
  };
  const char *copyright = "copyright (c) 2005, 2006, 2008 Hironao Komatsu";
  const char *website = "http://breeze.sourceforge.jp/";
  const char *license =
    "This program is free software; you can redistribute it and/or modify\n"
    "it under the terms of the GNU General Public License as published by\n"
    "the Free Software Foundation; either version 2 of the License, or\n"
    "(at your option) any later version.\n"
    "\n"
    "This program is distributed in the hope that it will be useful,\n"
    "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
    "GNU General Public License for more details.\n"
    "\n"
    "You should have received a copy of the GNU General Public License\n"
    "along with this program; if not, write to the Free Software\n"
    "Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.";
  GtkWidget *dialog;

  dialog = gtk_about_dialog_new();

  gtk_about_dialog_set_program_name(GTK_ABOUT_DIALOG(dialog), program_name);
  gtk_about_dialog_set_comments(GTK_ABOUT_DIALOG(dialog), comments);
  gtk_about_dialog_set_authors(GTK_ABOUT_DIALOG(dialog), authors);
  gtk_about_dialog_set_copyright(GTK_ABOUT_DIALOG(dialog), copyright);
  gtk_about_dialog_set_website(GTK_ABOUT_DIALOG(dialog), website);
  gtk_about_dialog_set_license(GTK_ABOUT_DIALOG(dialog), license);

  gtk_dialog_run(GTK_DIALOG(dialog));
  gtk_widget_destroy(dialog);
}

static void preset_command_quit(void)
{
  extern gboolean continue_loop_flag;

  continue_loop_flag = FALSE;
}

static void preset_command_reload(void)
{
  load_user_commands();
}

static void preset_command_edit(void)
{
  GtkWidget *editor = editor_win_new();
  gint response;

  response = gtk_dialog_run(GTK_DIALOG(editor));

  if (response == GTK_RESPONSE_ACCEPT)
    editor_win_save_changes(EDITOR_WIN(editor));

  gtk_widget_destroy(editor);
}

static void store_preset_command(gchar *keyword, gpointer callback)
{
  g_hash_table_insert(preset_commands, keyword, callback);
}

static void create_preset_commands_table(void)
{
  preset_commands = g_hash_table_new(g_str_hash, g_str_equal);

  store_preset_command("", preset_command_edit);
  store_preset_command("About", preset_command_about);
  store_preset_command("Edit", preset_command_edit);
  store_preset_command("Quit", preset_command_quit);
  store_preset_command("Reload", preset_command_reload);
}

gconstpointer lookup_preset_commands(const gchar *keyword)
{
  return g_hash_table_lookup(preset_commands, keyword);
}

void commands_table_foreach(GHFunc func, gpointer user_data)
{
  g_hash_table_foreach(preset_commands, func, user_data);
  g_hash_table_foreach(user_commands, func, user_data);
}

int initialize_commands(void)
{
  create_preset_commands_table();
  return load_user_commands();
}

void finalize_commands(void)
{
  free_user_commands();
  free_preset_commands();
}
