;@; this two lines are added by src
;@; $Id: bks2bsh.el,v 1.4 2001/11/04 04:59:39 takeyuki Exp $
(provide 'bks2bsh)

(require 'bo-so-lib)

;; kanji_meta_dictionary2smash_hit4bo-so-.el ɹ
;;
;; (require 'error4bmd2bsh)

;; ޥ
;;
(defun ˽Ƚ-Ͽ-pre-bsh-entry 
  (priority base-obj move-obj in-direction new-obj
	    out-obj out-direction)
  "͵§θϿ
"
  ;; base-obj ñȤ¸߲ǽʾϿ롣
  ;;
  (if (> base-obj 0)
      (princ (format "[ %d %d %d %d %d %d %d ]\n"
		     priority base-obj move-obj in-direction
		     new-obj out-obj out-direction)
	     )
    ) ; end of if
  )


(defun ˽Ƚ-compile-bks2bsh ()
  "bks ե뤫 bsh եؤѴ
"
  (setq ˽Ƚ-current-section 'bks2bsh)
  (˽Ƚ-Ѵ-write "\n\t=== bsh ե ===\n")

  (let ((dic_plist (symbol-plist '˽Ƚ-ids))
	dic prefix buffer
	(work-buffer4bks     (get-buffer-create " *bo-so-bks"))
	(work-buffer4pre-bsh (get-buffer-create " *bo-so-pre-bsh"))
	(work-buffer4bsh     (get-buffer-create " *bo-so-bsh"))
	)
    (save-excursion
      (setq dic (car dic_plist))
      (while dic
	(if (not (eq -1 (setq prefix (car (cdr dic_plist)))))
					; ե뤬 bind Ƥ
	    (progn
	      ;;
	      ;; bks ե뤫 pre bsh ؤѴ
	      ;;
	      (setq standard-input  work-buffer4bks)
	      (setq standard-output work-buffer4pre-bsh)
	      (set-buffer work-buffer4pre-bsh)
	      (erase-buffer)
	      (˽Ƚ-read-bks-file
	       (expand-file-name (concat prefix ".bks") 
				 ˽Ƚ-dictionary-directory)
	       work-buffer4bks)
	      (˽Ƚ-bks-file-to-pre-bsh)
	      ;;
	      ;; ͥ (2) (5)֤Ĥ (4)֤Ĥ
	      ;; ʪ (3) νǥȡ
	      ;; ˤꡢ֤ĤʤȤ֤ĤʪΤ
	      ;; ޤȤ롣
	      ;; ˤǤ֤ĤǤޤȤ롣
	      ;; ⤷ʣƤ顢ͥٽ¤֡
	      ;;
	      (˽Ƚ-Ѵ-write "\n\t sorting bsh entry...\n")
	      (sort-numeric-fields 2 (point-min) (point-max))
	      (sort-numeric-fields 5 (point-min) (point-max))
	      (sort-numeric-fields 4 (point-min) (point-max))
	      (sort-numeric-fields 3 (point-min) (point-max))
	      ;;
	      ;; ʼ (0) ֤
	      ;;
	      (goto-char (point-max))
	      (insert "0")
	      (goto-char (point-min))
	      ;;
	      ;; pre bsh  bsh եؤѴ
	      ;;
	      (set-buffer work-buffer4bsh)
	      (erase-buffer)
	      (insert (format ";; filename : %s\n" (concat prefix ".bsh"))
		      (format ";; creater  : %s (rev. %s)\n"
			      ˽Ƚ-bmd2bsh-filename
			      ˽Ƚ-bmd2bsh-revision)
		      (format ";; source   : %s\n" (concat prefix ".bks"))
		      )
	      (setq standard-input  work-buffer4pre-bsh)
	      (setq standard-output work-buffer4bsh)
	      (˽Ƚ-pre-bsh-to-bsh-file
	       (expand-file-name (concat prefix ".bsh")
				 ˽Ƚ-dictionary-directory))
	      )
	  ) ; end of if
	(setq dic_plist (cdr (cdr dic_plist))) ; ֤˼
	(setq dic       (car dic_plist))
	) ; end of while
      (kill-buffer work-buffer4bks)
      (kill-buffer work-buffer4pre-bsh)
      (kill-buffer work-buffer4bsh)
      ) ; end of save-excursion
    ;;
    ;; log ѥХåե point  save-excursion ᤵ
    ;; ޤΤǡ˻äƤ
    (goto-char (point-max))
    ) ; end of let
  )


(defun ˽Ƚ-read-bks-file (bks-filename work-buffer4bks)
  (save-excursion
    (set-buffer work-buffer4bks)
    ;;
    ;; ХåեˤǤˤƤäơեƤ
    ;; ֤롣θ塢ʼ (0) ХåեκǸ롣
    ;;
    (insert-file-contents bks-filename nil nil nil t) ; եɹ
    (goto-char (point-max))
    (insert "0")
    (goto-char (point-min))
    )
  
  (˽Ƚ-Ѵ-write 
   (format "\n\t-- %s -> PREBSH ---\n" bks-filename))
  )


(defun ˽Ƚ-bks-file-to-pre-bsh ()
  (let (
	bks-entry plate-type
	first-obj second-obj compound-obj
	)
    (setq ˽Ƚ-bks2bsh-previous-plate -1)
    (setq ˽Ƚ-bks2bsh-previous-base  -1)
    ;;
    ;; ʼ (0) Ĥޤ bks ХåեΥȥ
    ;; ĤĽäƤбԤ
    ;;
    (while (not (eq (setq bks-entry (read)) 0))
      (setq plate-type   (aref bks-entry 1))
      (setq first-obj    (aref bks-entry 2))
      (setq second-obj   (aref bks-entry 3))
      (setq compound-obj (aref bks-entry 0))

      (if (and (not (eq ˽Ƚ-bks2bsh-previous-plate plate-type))
	       (> ˽Ƚ-bks2bsh-previous-plate -1)
	       (< ˽Ƚ-bks2bsh-previous-plate 2))
	  (progn
	    (˽Ƚ-typeE-Ф ˽Ƚ-bks2bsh-previous-plate)
	    (setplist '˽Ƚ-α-first-plist  nil)
	    (setplist '˽Ƚ-α-second-plist nil)
	    ) ; end of progn
	  ) ; end of if

      (if (and (not (equal ˽Ƚ-bks2bsh-previous-base first-obj))
	       (and (> ˽Ƚ-bks2bsh-previous-plate 1)
		    (< ˽Ƚ-bks2bsh-previous-plate 6)))
	  (progn
	    (˽Ƚ-typeR-Ф (- ˽Ƚ-bks2bsh-previous-plate 2)
				   ˽Ƚ-bks2bsh-previous-base)
	    (setplist '˽Ƚ-α-obj--plist nil)
	    ) ; end of progn
	) ; end of if

      (cond
       ;; -------------  ----------------
       ((< plate-type 2)
	(˽Ƚ-typeE-plate plate-type compound-obj
			      first-obj second-obj))
       ;; ------------- ȿ ----------------
       ((< plate-type 6)
	(˽Ƚ-typeR-plate (- plate-type 2) compound-obj
			      first-obj second-obj))
       ;; -------------  ----------------
       (t
	(˽Ƚ-typeK-plate (- plate-type 6) compound-obj
			      first-obj second-obj))
       ) ; end of cond
      ;;
      (setq ˽Ƚ-bks2bsh-previous-plate plate-type)
      (setq ˽Ƚ-bks2bsh-previous-base  first-obj)
      ) ; end of while
    ) ; end of let
  )


(defun ˽Ƚ-pre-bsh-to-bsh-file (bsh-filename)

  (˽Ƚ-Ѵ-write 
   (format "\n\t-- PREBSH -> %s ---\n" bsh-filename))
  (princ "(setq ˽Ƚ--alist '(\n")
  ;;
  (let (
	pre-bsh-entry
	base-obj move-obj priority 
	in-direction new-obj out-obj out-direction
	(previous-base-obj 0)
	(previous-move-obj 0)
	(previous-priority 0)
	(rule-vector (make-vector 4 nil))
	)
    (while (not (eq (setq pre-bsh-entry (read)) 0))
      (setq base-obj (aref pre-bsh-entry 1))
      (setq move-obj (aref pre-bsh-entry 2))
      (setq priority (aref pre-bsh-entry 0))
      (setq in-direction  (aref pre-bsh-entry 3))
      (setq new-obj  (aref pre-bsh-entry 4))
      (setq out-obj  (aref pre-bsh-entry 5))
      (setq out-direction (aref pre-bsh-entry 6))

      ;;
      ;; base  move ΥȥʤȤ
      ;;
      (if (and (not (and (eq previous-base-obj base-obj)
			 (eq previous-move-obj move-obj)))
	       (not (= previous-move-obj 0)))
	  (progn
	    (princ (format "%s\n"
			   (cons (cons previous-move-obj previous-base-obj)
				 rule-vector)))
	    (setq rule-vector (make-vector 4 nil))
	    ) ; end of progn
	) ; end of if
      
      (if (aref rule-vector in-direction)
	  (˽Ƚ-Ѵ-write 
	   (format "ͽʣ base: %d, move: %d, dir: %d (pri: %d) = %S\n"
		   previous-move-obj previous-base-obj
		   in-direction previous-priority
		   (aref rule-vector in-direction)))
	) ; end of if
      (aset rule-vector in-direction
	    (cons new-obj
		  (cond	((eq out-obj 0) nil)
			(t              (cons out-obj out-direction))
			) ; end of cond
		  )
	    )
      (setq previous-base-obj base-obj)
      (setq previous-move-obj move-obj)
      (setq previous-priority priority)
      ) ; end of while

    (princ (format "%s\n"
		   (cons (cons previous-move-obj 
			       previous-base-obj) rule-vector)))

    ) ; end of let
  ;;
  ;;
  (princ "))\n")
  ;;
  ;; ե˽񤭹ࡣ
  ;;
  (write-region (point-min) (point-max) bsh-filename)
  )



(defun ˽Ƚ-typeE-plate (plate-type compound-obj
					first-obj second-obj)
  "̷˴ؤ
"
  ;;
  ;; ̷ξϡbase  move ֤Ĥä comp 
  ;; Ǥ͵§ͥ 3 ǸϿ
  ;; 뤤Ͼ岼ξʬϿ
  ;;

  ;; first-obj = A, second-obj = B, compound-obj = X = [AB]
  ;;
  ;; A <- B =:=> [AB]
  ;;
  (˽Ƚ-Ͽ-pre-bsh-entry 3 first-obj second-obj
			       (˽Ƚ-rotate-direction plate-type 2)  
			       compound-obj 0 0) ; 
  (˽Ƚ-Ͽ-pre-bsh-entry 3 second-obj first-obj plate-type
			       compound-obj 0 0)  ; 夫

  (put '˽Ƚ-α-first-plist first-obj
       (cons (cons second-obj compound-obj)
	     (get '˽Ƚ-α-first-plist first-obj)))
  (put '˽Ƚ-α-second-plist second-obj
       (cons (cons first-obj compound-obj)
	     (get '˽Ƚ-α-second-plist second-obj)))
  )



(defun ˽Ƚ-typeR-plate (plate-type compound-obj
					base-obj move-obj)
  "ȿͷ˴ؤ
"
  ;;
  ;; ȿͷξϡbase  move ֤Ĥä comp 
  ;; Ǥ͵§ͥ 5 ()  4 () ǸϿ
  ;;
  ;; plate-type : 0 (), 1 (), 2 (), 3 ()
  ;;

  (˽Ƚ-Ͽ-pre-bsh-entry 5 base-obj move-obj
			       (˽Ƚ-rotate-direction plate-type 2)
			       compound-obj 0 0)
  (˽Ƚ-Ͽ-pre-bsh-entry 4 base-obj move-obj 
			       (˽Ƚ-rotate-direction plate-type 1)
			       compound-obj 0 0)
  ;;
  (put '˽Ƚ-α-obj--plist move-obj compound-obj)
  ;; 줬 plist ǤɬϤʤ
  ;; ʣå򤹤ʤɬפ
  )
  


(defun ˽Ƚ-typeK-plate (plate-type compound-obj
					base-obj move-obj)
  "Ʒ˴ؤ
"
  ;; Ʒξϡbase  move ֤Ĥä comp 
  ;; Ǥ͵§ͥ 6 ǸϿ
  ;;
  (˽Ƚ-Ͽ-pre-bsh-entry 6 base-obj move-obj
			       (˽Ƚ-rotate-direction plate-type 2)
			       compound-obj 0 0)
  )



(defun ˽Ƚ-typeR-Ф(plate-type base-obj)
  "ȿͷβФΤ뵬§
plate-type ȤǤ base-obj ̤ʪ
٤Ƥȹ礻ФƤν
"
  (let (
	(work-list-1 (symbol-plist '˽Ƚ-α-obj--plist))
	work-list-2
	move-obj-1 move-obj-2
	compound-obj-1 compound-obj-2 
	)
    (setq move-obj-1     (car work-list-1))
    (while move-obj-1
      (setq compound-obj-1 (car (cdr work-list-1)))

      (setq work-list-2 (symbol-plist '˽Ƚ-α-obj--plist))
      (setq move-obj-2     (car work-list-2))
      (while move-obj-2
	(setq compound-obj-2 (car (cdr work-list-2)))
	;;
	;; ͥ 2 ()  1 () ǸϿ
	;;
	(˽Ƚ-Ͽ-pre-bsh-entry 2 compound-obj-1 move-obj-2
				     (˽Ƚ-rotate-direction plate-type 2)
				     compound-obj-2 move-obj-1
				     (˽Ƚ-rotate-direction plate-type 3))
	(˽Ƚ-Ͽ-pre-bsh-entry 1 compound-obj-1 move-obj-2
				     (˽Ƚ-rotate-direction plate-type 1)
				     compound-obj-2 move-obj-1 plate-type)
	;;
	(setq work-list-2 (cdr (cdr work-list-2)))  ; ֤˼
	(setq move-obj-2  (car work-list-2))
	) ; end of while
      (setq work-list-1 (cdr (cdr work-list-1)))  ; ֤˼
      (setq move-obj-1  (car work-list-1))
      ) ; end of while
    
    )
  )


(defun ˽Ƚ-typeE-Ф(plate-type)
  "Ʊ̷βФΤ뵬§
"
  (let (
	(first-plist  (symbol-plist '˽Ƚ-α-first-plist))
	(second-plist (symbol-plist '˽Ƚ-α-second-plist))
	pivot-obj
	obj-pair-list-1
	obj-pair-list-2
	)
    (setq pivot-obj (car first-plist))
    (while pivot-obj
      (setq obj-pair-list-1 (car (cdr first-plist)))
      (if (setq obj-pair-list-2 (get '˽Ƚ-α-second-plist pivot-obj))
	  ;;
	  ;; pivot-obj       : ˤ X
	  ;; obj-pair-list-1 : X αˤ A Ȥ餫
	  ;;                   ʪ S  (S = [XA]) Υꥹ 
	  ;;                   (A1,S1), (A2,S2), ...
	  ;; obj-pair-list-2 : X κˤ B Ȥ餫
	  ;;                   ʪ T  (T = [BX]) Υꥹ
	  ;;                   (B1,T1), (B2,T2), ...
	  ;;
	  (mapcar
	   (lambda (y) ;    Ai = (car y), Si = (cdr y)
	     (mapcar 
	      (lambda (z) ; Bi = (car z), Ti = (cdr z)
		;;
		;; B->[XA] ... [BX]->A
		;;     S        T 
		;;
		(˽Ƚ-Ͽ-pre-bsh-entry 0
 		 (cdr y) (car z) plate-type
		 (cdr z) (car y) plate-type)
		;;
		;; [BX]<-A ... B<-[XA]
		;;
		;;
		(˽Ƚ-Ͽ-pre-bsh-entry 0
 		 (cdr z) (car y) (˽Ƚ-rotate-direction plate-type 2)
		 (cdr y) (car z) (˽Ƚ-rotate-direction plate-type 2))
		) obj-pair-list-2)
	     ) obj-pair-list-1)
	) ; end of if
      ;;
      (setq first-plist (cdr (cdr first-plist)))  ; ֤˼
      (setq pivot-obj  (car first-plist))
      ) ; end of while
    ) ; end of let
  )

;;;;;;;;;;;;;;;;;;;;;;;;; end of file ;;;;;;;;;;;;;;;;;;;;;;;;;
