# $Id: bos_user.rb,v 1.9 2004/09/07 02:22:31 nisi Exp $

def pre_bos_user_init
	@session['uid'] = nil if @session['uid'] == ""
	if @session['uid'] then
		@user = BosUser.new(@session['uid'],self)
	end
	tu = @params["bos_user_login_uid"][0] || ""
	tp = @params["bos_user_login_pwd"][0] || ""
	if tu != "" && tp != "" then
		@user = BosUser.new(tu,self)
		@user.login(tp)
	end
	
	if @params["bos_user_logout"][0] == 'on' && @user then
		@user.logout
	end
end

def bos_user_edit
	return nil if !@user
	return nil if !@cgi["uid"][0]
	uid = @cgi["uid"][0]
	user = BosUser.new(uid,self)
	
	if @user.prop[:user_level] == 'a' || @user.prop[:user_id] == user.pre_prop[:user_id] then
		if @cgi["bos_user_edit"][0] == "on" then
			begin
				bidate = Date.parse(@cgi["in_bos_birth"][0].to_s)
			rescue
				bidate = nil
			end
			user.pre_prop[:password]        = @cgi["in_bos_password"][0].to_s == "" ? user.pre_prop[:password] : BosUser::cmd5(@cgi["in_bos_password"][0].to_s)
			user.pre_prop[:mail_address]    = @cgi["in_bos_mail_address"][0].to_s
			user.pre_prop[:sex]             = @cgi["in_bos_sex"][0].to_s
			user.pre_prop[:birth]           = bidate
			user.pre_prop[:user_level]      = @cgi["in_bos_user_level"][0].to_s
			user.commit
		end
		{
			:bos_user_id         => user.pre_prop[:user_id],
			:uid                 => a(:value => user.pre_prop[:user_id]),
			:in_bos_user_id      => a(:value => user.pre_prop[:user_id]){{}},
			:in_bos_password     => a(:value => "", :type =>"password" ){{}},
			:in_bos_mail_address => a(:value => user.pre_prop[:mail_address]){{}},
			:in_bos_sex     => {:user_sex => [
				a(:value => "f",:selected => user.pre_prop[:sex] == "f" ? "selected" : nil){""},
				a(:value => "m",:selected => user.pre_prop[:sex] == "m" ? "selected" : nil){""},
				a(:value => "o",:selected => user.pre_prop[:sex] == "o" ? "selected" : nil){""}
			]},
			:in_bos_birth   => a(:value => (user.pre_prop[:birth] ? user.pre_prop[:birth].to_sql : "")){{}},
			:in_bos_user_level   => {:user_level => [
				a(:value => "a",:selected => user.pre_prop[:user_level] == "a" ? "selected" : nil){""},
				a(:value => "p",:selected => user.pre_prop[:user_level] == "p" ? "selected" : nil){"̥桼"}
			]}
		}
	else
		"¤ޤ"
	end
end

def bos_user_newlink
	a(:href => "?uid="){{}}
end

def bos_user_listlink
	a(:href => "?"){{}}
end

def bos_user_list
	return nil if !(@cgi["uid"][0] == "")
	user = BosUser.new("",self)
	ret = []
	
	user.get_list.each{|rs|
		ret << {
			:bos_user_list_id    => rs[:user_id],
			:bos_user_list_level => rs[:user_level],
			:bos_user_list_edit  => a(:href => "?uid=#{rs[:user_id]}"){{}}} }
	
	{:bos_user_list_rec => ret}
end

def bos_user_login
	return nil if @session['uid']
	{:bos_user_login_form => {
		:bos_user_login_uid => a(:name => "bos_user_login_uid", :value => (@params["bos_user_login_uid"][0] || "")){{}},
		:bos_user_login_pwd => a(:name => "bos_user_login_pwd", :value => ""){{}}
	}}
end

def bos_user_logout
	return nil if !@session['uid']
	true
end

def bos_user_login_user_id
	return nil if !@user
	@user.prop[:user_id]
end

def bos_user_admin_only_dev
	return nil if !@user
	@user.prop[:user_level] == "a"
end

def bos_user_admin_only_page
	if @user && @user.prop[:user_level] == "a" then
		# ǧʤ󤫤ää
	else
		print "Location: #{$bos_prop[:site_url]}#{$bos_prop[:err_doc]}\n\n"
	end
end

def bos_user_admin_items
	ret = []
	outpage = ["index","admside"]
	Dir.glob("#{$bos_prop[:admin_dir]}/*.#{$bos_prop[:bos_template]}").sort.each{|fl|
		if /.+\/(.+)\.#{$bos_prop[:bos_template]}/ =~ fl then
			tmpt = $1
			ret << {:admin_item => a(:href => "#{tmpt}.#{$bos_prop[:bos_template]}"){ tmpt } } if !outpage.include?(tmpt)
		end
	}
	ret
end

