# URLQueryString
#
#  URLQueryinput-form
#
# $Id: urlquery.rb,v 1.1 2004/06/20 02:46:16 nisi Exp $
#

class URLQueryString
	attr_accessor :dat
	
	def initialize(indat)
		indat = indat.dup
		@dat = {}
		case indat
		when String
			indat = indat.gsub('&amp;','&')
			indat = indat[1..-1] if indat[0..0] == "?"
			indat.split('&').each{|inn|
				k,v = inn.split('=')
				v = v.split(',') if v.include?(',')
				@dat.store(k.intern ,v)
			}
		when Hash
			indat.each{|k,v|
				k = k.intern if k.class != Symbol
				if v.class == Array then
					case v.size
					when 1
						@dat.store(k ,v[0])
					when 0
						@dat.store(k ,nil)
					else
						@dat.store(k ,v)
					end
				end
			}
		end
	end
	
	def to_s
		ret = []
		@dat.each{|k,v|
			case v
			when Array
				ret << "#{k}=#{v.join(',')}"
			when NilClass,FalseClass
			else
				ret << "#{k}=#{v}"
			end
		}
		ret = ret.join('&')
	end
	
	def to_form
		ret = []
		@dat.each{|k,v|
			case v
			when Array
				ret << "<input name=\"#{k}\" type=\"hidden\" value=\"#{v.join(',')}\">\n"
			when NilClass,FalseClass
			else
				ret << "<input name=\"#{k}\" type=\"hidden\" value=\"#{v}\">\n"
			end
		}
		ret = ret.join
	end

end
