/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.bookshelf2;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tonouchi.bookshelf2.Book;
import org.tonouchi.bookshelf2.SlideShowPanel;

public class BookInfoPanel
extends JPanel
implements ActionListener {
    private JTextField jtfCategories = new JTextField(16);
    private JTextField jtfAuthor = new JTextField(16);
    private JTextField jtfTitle = new JTextField(16);
    private JTextField jtfRate = new JTextField(16);
    private JTextArea jtfTags = new JTextArea(8, 16);
    private JTextArea jtfComment = new JTextArea(8, 16);
    private JButton jbRead = new JButton("Slide show");
    private Book book = null;

    public BookInfoPanel() {
        this.setBackground(Color.GRAY);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.jbRead.addActionListener(this);
        this.jtfCategories.setBorder(BorderFactory.createTitledBorder("Category"));
        this.jtfAuthor.setBorder(BorderFactory.createTitledBorder("Author"));
        this.jtfTitle.setBorder(BorderFactory.createTitledBorder("Title"));
        this.jtfRate.setBorder(BorderFactory.createTitledBorder("Rate"));
        this.jtfCategories.setBackground(Color.GRAY);
        this.jtfAuthor.setBackground(Color.GRAY);
        this.jtfTitle.setBackground(Color.GRAY);
        this.jtfRate.setBackground(Color.GRAY);
        this.jtfTags.setBackground(Color.GRAY);
        this.jtfComment.setBackground(Color.GRAY);
        this.jtfCategories.setEditable(false);
        this.jtfAuthor.setEditable(false);
        this.jtfTitle.setEditable(false);
        this.jtfRate.setEditable(false);
        this.jtfComment.setEditable(false);
        this.jtfTags.setEditable(false);
        this.jtfComment.setLineWrap(true);
        this.jtfTags.setLineWrap(true);
        JScrollPane jspTags = new JScrollPane(this.jtfTags);
        JScrollPane jspComment = new JScrollPane(this.jtfComment);
        jspTags.setBackground(Color.GRAY);
        jspComment.setBackground(Color.GRAY);
        jspTags.setBorder(BorderFactory.createTitledBorder("Tags"));
        jspComment.setBorder(BorderFactory.createTitledBorder("Comment"));
        jspTags.setHorizontalScrollBarPolicy(31);
        jspComment.setHorizontalScrollBarPolicy(31);
        this.addComponent(layout, 0, 0, this.jtfCategories);
        this.addComponent(layout, 0, 1, this.jtfAuthor);
        this.addComponent(layout, 0, 2, this.jtfTitle);
        this.addComponent(layout, 0, 3, this.jtfRate);
        this.addComponent(layout, 0, 4, jspTags);
        this.addComponent(layout, 0, 5, jspComment);
        this.addComponent(layout, 0, 6, this.jbRead);
    }

    private void addComponent(GridBagLayout layout, int x, int y, Component c) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        layout.addLayoutComponent(c, gbc);
        this.add(c);
    }

    public void addActionListener(ActionListener al) {
        this.jbRead.addActionListener(al);
    }

    public void updateInfo(Book book) {
        this.jtfCategories.setText(book.getCategory());
        this.jtfAuthor.setText(book.getAuthor());
        this.jtfTitle.setText(book.getTitle());
        this.jtfRate.setText(Integer.toString(book.getRate()));
        String tagText = null;
        List<String> tagList = book.getTags();
        if (tagList.size() == 0) {
            tagText = "";
        } else {
            StringBuffer buf = new StringBuffer(tagList.get(0));
            for (int i = 1; i < tagList.size(); ++i) {
                buf = buf.append(' ').append(tagList.get(i));
            }
            tagText = buf.toString();
        }
        this.jtfTags.setText(tagText);
        this.jtfComment.setText(book.getComment());
        this.book = book;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.book != null) {
            final JFrame jfSlideshow = new JFrame();
            final SlideShowPanel slideshow = new SlideShowPanel(this.book.getFilePath());
            jfSlideshow.add(slideshow);
            jfSlideshow.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 37: {
                            slideshow.rewind();
                            break;
                        }
                        case 38: {
                            slideshow.top();
                            break;
                        }
                        case 40: {
                            slideshow.last();
                            break;
                        }
                        case 27: {
                            jfSlideshow.setVisible(false);
                            break;
                        }
                        default: {
                            slideshow.forward();
                        }
                    }
                }
            });
            jfSlideshow.setSize(640, 480);
            jfSlideshow.setVisible(true);
        }
    }
}

